/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.httpfacebook.util;

import java.util.Enumeration;
import java.util.Vector;

public class StringMap {
    private Vector keys;
    private Vector values;

    public StringMap() {
        this.keys = new Vector();
        this.values = new Vector();
    }

    public StringMap(int initialCapacity) {
        this.keys = new Vector(initialCapacity);
        this.values = new Vector(initialCapacity);
    }

    public void put(String key, String value) {
        this.put(key, value, this.keys.size());
    }

    public void put(String key, String value, int pos) {
        if (key != null) {
            this.delete(key);
            if (value != null) {
                if (pos < this.keys.size()) {
                    this.keys.insertElementAt(key, pos);
                    this.values.insertElementAt(value, pos);
                } else {
                    this.keys.addElement(key);
                    this.values.addElement(value);
                }
            }
        }
    }

    public String get(String key) {
        String value = null;
        int pos = this.keys.indexOf(key);
        if (pos >= 0) {
            value = (String)this.values.elementAt(pos);
        }
        return value;
    }

    public void delete(String key) {
        int pos = this.keys.indexOf(key);
        if (pos >= 0) {
            this.keys.removeElementAt(pos);
            this.values.removeElementAt(pos);
        }
    }

    public void deleteAll() {
        this.keys.removeAllElements();
        this.values.removeAllElements();
    }

    public int size() {
        return this.keys.size();
    }

    public Enumeration keys() {
        return this.keys.elements();
    }

    public Enumeration values() {
        return this.values.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.keys.size()) {
            sb.append(this.keys.elementAt(i));
            sb.append("=");
            sb.append(this.values.elementAt(i));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

