/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.controller;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.controller.ControllerListener;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.model.pedometer.UtilityPedometer;

public class Controller
implements GuiListener {
    private UtilityPedometer pedometer;
    protected Gui view;
    protected ControllerListener listener;
    protected Datastore model;

    public Controller(Gui view, Datastore model) {
        Logger.printOut("[WALKMATE]: Controller - constructor");
        this.view = view;
        this.model = model;
    }

    public void setListener(ControllerListener listener) {
        Logger.printOut("[WALKMATE]: Controller - setListener - listener: " + listener);
        this.listener = listener;
    }

    public void startController() {
        Logger.printOut("[WALKMATE]: Controller - startController");
        this.view.initializeSteps();
        if (this.initializePedometer()) {
            Logger.printOut("[WALKMATE]: Controller - startController - Pedometer OK");
            if (this.view.startView()) {
                Logger.printOut("[WALKMATE]: Controller - startController - Start View OK");
                this.pedometer.addListener(this.view);
            } else {
                Logger.printOut("[WALKMATE]: Controller - startController - Start View NOK ????");
                this.listener.controlEvent(0);
            }
        } else {
            Logger.printOut("[WALKMATE]: Controller - startController - Pedometer NOK ????");
            this.listener.controlEvent(0);
        }
    }

    public void stopController() {
        Logger.printOut("[WALKMATE]: Controller - stopController");
        if (this.pedometer == null) {
            return;
        }
        Logger.printOut("[WALKMATE]: Controller - stopping sensor");
        this.pedometer.stopSensor();
        this.view.stopView();
        this.view = null;
    }

    public final boolean initializePedometer() {
        Logger.printOut("[WALKMATE]: Controller - initializePedometer");
        this.pedometer = new UtilityPedometer();
        return this.pedometer.startSensor();
    }

    public void controlViewEvent(int event) {
        Logger.printOut("[WALKMATE]: Controller - controlViewEvent");
        switch (event) {
            case 23: 
            case 26: {
                Logger.printOut("[WALKMATE]: Controller - controlViewEvent - EXIT_COMMAND/EXIT_APPLICATION");
                this.listener.controlEvent(1, this.view.getIsActive());
                break;
            }
            case 31: 
            case 32: {
                Logger.printOut("[WALKMATE]: Controller - controlViewEvent - UPDATE_STEPS/UPDATE_MOVEMENT");
            }
        }
    }
}

