/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.controller;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.controller.Controller;
import com.sonyericsson.walkmate.facebook.utils.RMSAuth;
import com.sonyericsson.walkmate.gui.ConnectSetup;
import com.sonyericsson.walkmate.gui.FbAlert;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.GuiFacebook;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.gui.LocatorAction;
import com.sonyericsson.walkmate.gui.LoginCanvas;
import com.sonyericsson.walkmate.gui.MessageSetup;
import com.sonyericsson.walkmate.gui.PostAction;
import com.sonyericsson.walkmate.gui.SignInAction;
import com.sonyericsson.walkmate.gui.SignOutAction;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.model.datastore.FbDatastore;
import com.sonyericsson.walkmate.model.datastore.FbInfoDatastore;
import com.sonyericsson.walkmate.model.datastore.PersonalMessageDatastore;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStoreException;

public class ControllerFacebook
extends Controller
implements GuiListener {
    private static final int WAITING_FOR_NOTHING = 0;
    private static final int WAITING_FOR_LOCATOR_ACTION = 1;
    private static final int WAITING_FOR_SIGN_IN_ACTION = 2;
    private static final int WAITING_FOR_POST_ACTION = 3;
    private static final int WAITING_FOR_INPUT_LOGIN = 4;
    private static final int WAITING_FOR_MESSAGE = 5;
    private static final int WAITING_FOR_MESSAGE_SETUP = 6;
    private static final int WAITING_FOR_CONNECT_SETUP = 7;
    private static final int ACTIVE_ALWAYS = 1;
    private static final int ACTIVE_NO = 3;
    private static final int SUCCESS_LOGIN = 1;
    private static final int INVALID_USER_PASS = 2;
    private static final int CONNECTION_ERROR = 3;
    private static final int SUCCESS_POST = 5;
    private static final String ALWAYS = "ALWAYS";
    private static final boolean LOGIN_BUTTON = true;
    private static final boolean PUBLISH_BUTTON = false;
    private RMSAuth rmsAuth;
    private PersonalMessageDatastore personalMessageDatastore;
    private LoginCanvas loginCanvas;
    private MessageSetup messageSetup;
    private SignInAction signIn;
    private PostAction postComment;
    private LocatorAction getLocation;
    private ConnectSetup connectSetup;
    private int stateGui = 0;
    private boolean isLoginButton = false;
    private FbAlert alert;
    private Display display;

    public ControllerFacebook(Display display, Gui view, Datastore model) {
        super(view, model);
        this.display = display;
        Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - constructor - this: " + this);
        this.rmsAuth = RMSAuth.getRMSAuth();
        this.personalMessageDatastore = new PersonalMessageDatastore();
        this.checkInitialState();
    }

    public void controlViewEvent(int event) {
        Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - controlViewEvent");
        switch (event) {
            case 27: {
                Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - controlViewEvent - PUBLISH_COMMAND");
                this.handlePublishCmd();
                break;
            }
            case 28: {
                Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - controlViewEvent - LOGIN_COMMAND");
                this.handleLoginCmd();
                break;
            }
            case 29: {
                Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - controlViewEvent - SELECT_COMMAND");
                this.handleSelectCmd();
                break;
            }
            case 5: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CONNECT_SETUP_SELECT");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                this.handleSelectCmd();
                Logger.printOut("       TO: " + this.printStateGui());
                break;
            }
            case 15: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CONNECT_SETUP_BACK");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 6: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - LOGIN_CANVAS_LOGIN");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                if (this.rmsAuth.getSessionKey().equalsIgnoreCase("") || this.isLoginButton) {
                    this.signIn.setUser(this.loginCanvas.getUser());
                    this.signIn.setPassword(this.loginCanvas.getPassword());
                    Thread logingUser = new Thread(this.signIn);
                    logingUser.start();
                    this.stateGui = 2;
                } else {
                    ((GuiFacebook)this.view).addCommandAF(true);
                    this.getLocation = new LocatorAction(this.display, this);
                    Thread locator = new Thread(this.getLocation);
                    locator.start();
                    this.stateGui = 1;
                }
                Logger.printOut("       TO: " + this.printStateGui());
                break;
            }
            case 16: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - LOGIN_CANVAS_LOGIN_BACK");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 7: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - LOGIN_CANVAS_INFO_LOGIN");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_MESSAGE");
                this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_FACEBOOK_LOGIN_INFO1_TXT"), Translator.getMessage("WF_FACEBOOK_LOGIN_INFO2_TXT"), null, false, false);
                this.display.setCurrent((Displayable)this.alert);
                this.stateGui = 5;
                break;
            }
            case 1: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - END_LOGIN_THREAD");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                this.stateGui = 0;
                if (2 == this.signIn.getUserLoginState()) {
                    ((GuiFacebook)this.view).removeLoginCommand();
                    this.display.setCurrent(this.view.getMainDisplayable());
                    Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - INVALID_USER_PASS");
                    this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_ERROR_INCORRECT_EMAIL_TITLE_HLP"), Translator.getMessage("WF_ERROR_INCORRECT_EMAIL_MSG_HLP"), null, true, true);
                    this.display.setCurrent((Displayable)this.alert);
                    this.stateGui = 5;
                } else if (3 == this.signIn.getUserLoginState()) {
                    Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CONNECTION_ERROR - display: " + this.display);
                    ((GuiFacebook)this.view).removeLoginCommand();
                    this.display.setCurrent(this.view.getMainDisplayable());
                    this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_ERROR_INTERNET_INTERRUPTED_HLP"), true);
                    this.display.setCurrent((Displayable)this.alert);
                    this.stateGui = 5;
                } else if (1 == this.signIn.getUserLoginState()) {
                    Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - SUCCESS_LOGIN");
                    if (this.isLoginButton) {
                        this.isLoginButton = false;
                        this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_FACEBOOK_LOGIN_SAVED_TITLE_TXT"), Translator.getMessage("WF_FACEBOOK_LOGIN_SAVED_MSG1_TXT"), Translator.getMessage("WF_FACEBOOK_LOGIN_SAVED_MSG2_TXT"), true, false);
                        this.display.setCurrent((Displayable)this.alert);
                        this.stateGui = 5;
                    } else {
                        ((GuiFacebook)this.view).addCommandAF(true);
                        this.getLocation = new LocatorAction(this.display, this);
                        Thread locator = new Thread(this.getLocation);
                        locator.start();
                        this.stateGui = 1;
                    }
                } else {
                    this.display.setCurrent(this.view.getMainDisplayable());
                    this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_ERROR_INTERNET_INTERRUPTED_HLP"), true);
                    this.display.setCurrent((Displayable)this.alert);
                    this.stateGui = 5;
                }
                Logger.printOut("       TO: " + this.printStateGui());
                break;
            }
            case 3: 
            case 25: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - END_LOCATOR_THREAD // OK_GEONAMES_INFO");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                this.messageSetup = this.getLocation.getConnectionStatus() ? new MessageSetup(this.display, this.getLocation.getCellName(), this, this.model) : new MessageSetup(this.display, "", this, this.model);
                FbInfoDatastore data = new FbInfoDatastore();
                if (data.getSize("FACEBOOK_GEONAME_DB") == 0) {
                    this.showStatus();
                } else {
                    this.display.setCurrent((Displayable)this.messageSetup);
                }
                this.stateGui = 6;
                Logger.printOut("      TO: WAITING_FOR_MESSAGE_SETUP");
                break;
            }
            case 11: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - MSG_TO_BE_PUBLISHED");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                this.postComment = this.personalMessageDatastore.getMessageSize() != 0 ? new PostAction(this.display, String.valueOf(this.messageSetup.createDefaultMessage()) + " " + this.personalMessageDatastore.getPersonalMessage(), this) : new PostAction(this.display, this.messageSetup.createDefaultMessage(), this);
                Thread posting = new Thread(this.postComment);
                posting.start();
                this.stateGui = 3;
                Logger.printOut("      TO: WAITING_FOR_POST_ACTION");
                break;
            }
            case 2: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - MSG_TO_BE_PUBLISHED");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui());
                this.stateGui = 0;
                if (5 == this.postComment.getPostResult()) {
                    try {
                        ((FbDatastore)this.model).setFacebookIconForToday(this.model.getStepsForToday(), this.model.getStepsForToday());
                        int[][] dataForLastWeek = null;
                        try {
                            dataForLastWeek = ((FbDatastore)this.model).getFacebookStepsForLastWeek();
                        }
                        catch (RecordStoreException e) {
                            Logger.printOut("[WALKMATE]: Error to access the dataStore: " + e.getMessage());
                            e.printStackTrace();
                        }
                        ((GuiFacebook)this.view).updateFbIconLastWeek(dataForLastWeek);
                    }
                    catch (RecordStoreException ex) {
                        ex.printStackTrace();
                    }
                    this.alert = new FbAlert(this, this.display, String.valueOf(this.rmsAuth.getName()) + " " + this.messageSetup.createDefaultMessage(), this.personalMessageDatastore.getPersonalMessage(), null, true, false);
                    this.display.setCurrent((Displayable)this.alert);
                    this.stateGui = 5;
                } else if (3 == this.postComment.getPostResult()) {
                    this.alert = new FbAlert(this, this.display, Translator.getMessage("WF_ERROR_INTERNET_INTERRUPTED_HLP"), true);
                    this.display.setCurrent((Displayable)this.alert);
                    this.stateGui = 5;
                } else {
                    ((GuiFacebook)this.view).removeLoginCommand();
                    this.rmsAuth.clearSessionKey();
                    this.rmsAuth.clearUserEmail();
                    this.signIn.setListener(this);
                    this.loginCanvas = new LoginCanvas(this.display, this);
                    this.display.setCurrent((Displayable)this.loginCanvas);
                    this.stateGui = 4;
                }
                Logger.printOut("      TO: " + this.printStateGui());
                break;
            }
            case 33: {
                Logger.printOut("[WALKMATE]: ControlletrActivityFeeds1_0 - notifyEvent - END_KEY_ON_TEXTBOX");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 4: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - MSG_TO_BE_PUBLISHED");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 18: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CANCEL_OPERATION_KEY_RELEASED");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 13: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - OK_PUBLISHING_RESULT");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 19: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - MESSAGE_SETUP_BACK");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 14: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - OK_INFO_LOGIN");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_INPUT_LOGIN");
                this.stateGui = 4;
                this.display.setCurrent((Displayable)this.loginCanvas);
                break;
            }
            case 17: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - OK_WRONG_USER_PASS");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_INPUT_LOGIN");
                this.stateGui = 4;
                this.display.setCurrent((Displayable)this.loginCanvas);
                break;
            }
            case 9: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CANCEL_LOCATION_ACTION");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 10: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CANCEL_SINGIN_ACTION");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 12: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - CANCEL_POST_ACTION");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 24: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - OK_WALLPAPER_INFO");
                Logger.printOut("[WALKMATE]: FROM: " + this.printStateGui() + "      TO: WAITING_FOR_NOTHING");
                this.stateGui = 0;
                this.display.setCurrent(this.view.getMainDisplayable());
                break;
            }
            case 30: {
                Logger.printOut("[WALKMATE]: GuiFacebook - notifyEvent - SHOW_NOTIFY");
                this.showNotifyFromView();
            }
            default: {
                Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - notifyEvent - ELSE");
                super.controlViewEvent(event);
            }
        }
    }

    protected void showNotifyFromView() {
        Logger.printOut("[WALKMATE]: GuiFacebook - showNotifyFromView");
        switch (this.stateGui) {
            case 0: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_NOTHING");
                ((GuiFacebook)this.view).verifyStatus();
                break;
            }
            case 1: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_LOCATOR_ACTION");
                if (this.getLocation == null) break;
                this.getLocation.setCurrentCanvas();
                break;
            }
            case 2: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_SIGN_IN");
                if (this.signIn == null) break;
                this.signIn.setCurrentCanvas();
                break;
            }
            case 3: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_POST_ACTION");
                if (this.postComment == null) break;
                this.postComment.setCurrentCanvas();
                break;
            }
            case 4: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_INPUT_LOGIN");
                this.display.setCurrent((Displayable)this.loginCanvas);
                break;
            }
            case 5: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_MESSAGE");
                this.display.setCurrent((Displayable)this.alert);
                break;
            }
            case 6: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_MESSAGE_SETUP");
                this.display.setCurrent((Displayable)this.messageSetup);
                break;
            }
            case 7: {
                Logger.printOut("[WALKMATE]: GuiFacebook - showNotify - WAITING_FOR_CONNECT_SETUP");
                this.display.setCurrent((Displayable)this.connectSetup);
            }
        }
    }

    private void showStatus() {
        FbAlert fbAlert = new FbAlert(Translator.getMessage("WF_LEGAL_INFORMATION_MSG_TXT"), this, this.display, true);
        this.display.setCurrent((Displayable)fbAlert);
    }

    private void handlePublishCmd() {
        this.isLoginButton = false;
        if (this.rmsAuth.getConnectivityStatus().equalsIgnoreCase(ALWAYS)) {
            this.signIn.setListener(this);
            if (this.rmsAuth.getSessionKey().equalsIgnoreCase("")) {
                this.loginCanvas = new LoginCanvas(this.display, this);
                this.display.setCurrent((Displayable)this.loginCanvas);
                this.stateGui = 4;
            } else {
                this.display.setCurrent(this.view.getMainDisplayable());
                this.getLocation = new LocatorAction(this.display, this);
                Thread locator = new Thread(this.getLocation);
                locator.start();
                this.stateGui = 1;
            }
        } else {
            this.connectSetup = new ConnectSetup(this, this.display);
            this.display.setCurrent((Displayable)this.connectSetup);
            this.stateGui = 7;
        }
    }

    private void checkInitialState() {
        Logger.printOut("[WALKMATE]: ControllerActivityFeeds1_0 - checkInitialState");
        this.signIn = new SignInAction(this.display);
        this.signIn.setListener(this);
        if (!this.rmsAuth.getSubscriberNumber().equalsIgnoreCase(this.signIn.getSubscriberNumber()) && !this.rmsAuth.getSessionKey().equalsIgnoreCase("")) {
            SignOutAction signOut = new SignOutAction();
            signOut.handleAction();
            this.rmsAuth = RMSAuth.getRMSAuth();
        }
        if (!this.rmsAuth.getSessionKey().equalsIgnoreCase("")) {
            ((GuiFacebook)this.view).addCommandAF(true);
        }
        ((GuiFacebook)this.view).addCommandAF(false);
    }

    private void handleLoginCmd() {
        this.isLoginButton = true;
        if (this.rmsAuth.getConnectivityStatus().equalsIgnoreCase(ALWAYS)) {
            this.signIn.setListener(this);
            this.loginCanvas = new LoginCanvas(this.display, this);
            this.display.setCurrent((Displayable)this.loginCanvas);
            this.stateGui = 4;
        } else {
            this.connectSetup = new ConnectSetup(this, this.display);
            this.display.setCurrent((Displayable)this.connectSetup);
            this.stateGui = 7;
        }
    }

    private void handleSelectCmd() {
        this.stateGui = 0;
        this.display.setCurrent(this.view.getMainDisplayable());
        if (this.connectSetup.getActiveState() == 3) {
            this.isLoginButton = false;
        } else {
            if (this.connectSetup.getActiveState() == 1) {
                this.rmsAuth.setConnectivityStatus(ALWAYS);
            }
            this.signIn.setListener(this);
            if (this.rmsAuth.getSessionKey().equalsIgnoreCase("") || this.isLoginButton) {
                this.loginCanvas = new LoginCanvas(this.display, this);
                this.display.setCurrent((Displayable)this.loginCanvas);
                this.stateGui = 4;
            } else {
                this.display.setCurrent(this.view.getMainDisplayable());
                this.getLocation = new LocatorAction(this.display, this);
                Thread locator = new Thread(this.getLocation);
                locator.start();
                this.stateGui = 1;
            }
        }
    }

    private String printStateGui() {
        switch (this.stateGui) {
            case 0: {
                return "WAITING_FOR_NOTHING";
            }
            case 1: {
                return "WAITING_FOR_LOCATOR_ACTION";
            }
            case 2: {
                return "WAITING_FOR_SIGN_IN_ACTION";
            }
            case 3: {
                return "WAITING_FOR_POST_ACTION";
            }
            case 4: {
                return "WAITING_FOR_INPUT_LOGIN";
            }
            case 5: {
                return "WAITING_FOR_MESSAGE";
            }
            case 6: {
                return "WAITING_FOR_MESSAGE_SETUP";
            }
            case 7: {
                return "WAITING_FOR_CONNECT_SETUP";
            }
        }
        return "ERROR!!!!!";
    }
}

