/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.ModelListener;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.utils.DateUtils;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStoreException;

public class Gui
extends GameCanvas
implements ModelListener,
CommandListener,
Runnable {
    protected int COLOR_LINE_HEALTH = 5612828;
    protected int COLOR_LINE_SCALE = 0x4D4D4D;
    protected int COLOR_TEXT_STEPS = 0xFFFFFF;
    protected int COLOR_TEXT_HEALTH = 5612828;
    protected int COLOR_TEXT_AVERAGE = 0x909090;
    protected int COLOR_TEXT_HEADLINES = 0;
    protected int COLOR_TEXT_THISWEEK = 0xFFFFFF;
    protected int COLOR_TEXT_PASTWEEK = 0x767777;
    protected int COLOR_BAR_HEALTH_TOP = 6732841;
    protected int COLOR_BAR_HEALTH_FRONT = 5612828;
    protected int COLOR_BAR_HEALTH_SIDE = 5934626;
    protected int COLOR_BAR_HEALTH_AFTER_TOP = 6652741;
    protected static int COLOR_BAR_HEALTH_AFTER_FRONT = 3170317;
    protected int COLOR_BAR_HEALTH_AFTER_SIDE = 1919488;
    protected int COLOR_LINE_AVERAGE = 0xA0A0A0;
    protected int COLOR_LINE_SCALE_DARK = 0x202020;
    protected int COLOR_TEXT_SCALE = 0x838383;
    protected int COLOR_TEXT_HEALTH_AFTER = 3170317;
    protected int COLOR_TEXT_SHADOW = 0;
    protected int COLOR_BAR_BEFORE_TOP = 10857648;
    protected int COLOR_BAR_BEFORE_FRONT = 8555151;
    protected int COLOR_BAR_BEFORE_SIDE = 6187634;
    protected int COLOR_BAR_TODAY_TOP = 0xFFFFFF;
    protected int COLOR_BAR_TODAY_FRONT = 10857648;
    protected int COLOR_BAR_TODAY_SIDE = 8555151;
    protected int COLOR_BAR_AFTER_TOP = 6187634;
    protected int COLOR_BAR_AFTER_FRONT = 3555914;
    protected int COLOR_BAR_AFTER_SIDE = 1778474;
    protected static final int CLIPX = 0;
    protected static final int CLIPY = 0;
    protected static final int CLIPW = 240;
    protected static final int CLIPH = 320;
    protected static final int HEALTH_GOAL = 10000;
    protected static final int ANIMATION_INTERVAL_ANIMATE = 50;
    protected static final byte STATE_IDLE = 1;
    protected static final byte STATE_WALK = 2;
    protected static final byte STATE_HEALTH = 3;
    protected static final int ANIM_FRAMES_IDLE = 81;
    protected static final int ANIM_FRAMES_WALK = 28;
    protected static final int ANIM_FRAMES_HEALTH = 79;
    protected int animationInterval = 50;
    protected int stepsToday;
    protected int dailyAverage;
    protected int biggestNumberOfSteps;
    protected int[] stepsLastWeek = new int[7];
    protected int[] facebookIconLastWeek = new int[7];
    protected int daysWithStepsLastWeek;
    protected int dayOfWeek;
    protected long millisToday;
    private long millisLastSave;
    protected boolean doAnimate = false;
    private boolean isActiveSet;
    private boolean isActive;
    protected int stepsLastSave;
    protected Command rskCommand;
    protected GuiListener listener;
    protected Display display;
    protected String[] textWeekdays = new String[7];
    protected String textStepsToday = "";
    protected String textHealthGoal = "";
    protected String textDailyAverage = "";
    protected String textKilo = "";
    protected int coordsBackgroundY;
    protected int coordsScaleZero;
    protected int coordsScaleHeight;
    protected int coordsScaleDistance;
    protected int coordsBarStartX;
    protected int coordsBarStartY;
    protected int coordsBarTextY;
    protected int coordsBarWidth;
    protected int coordsBarDistance;
    protected int coordsShadowDisplacementX;
    protected int coordsShadowDisplacementY;
    protected int coordsTextBackgroundY;
    protected int coordsLeftTextSmallX;
    protected int coordsLeftTextSmallY;
    protected int coordsLeftTextBigX;
    protected int coordsLeftTextBigY;
    protected int coordsRightTextSmallX;
    protected int coordsRightTextSmallY;
    protected int coordsRightTextBigX;
    protected int coordsRightTextBigY;
    protected boolean manIsMoving;
    protected boolean showPopup;
    protected int animationCounter;
    protected int animationLoops;
    protected int animationFrames;
    protected int healthWidth;
    protected int averageWidth;
    protected boolean showHealth;
    protected Displayable mainWalkmateScreen;
    private final String[] WEEKDAYS = new String[]{"JAVAAPPS_WM_MONDAY_TXT", "JAVAAPPS_WM_TUESDAY_TXT", "JAVAAPPS_WM_WEDNESDAY_TXT", "JAVAAPPS_WM_THURSDAY_TXT", "JAVAAPPS_WM_FRIDAY_TXT", "JAVAAPPS_WM_SATURDAY_TXT", "JAVAAPPS_WM_SUNDAY_TXT"};
    protected Image imageBackground;
    protected Image imageResultsBackground;
    protected Image imageBarReflection;
    protected Image imageWalkingPersonWhite;
    protected Image imageWalkingPersonHealth;
    protected Image imageBarShadow;
    protected Image offscreenBuffer;
    private long nextSwitchTimestamp;
    protected long nextRepaintMillis = -1L;
    protected int updateCounter;
    protected byte currentState = 1;
    protected Datastore model;
    private static final int SWITCH_INTERVAL = 8000;
    private static final long SAVE_INTERVAL = 60000L;

    public Gui(Display display, Datastore model) {
        super(false);
        Logger.printOut("[WALKMATE]: View - constructor - display: " + display);
        this.display = display;
        this.model = model;
        this.mainWalkmateScreen = this;
        this.setFullScreenMode(false);
        this.setCommandListener(this);
        this.updateLanguage();
    }

    public void setListener(GuiListener listener) {
        Logger.printOut("[WALKMATE]: View - setListener");
        this.listener = listener;
    }

    public void initializeSteps() {
        Logger.printOut("[WALKMATE]: View - initializeSteps");
        this.stepsLastSave = -1;
        try {
            this.stepsToday = this.model.getStepsForToday();
            Logger.printOut("[WALKMATE]: View - initializeSteps - stepsToday: " + this.stepsToday);
            int[] dataForLastWeek = this.model.getStepsForLastWeek();
            Logger.printOut("[WALKMATE]: View - initializeSteps");
            int i = 0;
            while (i < 7) {
                this.stepsLastWeek[i] = dataForLastWeek[i];
                ++i;
            }
            this.daysWithStepsLastWeek = this.model.getDaysWithStepsLastWeek();
            Logger.printOut("[WALKMATE]: View - initializeSteps - daysWithStepsLastWeek: " + this.daysWithStepsLastWeek);
        }
        catch (RecordStoreException ex) {
            Logger.printOut("[WALKMATE]: Error to access the dataStore:" + ex.getMessage());
            ex.printStackTrace();
        }
        Logger.printOut("[WALKMATE]: View - initializeSteps - stepsToday: " + this.stepsToday);
        Logger.printOut("[WALKMATE]: View - initializeSteps - daysWithStepsLastWeek: " + this.daysWithStepsLastWeek);
    }

    protected final boolean isPastNextSwitchTimestamp() {
        return System.currentTimeMillis() >= this.nextSwitchTimestamp || this.nextSwitchTimestamp - System.currentTimeMillis() > 16000L;
    }

    protected void initializeCoords() {
        Logger.printOut("[WALKMATE]: View - initializeCoords");
        this.coordsBackgroundY = -28;
        this.coordsScaleZero = 182;
        this.coordsScaleHeight = 70;
        this.coordsScaleDistance = 14;
        this.coordsBarStartX = 30;
        this.coordsBarStartY = this.coordsScaleZero + 8;
        this.coordsBarTextY = this.coordsBarStartY + 17;
        this.coordsBarWidth = 19;
        this.coordsBarDistance = 11;
        this.coordsShadowDisplacementX = -10;
        this.coordsShadowDisplacementY = -18;
        this.coordsTextBackgroundY = 34;
        this.coordsLeftTextSmallX = 6;
        this.coordsLeftTextSmallY = this.coordsTextBackgroundY + 25;
        this.coordsLeftTextBigX = 6;
        this.coordsLeftTextBigY = this.coordsTextBackgroundY + 48;
        this.coordsRightTextSmallX = 234;
        this.coordsRightTextSmallY = this.coordsTextBackgroundY + 25;
        this.coordsRightTextBigX = 234;
        this.coordsRightTextBigY = this.coordsTextBackgroundY + 48;
    }

    protected boolean initializeImages() {
        Logger.printOut("[WALKMATE]: View - initializeImages");
        try {
            this.imageBarReflection = Image.createImage((String)"/images/barReflection.png");
            this.imageBarShadow = Image.createImage((String)"/images/barShadow.png");
        }
        catch (IOException ex) {
            Logger.printOut("Gui - initializeImages - EXCEPTION");
            return false;
        }
        Logger.printOut("Gui - initializeImages - OK!!!");
        return true;
    }

    protected final void setNextSwitchTimestamp() {
        this.nextSwitchTimestamp = System.currentTimeMillis() + 8000L;
    }

    public boolean startView() {
        Logger.printOut("[WALKMATE]: View - startView");
        this.initializeCoords();
        if (!this.initializeImages()) {
            Logger.printOut("[WALKMATE]: View - startView - initializeImages - NOK ??????????");
            return false;
        }
        Logger.printOut("[WALKMATE]: View - startView - initializeImages - OK");
        this.manIsMoving = false;
        this.animationLoops = 0;
        this.animationFrames = 81;
        this.showPopup = false;
        this.healthWidth = 0;
        this.averageWidth = 0;
        this.setNextSwitchTimestamp();
        this.initializeGUI(this.stepsLastWeek, this.daysWithStepsLastWeek, DateUtils.getDayOfWeekToday());
        this.isActiveSet = false;
        this.millisToday = DateUtils.getMillisToday();
        this.millisLastSave = DateUtils.getMillisNow();
        return true;
    }

    public void stopView() {
        Logger.printOut("[WALKMATE]: View - stopView");
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.saveSteps(this.millisToday);
            Logger.printOut("[WALKMATE]: View - stopView - calling initializeSteps");
            this.initializeSteps();
        }
        try {
            this.model.setStepsForToday(this.stepsToday);
        }
        catch (RecordStoreException ignored) {
            ignored.printStackTrace();
        }
    }

    private final void saveSteps(long millis) {
        try {
            Logger.printOut("[WALKMATE]: View - saveSteps");
            int[] date = DateUtils.convertMillisToDate(millis);
            this.model.getSteps(date[0], date[1], date[2]);
            this.model.setSteps(this.stepsToday, date[0], date[1], date[2]);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public final boolean isActive() {
        return this.display.flashBacklight(0);
    }

    public void screenIsOn() {
        Logger.printOut("[WALKMATE]: View - screenIsOn: isActiveSet: " + this.isActiveSet);
        if (!this.isActiveSet) {
            this.isActiveSet = true;
            this.isActive = this.isActive();
            Logger.printOut("[WALKMATE]: View - screenIsOn: isActive: " + this.isActive);
            this.setRightSoftKey();
        }
    }

    private void setRightSoftKey() {
        Logger.printOut("[WALKMATE]: View - setRightSoftKey");
        this.removeCommand(this.rskCommand);
        this.rskCommand = new Command(Translator.getMessage("JAVAAPPS_WM_EXIT_SK"), 7, 1);
        this.addCommand(this.rskCommand);
    }

    public final void resetSteps() {
        Logger.printOut("[WALKMATE]: View - resetSteps");
        this.stepsToday = 0;
        this.refresh();
    }

    public void initializeGUI(int[] stepsLastWeek, int daysWithStepsLastWeek, int dayOfWeek) {
        Logger.printOut("[WALKMATE]: View - initializeGUI");
        System.arraycopy(stepsLastWeek, 0, this.stepsLastWeek, 0, this.stepsLastWeek.length);
        this.stepsToday = this.stepsLastWeek[dayOfWeek];
        this.daysWithStepsLastWeek = daysWithStepsLastWeek;
        this.dayOfWeek = dayOfWeek;
        this.millisToday = DateUtils.getMillisToday();
        this.dailyAverage = this.getDailyAverage();
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
        Logger.printOut("[WALKMATE]: View - getBiggestNumberOfSteps");
        this.refresh();
        Logger.printOut("[WALKMATE]: View - after ");
        this.display.setCurrent((Displayable)this);
    }

    protected int getDailyAverage() {
        Logger.printOut("[WALKMATE]: View - getDailyAverage");
        if (this.daysWithStepsLastWeek == 0) {
            return 0;
        }
        int average = 0;
        int i = 0;
        while (i != this.stepsLastWeek.length) {
            if (i != this.dayOfWeek) {
                average += this.stepsLastWeek[i];
            }
            ++i;
        }
        return (int)MathUtils.round((double)average / (double)this.daysWithStepsLastWeek);
    }

    protected int getBiggestNumberOfSteps() {
        Logger.printOut("[WALKMATE]: View - getBiggestNumberOfSteps");
        int steps = 0;
        int i = 0;
        while (i != this.stepsLastWeek.length) {
            if (this.stepsLastWeek[i] > steps) {
                steps = this.stepsLastWeek[i];
            }
            ++i;
        }
        return steps;
    }

    public void refresh() {
        if (!this.doAnimate) {
            this.repaint();
        }
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    protected void showNotify() {
        super.showNotify();
        Logger.printOut("[WALKMATE]: View - showNotify");
        if (Translator.localeHasChanged()) {
            Translator.initLocalizationSupport();
        }
        this.updateLanguage();
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.checkTimeAndDate();
        }
        this.animationInterval = 50;
        this.doAnimate = true;
        this.screenIsOn();
        if (this.offscreenBuffer == null) {
            this.offscreenBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        this.display.callSerially((Runnable)this);
    }

    protected final void checkTimeAndDate() {
        Logger.printOut("[WALKMATE]: View - checkTimeAndDate");
        if (DateUtils.getMillisToday() != this.millisToday) {
            this.saveSteps(this.millisToday);
            this.millisToday = DateUtils.getMillisToday();
            this.millisLastSave = DateUtils.getMillisNow();
            this.initializeSteps();
            this.initializeGUI(this.stepsLastWeek, this.daysWithStepsLastWeek, DateUtils.getDayOfWeekToday());
        } else if (Math.abs(DateUtils.getMillisNow() - this.millisLastSave) > 60000L) {
            if (this.stepsLastSave != this.stepsToday) {
                this.saveSteps(this.millisToday);
                this.stepsLastSave = this.stepsToday;
            }
            this.millisLastSave = DateUtils.getMillisNow();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.doAnimate = false;
        this.screenIsOff();
    }

    public void screenIsOff() {
        Logger.printOut("[WALKMATE]: View - screenIsOff");
        if (this.stepsLastSave != this.stepsToday) {
            this.saveSteps(this.millisToday);
            this.stepsLastSave = this.stepsToday;
        }
        this.millisLastSave = DateUtils.getMillisNow();
    }

    public void commandAction(Command command, Displayable displayable) {
        Logger.printOut("[WALKMATE]: View - commandAction");
        if (command == this.rskCommand) {
            Logger.printOut("[WALKMATE]: View - commandAction - rskCommand");
            this.listener.controlViewEvent(26);
        }
    }

    public int getStepsToday() {
        Logger.printOut("[WALKMATE]: View - getStepsToday");
        return this.stepsToday;
    }

    protected void updateLanguage() {
        Logger.printOut("[WALKMATE]: View - updateLanguage");
        int i = 0;
        while (i != this.textWeekdays.length) {
            this.textWeekdays[i] = Translator.getMessage(this.WEEKDAYS[i]);
            ++i;
        }
        this.textStepsToday = Translator.getMessage("JAVAAPPS_WM_STEPS_TODAY_TXT");
        this.textHealthGoal = Translator.getMessage("JAVAAPPS_WM_HEALTH_GOAL_TXT");
        this.textDailyAverage = Translator.getMessage("JAVAAPPS_WM_DAILY_AVERAGE_TXT");
        this.textKilo = Translator.getMessage("JAVAAPPS_WM_KILO_TXT");
        this.setRightSoftKey();
    }

    public void updateMovement(boolean movement) {
        Logger.printOut("[WALKMATE]: View - updateMovement - " + movement);
        this.listener.controlViewEvent(32);
        this.manIsMoving = movement;
    }

    public void updateSteps(int steps) {
        Logger.printOut("[WALKMATE]: View - updateSteps - steps: " + steps);
        this.listener.controlViewEvent(31);
        this.stepsLastWeek[this.dayOfWeek] = this.stepsToday;
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
        this.checkTimeAndDate();
        this.stepsToday += steps;
        this.refresh();
    }

    protected void keyPressed(int key) {
        super.keyPressed(key);
    }

    public void run() {
    }

    public Displayable getMainDisplayable() {
        return this.mainWalkmateScreen;
    }
}

