/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.FbAlert;
import com.sonyericsson.walkmate.gui.Gui15;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.model.datastore.FbDatastore;
import com.sonyericsson.walkmate.model.datastore.FbInfoDatastore;
import com.sonyericsson.walkmate.utils.DateUtils;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

public class GuiFacebook
extends Gui15 {
    private static boolean LOGIN_BUTTON = true;
    private static boolean PUBLISH_BUTTON = false;
    private Command publish;
    private Command login;
    private boolean loginAdded = false;
    private Image imageFacebookMarker;
    protected int facebookIconToday;

    public GuiFacebook(Display display, Datastore model) {
        super(display, model);
    }

    protected boolean initializeImages() {
        try {
            super.initializeImages();
            this.imageFacebookMarker = Image.createImage((String)"/images/fb_logo.png");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public final void initializeSteps() {
        Logger.printOut("[WALKMATE]: View - initializeSteps");
        this.stepsLastSave = -1;
        try {
            this.stepsToday = ((FbDatastore)this.model).getStepsForToday();
            Logger.printOut("[WALKMATE]: View - initializeSteps - stepsToday: " + this.stepsToday);
            this.facebookIconToday = ((FbDatastore)this.model).getFacebookIconForToday();
            int[][] dataForLastWeek = ((FbDatastore)this.model).getFacebookStepsForLastWeek();
            Logger.printOut("[WALKMATE]: View - initializeSteps");
            int i = 0;
            while (i < 7) {
                this.stepsLastWeek[i] = dataForLastWeek[0][i];
                this.facebookIconLastWeek[i] = dataForLastWeek[1][i];
                ++i;
            }
            this.daysWithStepsLastWeek = ((FbDatastore)this.model).getFacebookDaysWithStepsLastWeek();
            Logger.printOut("[WALKMATE]: View - initializeSteps - daysWithStepsLastWeek: " + this.daysWithStepsLastWeek);
        }
        catch (RecordStoreException ex) {
            Logger.printOut("[WALKMATE]: Error to access the dataStore:" + ex.getMessage());
            ex.printStackTrace();
        }
        Logger.printOut("[WALKMATE]: View - initializeSteps - stepsToday: " + this.stepsToday);
        Logger.printOut("[WALKMATE]: View - initializeSteps - daysWithStepsLastWeek: " + this.daysWithStepsLastWeek);
    }

    public void initializeGUI(int[] facebookIconLastWeek, int[] stepsLastWeek, int daysWithStepsLastWeek, int dayOfWeek) {
        Logger.printOut("[WALKMATE]: View - initializeGUI");
        System.arraycopy(stepsLastWeek, 0, this.stepsLastWeek, 0, this.stepsLastWeek.length);
        System.arraycopy(facebookIconLastWeek, 0, this.facebookIconLastWeek, 0, this.facebookIconLastWeek.length);
        this.stepsToday = this.stepsLastWeek[dayOfWeek];
        this.facebookIconToday = this.facebookIconLastWeek[dayOfWeek];
        this.daysWithStepsLastWeek = daysWithStepsLastWeek;
        this.dayOfWeek = dayOfWeek;
        this.millisToday = DateUtils.getMillisToday();
        this.dailyAverage = this.getDailyAverage();
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
        this.refresh();
        this.display.setCurrent((Displayable)this);
    }

    public void addCommandAF(boolean loginCmd) {
        Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - addCommandAF");
        if (loginCmd) {
            this.removeCommand(this.login);
            this.login = new Command(Translator.getMessage("WF_FACEBOOK_LOGIN_LOGIN_TXT"), 4, 3);
            this.addCommand(this.login);
            this.loginAdded = true;
        } else {
            this.removeCommand(this.publish);
            this.publish = new Command(Translator.getMessage("WF_MSK_PUBLISH_TXT"), 4, 2);
            this.addCommand(this.publish);
        }
    }

    public void removeLoginCommand() {
        Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - removeLoginCommand");
        this.removeCommand(this.login);
        this.loginAdded = false;
    }

    public void commandAction(Command command, Displayable displayable) {
        Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - commandAction");
        if (command == this.publish) {
            Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - PUBLISH_COMMAND");
            this.listener.controlViewEvent(27);
        } else if (command == this.login) {
            Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - LOGIN_COMMAND");
            this.listener.controlViewEvent(28);
        } else {
            Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - else");
            super.commandAction(command, displayable);
        }
    }

    public void updateFbIconLastWeek(int[][] dataForLastWeek) {
        int z = 0;
        while (z < 7) {
            this.facebookIconLastWeek[z] = dataForLastWeek[1][z];
            ++z;
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -9999) {
            Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - keyPressed - -9999");
            this.listener.controlViewEvent(30);
        }
        super.keyPressed(keyCode);
    }

    protected void showNotify() {
        Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - showNotify");
        this.listener.controlViewEvent(30);
        if (this.loginAdded) {
            this.addCommandAF(LOGIN_BUTTON);
        }
        this.addCommandAF(PUBLISH_BUTTON);
        super.showNotify();
    }

    public void verifyStatus() {
        Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - VerifyStatus");
        if (this.display.flashBacklight(0)) {
            Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - VerifyStatus - display.flashBacklight(0) == true");
            FbInfoDatastore data = new FbInfoDatastore();
            if (data.getSize("FACEBOOK_WALLPAPER_DB") == 0) {
                Logger.printOut("[WALKMATE]: ViewActivityFeeds1_0 - VerifyStatus - FACEBOOK_WALLPAPER_DB == 0");
                FbAlert fbAlert = new FbAlert(Translator.getMessage("WF_START_INFO_TXT"), this.listener, this.display);
                this.display.setCurrent((Displayable)fbAlert);
            }
        }
    }

    public void paint(Graphics g) {
        Graphics savedGraphics = g;
        g = this.offscreenBuffer.getGraphics();
        this.paintFase1(g);
        int i = 0;
        while (i != 7) {
            this.drawBar(g, this.barX[i], this.coordsScaleZero, this.barAngle[i], 20, this.coordsScaleHeight, 5, (double)this.stepsLastWeek[i] / this.scaleMax, i, this.facebookIconLastWeek[i]);
            ++i;
        }
        this.paintFase2(g, savedGraphics);
    }

    protected void drawBar(Graphics g, int x, int y, int angle, int width, int maxHeight, int scaleSteps, double heightFactor, int dayIndex, int facebookIconLastWeek) {
        int ScaleZero = 163;
        int coordsScaleHeight = 65;
        double adjustScale = (double)coordsScaleHeight / (double)scaleSteps;
        int x1 = x;
        super.drawBar(g, x, y, angle, width, maxHeight, scaleSteps, heightFactor, dayIndex);
        if (facebookIconLastWeek != -1) {
            if ((double)facebookIconLastWeek > this.scaleMax / (double)scaleSteps) {
                double scaleDistance = (double)ScaleZero + adjustScale - (double)(facebookIconLastWeek * coordsScaleHeight) / this.scaleMax;
                g.drawImage(this.imageFacebookMarker, x1 + 2, (int)MathUtils.round(scaleDistance), 20);
            } else {
                g.drawImage(this.imageFacebookMarker, x1 + 2, ScaleZero, 20);
            }
        }
    }
}

