/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.facebook.utils.RMSAuth;
import com.sonyericsson.walkmate.gui.Fbl;
import com.sonyericsson.walkmate.gui.FblListener;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.gui.TextBoxCapture;
import com.sonyericsson.walkmate.language.Translator;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LoginCanvas
extends Canvas
implements CommandListener,
FblListener {
    private static final String EMAIL = "email";
    private static final String PASSWORD = "password";
    private static final long TIMER_VALUE = 300L;
    private static final int ACTIVE_USER = 1;
    private static final int ACTIVE_PASS = 2;
    private static final int ACTIVE_LOGIN = 3;
    private static final String IMG_BG_PATH = "/images/login_background.png";
    private static final String IMG_FIELD_HIGHLIGHT_PATH = "/images/field_highlight.png";
    private static final String IMG_LOGIN_HIGHLIGHT_PATH = "/images/login_highlight.png";
    private Timer timer;
    private int activeState = 1;
    private TextBoxCapture textBox;
    private String user = "";
    private String password = "";
    private String code = "";
    private GuiListener listener;
    private Command back;
    private Command login;
    private Command editLogin;
    private Command infoLogin;
    private Display display;
    private RMSAuth rmsAuth;
    private Font fontTxt = Font.getFont((int)64, (int)1, (int)0);
    private Image bkgImg = null;
    private Image fieldImg = null;
    private Image loginImg = null;
    private Fbl fbl = null;
    private boolean activeLogin = false;

    public LoginCanvas(Display display, GuiListener listener) {
        this.textBox = new TextBoxCapture();
        this.display = display;
        this.listener = listener;
        this.rmsAuth = RMSAuth.getRMSAuth();
        try {
            this.bkgImg = Image.createImage((String)IMG_BG_PATH);
            this.fieldImg = Image.createImage((String)IMG_FIELD_HIGHLIGHT_PATH);
            this.loginImg = Image.createImage((String)IMG_LOGIN_HIGHLIGHT_PATH);
        }
        catch (Exception error) {
            Logger.printOut("[WALKMATE]: Couldn\u00b4t load the image: " + error.getMessage());
        }
        this.user = this.rmsAuth.getUserEmail();
        this.setSoftKeys();
        this.setCommandListener(this);
    }

    public void setSoftKeys() {
        this.removeCommand(this.back);
        this.removeCommand(this.editLogin);
        this.removeCommand(this.login);
        this.removeCommand(this.infoLogin);
        this.back = new Command(Translator.getMessage("WF_RSK_BACK_TXT"), 2, 1);
        this.login = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
        this.editLogin = new Command(Translator.getMessage("WF_LSK_EDIT_TXT"), 4, 2);
        this.infoLogin = new Command(Translator.getMessage("JAVAAPPS_WM_INFO_SK"), 4, 3);
        this.addCommand(this.back);
        if (this.activeLogin) {
            this.addCommand(this.login);
            this.activeLogin = false;
        } else {
            this.addCommand(this.editLogin);
        }
        this.addCommand(this.infoLogin);
        this.setCommandListener(this);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(3889560);
        this.paintScreen(graphics);
        if (this.user != null) {
            if (this.activeState == 1) {
                graphics.setColor(3889560);
            } else {
                graphics.setColor(0xFFFFFF);
            }
            graphics.drawString(this.cutStr(this.user, 220, this.fontTxt), 20, 107, 20);
        }
        if (this.password != null) {
            this.code = "";
            int i = 0;
            while (i < this.password.length()) {
                if (this.code.length() < this.password.length()) {
                    this.code = String.valueOf(this.code) + "*";
                }
                ++i;
            }
            if (this.activeState == 2) {
                graphics.setColor(3889560);
            } else {
                graphics.setColor(0xFFFFFF);
            }
            graphics.drawString(this.cutStr(this.code, 220, this.fontTxt), 20, 170, 20);
        }
    }

    private String cutStr(String txt, int width, Font fontTxt) {
        int strWidth = fontTxt.stringWidth(txt);
        int nChar = txt.length();
        while (strWidth > width) {
            strWidth = fontTxt.stringWidth(txt.substring(0, --nChar));
        }
        return txt.substring(0, nChar);
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: {
                if (this.activeState == 1) {
                    if (this.user.equalsIgnoreCase("") || this.password.equalsIgnoreCase("")) {
                        this.activeState = 2;
                        break;
                    }
                    this.activeState = 3;
                    this.removeCommand(this.editLogin);
                    this.addCommand(this.login);
                    this.display.setCurrent((Displayable)this);
                    break;
                }
                if (this.activeState == 2) {
                    this.activeState = 1;
                    break;
                }
                if (this.activeState != 3) break;
                this.activeState = 2;
                this.removeCommand(this.login);
                this.addCommand(this.editLogin);
                this.display.setCurrent((Displayable)this);
                break;
            }
            case -2: {
                if (this.activeState == 3) {
                    this.activeState = 1;
                    this.removeCommand(this.login);
                    this.addCommand(this.editLogin);
                    this.display.setCurrent((Displayable)this);
                    break;
                }
                if (this.activeState == 2) {
                    if (this.user.equalsIgnoreCase("") || this.password.equalsIgnoreCase("")) {
                        this.activeState = 1;
                        break;
                    }
                    this.activeState = 3;
                    this.removeCommand(this.editLogin);
                    this.addCommand(this.login);
                    this.display.setCurrent((Displayable)this);
                    break;
                }
                if (this.activeState != 1) break;
                this.activeState = 2;
                break;
            }
            default: {
                super.keyPressed(keyCode);
            }
        }
        this.repaint();
    }

    protected void paintScreen(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.bkgImg, 0, 35, 20);
        if (this.activeState == 1) {
            Logger.printOut("[WALKMATE]: LoginCanvas - paintScreen - ACTIVE_USER");
            graphics.drawImage(this.fieldImg, 15, 83, 20);
        } else if (this.activeState == 2) {
            Logger.printOut("[WALKMATE]: LoginCanvas - paintScreen - ACTIVE_PASS");
            graphics.drawImage(this.fieldImg, 15, 142, 20);
        } else {
            Logger.printOut("[WALKMATE]: LoginCanvas - paintScreen - ELSE");
            graphics.drawImage(this.loginImg, 86, 201, 20);
            this.activeLogin = true;
            this.removeCommand(this.editLogin);
            this.addCommand(this.login);
            this.display.setCurrent((Displayable)this);
        }
        graphics.setColor(0xFFFFFF);
        graphics.drawString(Translator.getMessage("WF_FACEBOOK_LOGIN_TITLE_TXT"), 53, 39, 20);
        graphics.drawString(Translator.getMessage("WF_FACEBOOK_LOGIN_USER_TXT"), 17, 84, 20);
        graphics.drawString(Translator.getMessage("WF_FACEBOOK_LOGIN_PASSWORD_TXT"), 17, 142, 20);
        graphics.setColor(3889560);
        graphics.drawString(Translator.getMessage("WF_FACEBOOK_LOGIN_LOGIN_TXT"), 122, 203, 17);
        graphics = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.back) {
            this.cancelFblTimer();
            this.listener.controlViewEvent(16);
        } else if (command == this.editLogin) {
            Logger.printOut("[WALKMATE]: LoginCanvas - editLogin ");
            this.timer = new Timer();
            this.checkEndKey();
            if (this.activeState == 1) {
                this.textBox.textBox(this.display, this, EMAIL, this.user);
            } else {
                this.textBox.textBox(this.display, this, PASSWORD, null);
            }
        } else if (command == this.login) {
            this.cancelFblTimer();
            this.rmsAuth.setUserEmail(this.user);
            this.listener.controlViewEvent(6);
        } else if (command == this.infoLogin) {
            this.cancelFblTimer();
            this.listener.controlViewEvent(7);
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -9999) {
            Logger.printOut("[WALKMATE]: LoginCanvas - keyReleased - -9999");
            if (!this.display.flashBacklight(0)) {
                Logger.printOut("[WALKMATE]: LoginCanvas - keyReleased - -9999 - display.flashBacklight(0) == false");
                this.listener.controlViewEvent(18);
            }
        }
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setActiveState(int state) {
        this.activeState = state;
    }

    protected void showNotify() {
        super.showNotify();
        this.setSoftKeys();
    }

    public void checkEndKey() {
        Logger.printOut("[WALKMATE]: LoginCanvas - checkEndKey");
        this.fbl = new Fbl(this, this.display);
        this.timer.schedule((TimerTask)this.fbl, 300L);
    }

    public void cancelFblTimer() {
        Logger.printOut("[WALKMATE]: LoginCanvas - cancelFblTimer");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void fblEvent(int event) {
        Logger.printOut("[WALKMATE]: LoginCanvas - fblEvent");
        if (event == 0) {
            Logger.printOut("[WALKMATE]: LoginCanvas - fblEvent- CONTINUE_TIMER");
            this.checkEndKey();
        } else if (event == 1) {
            Logger.printOut("[WALKMATE]: LoginCanvas - fblEvent- STOP_TIMER_END_KEY");
            this.listener.controlViewEvent(33);
        }
    }
}

