/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.facebook.utils.RMSAuth;
import com.sonyericsson.walkmate.gui.Fbl;
import com.sonyericsson.walkmate.gui.FblListener;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.gui.TextBoxCapture;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.model.datastore.PersonalMessageDatastore;
import com.sonyericsson.walkmate.utils.TextFormatUtils;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

public class MessageSetup
extends Canvas
implements CommandListener,
FblListener {
    private final String HAS_WALKED = Translator.getMessage("WF_FACEBOOK_FULL_AUTOMATIC_MSG1_TXT");
    private static final String STEPS_TODAY = " steps today using a Sony Ericsson phone";
    private final String STEPS_TODAY_IN = Translator.getMessage("WF_FACEBOOK_FULL_AUTOMATIC_MSG2_TXT");
    private static final String MESSAGE = "message";
    private final String CHARACTER_MESSAGE = Translator.getMessage("WF_FACEBOOK_CHARACTERS_LEFT_TXT");
    private static final long TIMER_VALUE = 300L;
    private Timer timer;
    private static final String PUBLISH_BKG = "/images/published_bkg.png";
    private static final int MAX_FACEBOOK_TEXT = 400;
    private static final int MAX_LINE_NUMBER = 5;
    private int leftMessageSize;
    private int sizeMessage;
    private int imageSize;
    private TextBoxCapture textBox;
    private TextFormatUtils textFormat = new TextFormatUtils();
    private RMSAuth rmsAuth;
    private PersonalMessageDatastore personalMessageDatastore;
    private String finalMessage = "";
    private String location = "";
    private String characterMessageLeft = "";
    private Command back;
    private Command edit;
    private Command publish;
    private Display display;
    private GuiListener listener;
    private Image publishBkg;
    private Fbl fbl = null;
    private Datastore model;

    public MessageSetup(Display display, String location, GuiListener listener, Datastore model) {
        this.display = display;
        this.location = location;
        this.model = model;
        this.textBox = new TextBoxCapture();
        this.rmsAuth = RMSAuth.getRMSAuth();
        this.personalMessageDatastore = new PersonalMessageDatastore();
        this.listener = listener;
        try {
            this.publishBkg = Image.createImage((String)PUBLISH_BKG);
        }
        catch (Exception error) {
            Logger.printOut("[WALKMATE]: Couldn\u00b4t load the image: " + error.getMessage());
        }
        this.setSoftKeys();
        this.setCommandListener(this);
    }

    public void setSoftKeys() {
        this.removeCommand(this.back);
        this.removeCommand(this.publish);
        this.removeCommand(this.edit);
        this.back = new Command(Translator.getMessage("WF_RSK_BACK_TXT"), 2, 1);
        this.publish = new Command(Translator.getMessage("WF_MSK_PUBLISH_TXT"), 4, 2);
        this.edit = new Command(Translator.getMessage("WF_LSK_EDIT_TXT"), 4, 3);
        this.addCommand(this.back);
        this.addCommand(this.publish);
        this.addCommand(this.edit);
    }

    protected void showNotify() {
        super.showNotify();
        this.setSoftKeys();
    }

    protected void paint(Graphics graphics) {
        Font mCharacter = Font.getFont((int)64, (int)2, (int)8);
        Font mText = Font.getFont((int)64, (int)0, (int)8);
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.publishBkg, 0, 0, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(Translator.getMessage("WF_FACEBOOK_PUBLISH_TITLE_TXT"), 35, 5, 20);
        this.imageSize = this.publishBkg.getWidth();
        this.finalMessage = String.valueOf(this.rmsAuth.getName()) + " " + this.createDefaultMessage();
        this.textFormat.write(graphics, this.finalMessage, 17, 50, 205, mText, 5, 0, this.imageSize, 0, 2, false);
        graphics.drawLine(61, 137, 181, 137);
        if (this.personalMessageDatastore.getMessageSize() != 0) {
            this.sizeMessage = this.personalMessageDatastore.getPersonalMessage().length();
            this.textFormat.write(graphics, this.personalMessageDatastore.getPersonalMessage(), 17, 152, 125, mText, 5, 0, this.imageSize, 0, 2, true);
        } else {
            this.sizeMessage = 0;
            this.textFormat.write(graphics, Translator.getMessage("WF_FACEBOOK_EDIT_PERSONALIZED_MSG_TX"), 17, 145, 205, mText, 5, 0, this.imageSize, 0, 2, false);
        }
        this.leftMessageSize = 400 - this.createDefaultMessage().length() - this.sizeMessage;
        this.characterMessageLeft = String.valueOf(this.CHARACTER_MESSAGE) + Integer.toString(this.leftMessageSize);
        this.textFormat.write(graphics, this.characterMessageLeft, 14, 240, 205, mCharacter, 5, 0, this.imageSize, 11, 1, false);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.back) {
            this.cancelFblTimer();
            Logger.printOut("[WALKMATE]: MessageSetup - commandAction - back");
            this.listener.controlViewEvent(19);
            Logger.printOut("[WALKMATE]: MessageSetup - commandAction - sending MESSAGE_SETUP_BACK");
        } else if (command == this.edit) {
            int personalMessageSize = 400 - this.createDefaultMessage().length();
            this.timer = new Timer();
            this.checkEndKey();
            this.textBox.textBox(this.display, this, MESSAGE, personalMessageSize);
            Logger.printOut("[WALKMATE]: MessageSetup - commandAction - edit");
        } else if (command == this.publish) {
            Logger.printOut("[WALKMATE]: MessageSetup - commandAction - publish");
            this.cancelFblTimer();
            this.listener.controlViewEvent(11);
            Logger.printOut("[WALKMATE]: MessageSetup - commandAction - sending MSG_TO_BE_PUBLISHED");
        }
    }

    public String createDefaultMessage() {
        String message = "";
        String nOfSteps = "";
        int stepsToday = 0;
        try {
            stepsToday = this.model.getStepsForToday();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        nOfSteps = Integer.toString(stepsToday);
        message = this.location.length() == 0 ? String.valueOf(this.HAS_WALKED) + " " + nOfSteps + STEPS_TODAY + "." : String.valueOf(this.HAS_WALKED) + " " + nOfSteps + " " + this.STEPS_TODAY_IN + " " + this.location + ".";
        return message;
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -9999 && !this.display.flashBacklight(0)) {
            this.listener.controlViewEvent(18);
        }
    }

    public void checkEndKey() {
        this.fbl = new Fbl(this, this.display);
        this.timer.schedule((TimerTask)this.fbl, 300L);
    }

    public void cancelFblTimer() {
        Logger.printOut("[WALKMATE]: MessageSetup - cancelFblTimer");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void fblEvent(int event) {
        if (event == 0) {
            Logger.printOut("[WALKMATE]: MessageSetup - fblEvent - CONTINUE_TIMER");
            this.checkEndKey();
        } else if (event == 1) {
            Logger.printOut("[WALKMATE]: MessageSetup - fblEvent - STOP_TIMER_END_KEY");
            this.listener.controlViewEvent(33);
        }
    }
}

