/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.LoginCanvas;
import com.sonyericsson.walkmate.gui.MessageSetup;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.PersonalMessageDatastore;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;

public class TextBoxCapture
implements CommandListener {
    private static final int ACTIVE_PASS = 2;
    private static final int ACTIVE_LOGIN = 3;
    private static final String EMAIL = "email:";
    private static final String PASSWORD = "password:";
    private static final String PERSONALIZED_MSG = "Personalized Message:";
    private TextBox textbox;
    private Command submit;
    private Command exit;
    private String screenType;
    private LoginCanvas textCanvas;
    private MessageSetup messageSetup;
    private PersonalMessageDatastore personalMessageDatastore;
    private Display display;

    public void textBox(Display display, LoginCanvas canvas, String type, String text) {
        this.textCanvas = canvas;
        this.display = display;
        this.submit = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 1, 0);
        this.exit = new Command(Translator.getMessage("JAVAAPPS_WM_EXIT_SK"), 7, 1);
        this.screenType = type;
        if (type.equalsIgnoreCase("email")) {
            this.textbox = new TextBox(EMAIL, text, 50, 1);
        }
        if (type.equalsIgnoreCase("password")) {
            this.textbox = new TextBox(PASSWORD, "", 20, 65536);
        }
        this.textbox.addCommand(this.exit);
        this.textbox.addCommand(this.submit);
        this.textbox.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.textbox);
    }

    public void textBox(Display display, MessageSetup canvas, String type, int personalMessageSize) {
        this.screenType = type;
        this.messageSetup = canvas;
        this.display = display;
        this.submit = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 1, 0);
        this.exit = new Command(Translator.getMessage("JAVAAPPS_WM_EXIT_SK"), 7, 1);
        this.personalMessageDatastore = new PersonalMessageDatastore();
        this.textbox = new TextBox(PERSONALIZED_MSG, this.personalMessageDatastore.getPersonalMessage(), personalMessageSize, 0);
        this.textbox.addCommand(this.exit);
        this.textbox.addCommand(this.submit);
        this.textbox.setCommandListener((CommandListener)this);
        display.setCurrent((Displayable)this.textbox);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.submit) {
            String result = this.textbox.getString();
            if (this.screenType.equalsIgnoreCase("email")) {
                this.textCanvas.setActiveState(2);
                this.textCanvas.setUser(result);
                this.display.setCurrent((Displayable)this.textCanvas);
            } else if (this.screenType.equalsIgnoreCase("password")) {
                this.textCanvas.setPassword(result);
                if (!result.equalsIgnoreCase("") && !this.textCanvas.getUser().equalsIgnoreCase("")) {
                    this.textCanvas.setActiveState(3);
                }
                this.display.setCurrent((Displayable)this.textCanvas);
            } else if (this.screenType.equalsIgnoreCase("message")) {
                Logger.printOut("[WALKMATE]: TextBoxCapture - commandAction - MESSAGE");
                this.display.setCurrent((Displayable)this.messageSetup);
                this.personalMessageDatastore.setPersonalMessage(result);
            }
        } else if (command == this.exit) {
            Logger.printOut("[WALKMATE]: TextBoxCapture - commandAction - exit");
            if (this.screenType.equalsIgnoreCase("message")) {
                this.display.setCurrent((Displayable)this.messageSetup);
            } else {
                this.display.setCurrent((Displayable)this.textCanvas);
            }
        }
    }
}

