/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.model.datastore;

import com.sonyericsson.walkmate.Logger;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PersonalMessageDatastore {
    private byte[] data = null;
    private int size;
    private RecordStore recordStore;

    public void delete() {
        try {
            RecordStore.deleteRecordStore((String)"PERSONAL_MESSAGE_DB");
            this.recordStore = null;
        }
        catch (RecordStoreException rse) {
            Logger.printOut("[WALKMATE]: RecordStoreException deleting Record Store: " + rse.getMessage());
        }
    }

    public void setPersonalMessage(String message) {
        block14: {
            try {
                try {
                    this.recordStore = RecordStore.openRecordStore((String)"PERSONAL_MESSAGE_DB", (boolean)true);
                    this.size = this.recordStore.getNumRecords();
                    this.data = message.getBytes();
                    if (this.size == 0) {
                        this.recordStore.addRecord(this.data, 0, this.data.length);
                        break block14;
                    }
                    this.recordStore.setRecord(1, this.data, 0, this.data.length);
                }
                catch (RecordStoreException e) {
                    Logger.printOut("[WALKMATE]: Infomation could not be stored in setPersonalMessage: " + e.getMessage());
                    try {
                        if (this.recordStore != null) {
                            this.recordStore.closeRecordStore();
                        }
                    }
                    catch (RecordStoreException e2) {
                        Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in setPersonalMessage: " + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (this.recordStore != null) {
                        this.recordStore.closeRecordStore();
                    }
                }
                catch (RecordStoreException e) {
                    Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in setPersonalMessage: " + e.getMessage());
                }
            }
        }
    }

    public String getPersonalMessage() {
        String result;
        block15: {
            result = "";
            try {
                try {
                    this.recordStore = RecordStore.openRecordStore((String)"PERSONAL_MESSAGE_DB", (boolean)true);
                    this.size = this.recordStore.getNumRecords();
                    if (this.size != 0) {
                        this.data = new byte[this.recordStore.getRecordSize(1)];
                        this.data = this.recordStore.getRecord(1);
                        int informationSize = this.recordStore.getRecord(1, this.data, 0);
                        if (informationSize != 0) {
                            result = new String(this.data, 0, informationSize);
                        }
                        break block15;
                    }
                    result = "";
                }
                catch (RecordStoreException e) {
                    Logger.printOut("[WALKMATE]: Infomation could not be retrived in getPersonalMessage: " + e.getMessage());
                    try {
                        if (this.recordStore != null) {
                            this.recordStore.closeRecordStore();
                        }
                    }
                    catch (RecordStoreException e2) {
                        Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in getPersonalMessage: " + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (this.recordStore != null) {
                        this.recordStore.closeRecordStore();
                    }
                }
                catch (RecordStoreException e) {
                    Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in getPersonalMessage: " + e.getMessage());
                }
            }
        }
        return result;
    }

    public int getMessageSize() {
        try {
            try {
                this.recordStore = RecordStore.openRecordStore((String)"PERSONAL_MESSAGE_DB", (boolean)true);
                this.size = this.recordStore.getNumRecords();
            }
            catch (RecordStoreException e) {
                Logger.printOut("[WALKMATE]: Could not get size from datastore in getMessageSize: " + e.getMessage());
                try {
                    if (this.recordStore != null) {
                        this.recordStore.closeRecordStore();
                    }
                }
                catch (RecordStoreException e2) {
                    Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in getMessageSize: " + e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (this.recordStore != null) {
                    this.recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException e) {
                Logger.printOut("[WALKMATE]: Could not close PERSONAL_MESSAGE_DB in getMessageSize: " + e.getMessage());
            }
        }
        return this.size;
    }
}

