/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.model.pedometer;

import com.sonyericsson.walkmate.model.ModelListener;
import com.sonyericsson.walkmate.model.pedometer.UtilityTimeOut;
import com.sonyericsson.walkmate.stepcounter.StepDetector;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class UtilityPedometer
implements DataListener {
    private SensorConnection sensorSteps;
    private SensorConnection sensorMovement;
    private StepDetector sd = new StepDetector();
    private int timerCount;
    private int oldAcceleration = -1;
    private int accelerationDelta;
    private int accelerationSum;
    private int movementCounter;
    private int steps = 0;
    private int newStep;
    private double[] axisX = new double[1];
    private double[] axisY = new double[1];
    private double[] axisZ = new double[1];
    private Timer timer = null;
    boolean stepCountInPlatform = true;
    private static final int ACC_DATA_SIZE = 25;
    private int[] accData = new int[25];
    private int accDataPointer = 0;
    private ModelListener listener;

    public boolean startSensor() {
        SensorInfo sensorInfo;
        int i;
        SensorInfo[] sensorInfos;
        try {
            sensorInfos = SensorManager.findSensors((String)"acceleration", (String)"user");
            i = 0;
            while (i != sensorInfos.length) {
                sensorInfo = sensorInfos[i];
                this.sensorMovement = (SensorConnection)Connector.open((String)sensorInfo.getUrl());
                if (this.sensorMovement != null) break;
                ++i;
            }
            this.sensorMovement.setDataListener((DataListener)this, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        try {
            sensorInfos = SensorManager.findSensors((String)"step_count", (String)"user");
            i = 0;
            while (i != sensorInfos.length) {
                sensorInfo = sensorInfos[i];
                this.sensorSteps = (SensorConnection)Connector.open((String)sensorInfo.getUrl());
                if (this.sensorSteps != null) break;
                ++i;
            }
            this.sensorSteps.setDataListener((DataListener)this, 1);
        }
        catch (Exception ex) {
            this.stepCountInPlatform = false;
        }
        return true;
    }

    public void reset() {
        this.steps = 0;
    }

    public void stopSensor() {
        try {
            if (this.sensorSteps != null && this.sensorSteps.getState() != 4 && this.stepCountInPlatform) {
                this.sensorSteps.removeDataListener();
                this.sensorSteps.close();
                this.sensorSteps = null;
            } else if (this.sensorMovement != null && this.sensorMovement.getState() != 4 && !this.stepCountInPlatform) {
                this.sensorMovement.removeDataListener();
                this.sensorMovement.close();
                this.sensorMovement = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] data, boolean isValid) {
        if (sensorConnection == this.sensorSteps && this.stepCountInPlatform) {
            int newSteps = data[0].getIntValues()[0] - this.steps;
            if (newSteps != 0) {
                this.notifySteps(newSteps);
                this.steps += newSteps;
            }
        } else if (sensorConnection == this.sensorMovement && this.stepCountInPlatform) {
            int xSquared = data[0].getIntValues()[0] * data[0].getIntValues()[0];
            int ySquared = data[1].getIntValues()[0] * data[1].getIntValues()[0];
            int zSquared = data[2].getIntValues()[0] * data[2].getIntValues()[0];
            this.accData[this.accDataPointer] = MathUtils.roundSpecial(Math.sqrt(xSquared + ySquared + zSquared));
            this.accDataPointer = (this.accDataPointer + 1) % 25;
            double avgAcc = 0.0;
            int i = 0;
            while (i != this.accData.length) {
                avgAcc += (double)Math.abs(this.accData[i]);
                ++i;
            }
            avgAcc /= (double)this.accData.length;
            if (this.oldAcceleration != -1) {
                this.accelerationDelta = MathUtils.roundSpecial(Math.abs(avgAcc - (double)this.oldAcceleration));
            }
            this.oldAcceleration = MathUtils.roundSpecial(avgAcc);
            this.accelerationSum += this.accelerationDelta;
            if (this.accDataPointer == 0) {
                this.accelerationSum = 0;
            }
            if (this.accelerationSum > 44) {
                ++this.movementCounter;
                if (this.movementCounter == 6) {
                    this.notifyMovement(true);
                } else if (this.movementCounter == 21) {
                    this.movementCounter = 20;
                }
            } else {
                --this.movementCounter;
                if (this.movementCounter == 5) {
                    this.notifyMovement(false);
                } else if (this.movementCounter == -1) {
                    this.movementCounter = 0;
                }
            }
        } else if (!this.stepCountInPlatform) {
            this.axisX[0] = data[0].getIntValues()[0];
            this.axisY[0] = data[1].getIntValues()[0];
            this.axisZ[0] = data[2].getIntValues()[0];
            this.sd.stepDetection(this.axisX, this.axisY, this.axisZ);
            this.newStep = this.sd.getNbrSteps();
            int stepCount = this.newStep - this.steps;
            if (stepCount == 0) {
                ++this.timerCount;
                if (this.sd.getNbrBufferedSteps() == 0 && this.timerCount > 20) {
                    this.allowPowerSaving();
                }
            } else if (this.newStep > this.steps) {
                this.notifySteps(stepCount);
                this.steps += stepCount;
            }
            int xSquared = data[0].getIntValues()[0] * data[0].getIntValues()[0];
            int ySquared = data[1].getIntValues()[0] * data[1].getIntValues()[0];
            int zSquared = data[2].getIntValues()[0] * data[2].getIntValues()[0];
            this.accData[this.accDataPointer] = MathUtils.roundSpecial(Math.sqrt(xSquared + ySquared + zSquared));
            this.accDataPointer = (this.accDataPointer + 1) % 25;
            double avgAcc = 0.0;
            int i = 0;
            while (i != this.accData.length) {
                avgAcc += (double)Math.abs(this.accData[i]);
                ++i;
            }
            avgAcc /= (double)this.accData.length;
            if (this.oldAcceleration != -1) {
                this.accelerationDelta = MathUtils.roundSpecial(Math.abs(avgAcc - (double)this.oldAcceleration));
            }
            this.oldAcceleration = MathUtils.roundSpecial(avgAcc);
            this.accelerationSum += this.accelerationDelta;
            if (this.accDataPointer == 0) {
                this.accelerationSum = 0;
            }
            if (this.accelerationSum > 44) {
                ++this.movementCounter;
                if (this.movementCounter == 6) {
                    this.notifyMovement(true);
                } else if (this.movementCounter == 21) {
                    this.movementCounter = 20;
                }
            } else {
                --this.movementCounter;
                if (this.movementCounter == 5) {
                    this.notifyMovement(false);
                } else if (this.movementCounter == -1) {
                    this.movementCounter = 0;
                }
            }
        }
    }

    public final void allowPowerSaving() {
        this.timerCount = 0;
        this.stopSensor();
        this.timer = new Timer();
        UtilityTimeOut timeOut = new UtilityTimeOut(this);
        this.timer.schedule((TimerTask)timeOut, 5000L);
    }

    public void addListener(ModelListener listener) {
        this.listener = listener;
    }

    private final void notifySteps(int steps) {
        this.listener.updateSteps(steps);
    }

    private final synchronized void notifyMovement(boolean movement) {
        this.listener.updateMovement(movement);
    }
}

