/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.stepcounter;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.stepcounter.Filter;
import java.util.Enumeration;
import java.util.Vector;

public class StepDetector {
    private Filter firstLvlFilter = new Filter();
    private Filter secondLvlFilter = new Filter();
    private double threshold = 150.0;
    private int nbrSteps = 0;
    private double lastDiffVal = 0.0;
    private int lastStepval = -1;
    private int waiting_mode = 1;
    private static int buffersize = 60;
    private Vector sample_since_step = new Vector();

    private void addBufferSteps(int[] steps) {
        Integer temp;
        int timeshift = steps.length;
        int i = 0;
        while (i < this.sample_since_step.size()) {
            temp = (Integer)this.sample_since_step.elementAt(i);
            int t = temp;
            temp = new Integer(t += timeshift);
            this.sample_since_step.setElementAt(temp, i);
            ++i;
        }
        i = 0;
        while (i < steps.length) {
            if (steps[i] == 1) {
                temp = new Integer(timeshift - i);
                this.sample_since_step.addElement(temp);
            }
            ++i;
        }
        Enumeration e = this.sample_since_step.elements();
        while (e.hasMoreElements()) {
            temp = (Integer)e.nextElement();
            if (temp < buffersize) continue;
            this.sample_since_step.removeElement(temp);
        }
    }

    public int getNbrBufferedSteps() {
        return this.sample_since_step.size();
    }

    public int getCurrentStepsPerMinute() {
        if (this.sample_since_step.size() < 4) {
            return 0;
        }
        int nbrDiffs = this.sample_since_step.size() - 1;
        float diffTotal = 0.0f;
        int i = 0;
        while (i < nbrDiffs) {
            Integer a = (Integer)this.sample_since_step.elementAt(i);
            Integer b = (Integer)this.sample_since_step.elementAt(i + 1);
            diffTotal = diffTotal + (float)a.intValue() - (float)b.intValue();
            ++i;
        }
        return (int)(20.0f / (diffTotal / (float)nbrDiffs) * 60.0f);
    }

    public static void main(String[] args) {
        double[] x = new double[]{756.0, 306.0, 486.0, 540.0, 540.0, 630.0, 774.0, 774.0, 990.0, 252.0, 576.0, 720.0, 324.0, 252.0, 180.0, 288.0, 738.0, 450.0, 846.0, 162.0, 882.0, 360.0, 432.0, 468.0, 504.0, 594.0, 684.0, 810.0, 954.0, 594.0, 360.0, 504.0, 720.0, 324.0, 144.0, 234.0, 522.0, 882.0, 432.0, 648.0, 468.0, 738.0, 252.0, 486.0, 558.0, 576.0, 558.0, 810.0, 900.0, 900.0, 450.0, 432.0, 792.0, 450.0, 216.0, 144.0, 198.0, 882.0, 342.0, 774.0, 126.0, 702.0, 450.0, 378.0, 432.0, 504.0, 522.0, 738.0, 864.0, 1044.0, 522.0, 414.0, 648.0, 504.0, 288.0, 144.0, 198.0, 684.0, 648.0, 486.0, 270.0, 630.0, 522.0, 270.0, 468.0, 576.0, 522.0, 630.0, 900.0, 990.0, 522.0, 288.0, 576.0, 594.0, 342.0, 108.0, 162.0, 738.0, 540.0, 1044.0, 126.0};
        double[] y = new double[]{918.0, 702.0, 756.0, 720.0, 702.0, 738.0, 666.0, 900.0, 918.0, 1260.0, 1350.0, 954.0, 486.0, 432.0, 342.0, 432.0, 1620.0, 486.0, 1620.0, 342.0, 954.0, 756.0, 684.0, 702.0, 774.0, 846.0, 630.0, 774.0, 1026.0, 900.0, 1368.0, 1278.0, 756.0, 486.0, 486.0, 306.0, 936.0, 1134.0, 576.0, 1764.0, 306.0, 1026.0, 738.0, 774.0, 738.0, 702.0, 756.0, 666.0, 810.0, 1170.0, 936.0, 1458.0, 1044.0, 432.0, 468.0, 342.0, 306.0, 1854.0, 468.0, 1296.0, 468.0, 810.0, 810.0, 702.0, 774.0, 738.0, 756.0, 666.0, 828.0, 1170.0, 810.0, 1440.0, 1296.0, 612.0, 486.0, 378.0, 198.0, 1332.0, 1044.0, 918.0, 612.0, 810.0, 828.0, 702.0, 792.0, 702.0, 648.0, 792.0, 792.0, 1134.0, 756.0, 1440.0, 1440.0, 540.0, 450.0, 378.0, 216.0, 1494.0, 1224.0, 2034.0, 108.0};
        double[] z = new double[]{162.0, 54.0, 126.0, 144.0, 216.0, 270.0, 216.0, 468.0, 54.0, 126.0, 144.0, 180.0, 198.0, 288.0, 198.0, 360.0, 954.0, 864.0, 468.0, 144.0, 180.0, 306.0, 18.0, 144.0, 198.0, 306.0, 126.0, 306.0, 360.0, 54.0, 18.0, 144.0, 234.0, 144.0, 198.0, 144.0, 576.0, 1134.0, 594.0, 72.0, 18.0, 270.0, 90.0, 54.0, 108.0, 162.0, 234.0, 216.0, 450.0, 198.0, 36.0, 234.0, 126.0, 180.0, 216.0, 180.0, 126.0, 936.0, 882.0, 540.0, 324.0, 288.0, 414.0, 18.0, 180.0, 144.0, 252.0, 108.0, 378.0, 90.0, 162.0, 162.0, 54.0, 144.0, 270.0, 234.0, 162.0, 738.0, 1080.0, 288.0, 324.0, 288.0, 360.0, 18.0, 162.0, 126.0, 252.0, 108.0, 306.0, 270.0, 162.0, 18.0, 162.0, 144.0, 252.0, 216.0, 180.0, 792.0, 1170.0, 360.0, 306.0};
        int[] nArray = new int[99];
        nArray[1] = 1;
        nArray[19] = 1;
        nArray[29] = 1;
        nArray[40] = 1;
        nArray[50] = 1;
        nArray[60] = 1;
        nArray[70] = 1;
        nArray[81] = 1;
        nArray[90] = 1;
        int[] testvect = nArray;
        StepDetector sd = new StepDetector();
        int[] steps = sd.stepDetection(x, y, z);
        Logger.printOut("testvector length = " + testvect.length + "\n");
        Logger.printOut("steps length = " + steps.length + "\n");
        int i = 0;
        while (i < testvect.length) {
            Logger.printOut(String.valueOf(testvect[i]) + ",");
            ++i;
        }
        Logger.printOut("\n");
        i = 0;
        while (i < testvect.length) {
            Logger.printOut(String.valueOf(steps[i]) + ",");
            ++i;
        }
        Logger.printOut("\n");
    }

    public int getNbrSteps() {
        return this.nbrSteps;
    }

    public int[] stepDetection(double[] x, double[] y, double[] z) {
        int tempNbrSteps = 0;
        int[] retval = new int[z.length];
        double[] filtereddata = this.threeDFilter(x, y, z);
        int i = 0;
        while (i < retval.length) {
            retval[i] = 0;
            if (filtereddata[i] - this.threshold > 0.0) {
                if (this.lastStepval == -1) {
                    retval[i] = 1;
                    ++tempNbrSteps;
                }
                this.lastStepval = 1;
            } else if (filtereddata[i] + this.threshold < 0.0) {
                this.lastStepval = -1;
            }
            ++i;
        }
        this.addBufferSteps(retval);
        if (this.getNbrBufferedSteps() > 4) {
            if (this.waiting_mode == 1) {
                this.nbrSteps += this.getNbrBufferedSteps();
                this.waiting_mode = 0;
            } else {
                this.nbrSteps += tempNbrSteps;
            }
        }
        if (this.getNbrBufferedSteps() == 0) {
            this.waiting_mode = 1;
        }
        return retval;
    }

    private double[] threeDFilter(double[] x, double[] y, double[] z) {
        double[] vecnorm = this.vectorNorm(x, y, z);
        vecnorm = this.firstLvlFilter.filterData(vecnorm);
        double[] diffvect = new double[vecnorm.length];
        diffvect[0] = vecnorm[0] - this.lastDiffVal;
        int i = 1;
        while (i < diffvect.length) {
            diffvect[i] = vecnorm[i] - vecnorm[i - 1];
            ++i;
        }
        this.lastDiffVal = vecnorm[vecnorm.length - 1];
        double[] secondfiltdata = this.secondLvlFilter.filterData(diffvect);
        return secondfiltdata;
    }

    private double[] vectorNorm(double[] x, double[] y, double[] z) {
        if (x.length == y.length && y.length == z.length) {
            double[] outdata = new double[x.length];
            int i = 0;
            while (i < x.length) {
                outdata[i] = Math.sqrt(x[i] * x[i] + y[i] * y[i] + z[i] * z[i]);
                ++i;
            }
            return outdata;
        }
        return null;
    }
}

