/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.bluetooth;

import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import javax.microedition.io.Connector;

public class BluetoothConnection {
    private L2CAPConnection l2capConnection;
    private String localName;
    private String remoteName;
    private String url;
    public static int RECEIVE_LENGH = 512;

    public BluetoothConnection(L2CAPConnection con, String ln, String rn) throws IOException {
        this.localName = ln;
        this.remoteName = rn;
        this.url = "";
        this.l2capConnection = con;
    }

    public BluetoothConnection(String urlStrings, String ln, String rn) throws IOException {
        this.localName = ln;
        this.remoteName = rn;
        this.url = urlStrings;
        System.out.println("   url " + this.url);
        this.l2capConnection = (L2CAPConnection)Connector.open((String)urlStrings);
    }

    public synchronized void close() {
        try {
            if (this.l2capConnection != null) {
                this.l2capConnection.close();
                this.l2capConnection = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    protected void setRemoteName(String rn) {
        this.remoteName = rn;
    }

    public static void setLengh(int len) {
        RECEIVE_LENGH = len;
    }

    public byte[] read() throws IOException {
        byte[] receiveBytes = new byte[RECEIVE_LENGH];
        byte[] rtnBytes = null;
        try {
            int length = this.l2capConnection.receive(receiveBytes);
            System.out.println(" look length " + length);
            rtnBytes = new byte[length];
            System.arraycopy(receiveBytes, 0, rtnBytes, 0, length);
        }
        catch (Exception e) {
            return null;
        }
        return rtnBytes;
    }

    public void write(byte[] bytes) throws IOException {
        this.l2capConnection.send(bytes);
    }

    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        short length = (short)bytes.length;
        byte[] sendBytes = new byte[length + 2];
        sendBytes[0] = (byte)length;
        sendBytes[1] = (byte)(length >> 8);
        System.arraycopy(bytes, 0, sendBytes, 2, length);
        this.l2capConnection.send(sendBytes);
    }

    public String readUTF() throws IOException {
        byte[] receiveBytes = new byte[512];
        this.l2capConnection.receive(receiveBytes);
        int length = receiveBytes[0];
        return new String(receiveBytes, 2, length += receiveBytes[1] << 8, "UTF-8");
    }

    public boolean isClosed() {
        return this.l2capConnection == null;
    }
}

