/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.bluetooth;

import com.mbounce.avatar.bluetooth.BluetoothConnection;
import com.mbounce.avatar.cavas.MainCanvas;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class BluetoothConnectionHandler {
    private static final int SERVICE_NAME_BASE_LANGUAGE = 256;
    private static final int MAJOR_DEVICE_CLASS_PHONE = 512;
    public static final int SEARCH_CONNECT_FIRST_FOUND = 1;
    public static final int SEARCH_CONNECT_ALL_FOUND = 2;
    public static final int SEARCH_ALL_DEVICES_SELECT_ONE = 3;
    public static final int SEARCH_ALL_DEVICES_SELECT_SEVERAL = 4;
    private static final int BLUETOOTH_MAX_DEVICES = 7;
    private Display display;
    private LocalDevice localDevice = null;
    private int previousDiscoverabilityMode = -1;
    private String serviceUUID = null;
    private String localName = null;
    private DiscoveryAgent discoveryAgent;
    private Listener listener;
    private int searchType;
    private int serviceSearchTransId;
    private Vector urlStrings;
    private Vector foundServiceRecords;
    private int maxDevices;
    private boolean noDeviceOrServiceSearched;
    private L2CAPConnectionNotifier notifier;
    public static boolean blueOpen = true;
    public static BluetoothConnection[] btConnections;
    private BluetoothConnectionHandler root;
    private Object block_c;
    private Object block_s;
    private Object block_ss;
    private Object block_notifier;
    MainCanvas btCanvas;

    public BluetoothConnectionHandler(MainCanvas btCanvas) throws Exception {
        this.btCanvas = btCanvas;
        this.root = this;
        this.block_c = new Object();
        this.block_s = new Object();
        this.block_ss = new Object();
        this.block_notifier = new Object();
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.maxDevices = Integer.parseInt(LocalDevice.getProperty((String)"bluetooth.connected.devices.max"));
            if (this.maxDevices > 7) {
                this.maxDevices = 7;
            }
            this.setName(this.localDevice.getFriendlyName());
        }
        catch (Exception e) {
            this.localDevice = null;
            throw new Exception();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNotifier() {
        Object object = this.block_notifier;
        synchronized (object) {
            if (this.notifier != null) {
                try {
                    this.notifier.close();
                }
                catch (Exception e) {
                    String string = "Error trying to close notifier" + e.getMessage();
                }
                this.notifier = null;
            }
        }
    }

    public void cancel() {
        try {
            if (this.listener != null) {
                Alert a = new Alert("", "Search cancelled", null, AlertType.INFO);
                a.setTimeout(10000);
                this.display.setCurrent((Displayable)a);
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this.listener);
                waitOnServSearchTermination w = new waitOnServSearchTermination();
                w.start();
            }
            this.listener = null;
            this.closeNotifier();
        }
        catch (Exception e) {
            String string = "Error trying to cancel: " + e.getMessage();
        }
    }

    private void saveDiscoverability() {
        try {
            this.previousDiscoverabilityMode = LocalDevice.getLocalDevice().getDiscoverable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreDiscoverability() {
        try {
            if (this.previousDiscoverabilityMode != -1) {
                this.localDevice.setDiscoverable(this.previousDiscoverabilityMode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setName(String ln) {
        this.localName = ln;
    }

    public void setServiceUUID(String UUID2) {
        this.serviceUUID = UUID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothConnection[] searchService(int st) throws BluetoothStateException, InterruptedException, IOException, SecurityException {
        this.serviceSearchTransId = -1;
        this.searchType = st;
        if (this.searchType == 4 && this.maxDevices == 1) {
            this.searchType = 3;
        }
        this.foundServiceRecords = new Vector();
        this.urlStrings = new Vector();
        this.discoveryAgent = this.localDevice.getDiscoveryAgent();
        this.listener = new Listener();
        this.btCanvas.startSearchDeviceGauge();
        this.noDeviceOrServiceSearched = false;
        Object object = this.block_c;
        synchronized (object) {
            this.discoveryAgent.startInquiry(10390272, (DiscoveryListener)this.listener);
            this.block_c.wait();
        }
        this.btCanvas.setGaugeAuto(false);
        if (this.noDeviceOrServiceSearched) {
            String noSuitable = null;
            Alert al = new Alert(null, noSuitable, null, AlertType.INFO);
            al.setTimeout(2000);
            this.display.setCurrent((Displayable)al);
            Alert alert = al;
            synchronized (alert) {
                try {
                    al.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        btConnections = new BluetoothConnection[this.urlStrings.size()];
        if (this.urlStrings.size() > 0) {
            this.btCanvas.startConnectGauge(this.urlStrings.size());
            int i = 0;
            while (i < this.urlStrings.size()) {
                DataElement de = ((ServiceRecord)this.foundServiceRecords.elementAt(i)).getAttributeValue(256);
                String rname = (String)de.getValue();
                this.btCanvas.setGaugeNextDevice();
                BluetoothConnectionHandler.btConnections[i] = new BluetoothConnection((String)this.urlStrings.elementAt(i), this.localName, rname);
                btConnections[i].writeUTF(this.localName);
                ++i;
            }
            this.btCanvas.setGaugeAuto(false);
        }
        this.listener = null;
        return btConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothConnection[] waitOnConnection() throws BluetoothStateException, IOException, InterruptedException, SecurityException {
        blueOpen = true;
        try {
            this.saveDiscoverability();
            this.localDevice.setDiscoverable(10390272);
            this.notifier = (L2CAPConnectionNotifier)Connector.open((String)("btl2cap://localhost:" + this.serviceUUID + ";name=" + this.localName + ";ReceiveMTU=512;TransmitMTU=512;authorize=false;authenticate=false;encrypt=false"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.btCanvas.waitingConnect();
        if (!this.checkIfBluetoothEnabled()) {
            try {
                this.notifier.close();
                this.notifier = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            blueOpen = false;
            return null;
        }
        acceptAndOpenThread t = new acceptAndOpenThread();
        Object object = this.block_s;
        synchronized (object) {
            t.start();
            this.block_s.wait();
        }
        this.notifier = null;
        this.restoreDiscoverability();
        return btConnections;
    }

    public boolean checkIfBluetoothEnabled() {
        boolean flag = true;
        try {
            LocalDevice.getLocalDevice();
            flag = LocalDevice.isPowerOn();
            return flag;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServSearch() {
        Object object = this.block_ss;
        synchronized (object) {
            if (this.serviceSearchTransId != -1) {
                this.discoveryAgent.cancelServiceSearch(this.serviceSearchTransId);
                try {
                    this.block_ss.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServSearchResult() {
        this.urlStrings.removeAllElements();
        Object object = this.block_c;
        synchronized (object) {
            this.block_c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectService(int index) {
        this.cancelServSearch();
        String selectedURL = (String)this.urlStrings.elementAt(index);
        this.urlStrings.removeAllElements();
        this.urlStrings.addElement(selectedURL);
        Object object = this.block_c;
        synchronized (object) {
            this.block_c.notifyAll();
        }
    }

    private class Listener
    implements DiscoveryListener {
        private Vector cached_devices = new Vector();
        ServiceRecord currServRec;

        public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
            if (cod.getMajorDeviceClass() != 512) {
                return;
            }
            if (!this.cached_devices.contains(btDevice)) {
                this.cached_devices.addElement(btDevice);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inquiryCompleted(int discType) {
            if (discType == 0) {
                if (this.cached_devices.size() == 0) {
                    BluetoothConnectionHandler.this.noDeviceOrServiceSearched = true;
                } else {
                    BluetoothConnectionHandler.this.btCanvas.setGaugeAuto(false);
                    BluetoothConnectionHandler.this.btCanvas.startSearchServiceGauge(this.cached_devices.size());
                    this.nextDeviceServiceSearch();
                    return;
                }
            }
            Object object = BluetoothConnectionHandler.this.block_c;
            synchronized (object) {
                BluetoothConnectionHandler.this.block_c.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextDeviceServiceSearch() {
            RemoteDevice dev;
            UUID[] u = new UUID[]{new UUID(BluetoothConnectionHandler.this.serviceUUID, false)};
            int[] attrbs = new int[]{256};
            BluetoothConnectionHandler.this.btCanvas.setGaugeNextDevice();
            try {
                dev = (RemoteDevice)this.cached_devices.firstElement();
                this.cached_devices.removeElementAt(0);
            }
            catch (Exception e) {
                if (BluetoothConnectionHandler.this.foundServiceRecords.size() == 0) {
                    BluetoothConnectionHandler.this.noDeviceOrServiceSearched = true;
                }
                if (BluetoothConnectionHandler.this.foundServiceRecords.size() == 0 | BluetoothConnectionHandler.this.searchType == 2) {
                    Object object = BluetoothConnectionHandler.this.block_c;
                    synchronized (object) {
                        BluetoothConnectionHandler.this.block_c.notifyAll();
                    }
                }
                if (BluetoothConnectionHandler.this.btCanvas.isStateDeviceChoose()) {
                    BluetoothConnectionHandler.this.btCanvas.deviceListReady();
                }
                return;
            }
            try {
                this.currServRec = null;
                BluetoothConnectionHandler.this.serviceSearchTransId = BluetoothConnectionHandler.this.discoveryAgent.searchServices(attrbs, u, dev, (DiscoveryListener)BluetoothConnectionHandler.this.listener);
            }
            catch (BluetoothStateException e) {
                this.nextDeviceServiceSearch();
            }
        }

        public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
            this.currServRec = servRecord[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int transID, int respCode) {
            Object object = BluetoothConnectionHandler.this.block_ss;
            synchronized (object) {
                BluetoothConnectionHandler.this.serviceSearchTransId = -1;
                if (this.currServRec != null) {
                    BluetoothConnectionHandler.this.foundServiceRecords.addElement(this.currServRec);
                    BluetoothConnectionHandler.this.urlStrings.addElement(this.currServRec.getConnectionURL(0, false));
                }
                switch (BluetoothConnectionHandler.this.searchType) {
                    case 1: {
                        if (this.currServRec == null) break;
                        Object object2 = BluetoothConnectionHandler.this.block_c;
                        synchronized (object2) {
                            BluetoothConnectionHandler.this.block_c.notifyAll();
                        }
                        return;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this.currServRec == null) break;
                        this.displayFoundServices();
                    }
                }
                if (respCode == 2) {
                    Object object3 = BluetoothConnectionHandler.this.block_ss;
                    synchronized (object3) {
                        BluetoothConnectionHandler.this.block_ss.notifyAll();
                    }
                } else {
                    this.nextDeviceServiceSearch();
                }
            }
        }

        private void displayFoundServices() {
            if (!BluetoothConnectionHandler.this.btCanvas.isStateDeviceChoose()) {
                BluetoothConnectionHandler.this.btCanvas.setDeviceList();
            }
            DataElement de = ((ServiceRecord)BluetoothConnectionHandler.this.foundServiceRecords.lastElement()).getAttributeValue(256);
            String rname = (String)de.getValue();
            BluetoothConnectionHandler.this.btCanvas.addDevice2List(rname);
        }
    }

    private class acceptAndOpenThread
    extends Thread {
        private acceptAndOpenThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            blueOpen = true;
            btConnections = new BluetoothConnection[1];
            try {
                L2CAPConnection con = BluetoothConnectionHandler.this.notifier.acceptAndOpen();
                BluetoothConnectionHandler.btConnections[0] = new BluetoothConnection(con, BluetoothConnectionHandler.this.localName, "Host");
                String remoteName = btConnections[0].readUTF();
                btConnections[0].setRemoteName(remoteName);
            }
            catch (Exception e) {
                blueOpen = false;
                BluetoothConnectionHandler.btConnections[0] = null;
            }
            BluetoothConnectionHandler.this.closeNotifier();
            Object object = BluetoothConnectionHandler.this.block_s;
            synchronized (object) {
                BluetoothConnectionHandler.this.block_s.notifyAll();
            }
        }
    }

    private class waitOnServSearchTermination
    extends Thread {
        private waitOnServSearchTermination() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = BluetoothConnectionHandler.this.block_ss;
            synchronized (object) {
                if (BluetoothConnectionHandler.this.serviceSearchTransId != -1) {
                    BluetoothConnectionHandler.this.discoveryAgent.cancelServiceSearch(BluetoothConnectionHandler.this.serviceSearchTransId);
                    try {
                        BluetoothConnectionHandler.this.block_ss.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object2 = BluetoothConnectionHandler.this.block_c;
                    synchronized (object2) {
                        BluetoothConnectionHandler.this.block_c.notifyAll();
                    }
                }
            }
        }
    }
}

