/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.tools;

import com.mbounce.avatar.io.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageAnimation {
    static final int EXTEND_PER_ACTION = 2;
    static final int EXTEND_PER_MODULE = 4;
    static final int EXTEND_PER_SPRITE = 4;
    static final int EXTEND_PER_MECHMODULE = 4;
    static final int EXTEND_PER_COLBOX = 4;
    static final int EXTEND_PER_ATTBOX = 4;
    byte[] m_nFrames;
    byte[][] m_actions;
    short[][] m_frames;
    short[] m_modules;
    byte m_b_RecordAction;
    public Image ManageImage;
    public boolean m_actionOver;
    byte m_durCount = 0;
    byte m_pageID = 0;
    byte m_frameIndex = 0;
    public byte m_b_ActionID;

    public void SetAction(int actionID) {
        if (this.m_b_RecordAction != actionID) {
            this.m_b_ActionID = (byte)actionID;
            this.m_durCount = 0;
            this.m_pageID = 0;
            this.m_frameIndex = (byte)this.getFrame(actionID, 0);
            this.m_b_RecordAction = (byte)actionID;
            this.m_actionOver = false;
        }
    }

    public void DrawAction(Graphics g, int screenX, int screenY) {
        this.ManageFrame();
        this.draw(g, screenX, screenY, this.m_frameIndex);
    }

    public void DrawActionFrame(Graphics g, int screenX, int screenY, int frame) {
        if (frame > this.m_nFrames[this.m_b_ActionID] - 1) {
            frame = 0;
        }
        this.m_frameIndex = (byte)this.getFrame(this.m_b_ActionID, frame);
        this.draw(g, screenX, screenY, this.m_frameIndex);
    }

    public boolean ManageFrame() {
        this.nextFrame(this.m_b_ActionID);
        return this.m_actionOver;
    }

    void nextFrame(byte actionID) {
        this.m_actionOver = false;
        this.m_durCount = (byte)(this.m_durCount + 1);
        if (this.m_durCount < this.m_actions[actionID][(this.m_pageID << 1) + 1]) {
            return;
        }
        this.m_pageID = (byte)(this.m_pageID + 1);
        if (this.m_pageID > this.m_nFrames[actionID] - 1) {
            this.m_pageID = 0;
            this.m_actionOver = true;
        }
        this.m_frameIndex = (byte)this.getFrame(actionID, this.m_pageID);
        this.m_durCount = 0;
    }

    public ImageAnimation(String imagename) {
        this.m_b_RecordAction = (byte)-1;
        this.loadAnimation(imagename);
    }

    public void LoadData(DataInputStream is) {
        try {
            int num;
            int count = is.readUnsignedShort();
            this.m_modules = new short[count * 4];
            int i = 0;
            while (i < count) {
                this.m_modules[4 * i] = is.readShort();
                this.m_modules[4 * i + 1] = is.readShort();
                this.m_modules[4 * i + 2] = is.readShort();
                this.m_modules[4 * i + 3] = is.readShort();
                ++i;
            }
            count = is.readUnsignedShort();
            this.m_frames = new short[count][];
            i = 0;
            while (i < count) {
                num = is.readUnsignedByte();
                this.m_frames[i] = new short[num * 4];
                int j = 0;
                while (j < this.m_frames[i].length) {
                    this.m_frames[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            count = is.readUnsignedShort();
            this.m_nFrames = new byte[count];
            this.m_actions = new byte[count][];
            i = 0;
            while (i < count) {
                num = is.readUnsignedByte();
                this.m_nFrames[i] = (byte)num;
                this.m_actions[i] = new byte[num * 2];
                is.read(this.m_actions[i], 0, num * 2);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("load data error!!!!!!!!!!!!!!!");
            e.printStackTrace();
        }
    }

    public void loadAnimation(String name) {
        try {
            this.ManageImage = ResourceLoader.GetImage("/" + name + ".png");
            ByteArrayInputStream bais = new ByteArrayInputStream(ResourceLoader.loadFromLocal("/" + name + ".bin"));
            DataInputStream is = new DataInputStream(bais);
            this.LoadData(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getFrame(int actionID, int pageID) {
        if (actionID < 0 || actionID >= this.m_nFrames.length) {
            return -1;
        }
        if (pageID < 0 || pageID >= this.m_nFrames[actionID]) {
            return -1;
        }
        return this.m_actions[actionID][pageID << 1] & 0xFF;
    }

    public void draw(Graphics g, int screenX, int screenY, int frameIndex) {
        try {
            short[] s = this.m_frames[frameIndex];
            int dgflag = 0;
            int i = 0;
            while (i < s.length) {
                int modID = s[i] << 2;
                short flag = s[i + 1];
                short modX = this.m_modules[modID];
                short modY = this.m_modules[modID + 1];
                short modW = this.m_modules[modID + 2];
                short modH = this.m_modules[modID + 3];
                boolean flipXs = (flag & 1) != 0;
                boolean flipYs = (flag & 2) != 0;
                int posX = screenX;
                int posY = screenY;
                posX += s[i + 2];
                posY += s[i + 3];
                dgflag = !flipXs && !flipYs ? 0 : (flipXs && !flipYs ? 2 : (!flipXs && flipYs ? 1 : 3));
                g.drawRegion(this.ManageImage, (int)modX, (int)modY, (int)modW, (int)modH, dgflag, posX -= flipXs ? modW : (short)0, posY -= flipYs ? modH : (short)0, 20);
                i += 4;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageAnimation(ImageAnimation anim) {
        this.m_actions = anim.m_actions;
        this.m_nFrames = anim.m_nFrames;
        this.m_frames = anim.m_frames;
        this.m_modules = anim.m_modules;
        this.ManageImage = anim.ManageImage;
        this.m_b_RecordAction = (byte)-1;
    }
}

