/*
 * Decompiled with CFR 0.152.
 */
package com.sony.mutwo.lib;

import com.sony.mutwo.lib.MPMetadata;
import com.sony.mutwo.lib.TimelineMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SmfmfParse {
    public static final String HEADER_ID_GBPM = "GBPM";
    public static final String HEADER_ID_SVNM = "GVNM";
    public static final String HEADER_ID_STBF = "STBF";
    public static final String HEADER_ID_STMO = "STMO";
    public static final String HEADER_ID_STHF = "STHF";
    public static final String HEADER_ID_STSA = "STSA";
    public static final String HEADER_ID_STMM = "STMM";
    public static final String HEADER_ID_STNM = "STNM";
    public static final String HEADER_ID_VNDM = "VNDM";
    protected static final int FRAME_HEADER_LENGTH = 20;
    private static final int STMM_EVENT_TYPE_BEAT = 1;
    private static final int STMM_EVENT_TYPE_CHORD_NUM = 8;
    private static final int STMM_EVENT_TYPE_CHORD_BIT = 9;
    private static final int STMM_EVENT_TYPE_MELODY = 16;
    private static final int STMM_EVENT_TYPE_LYRICS_ANSI = 24;
    private static final int STMM_EVENT_TYPE_LYRICS_UTF8 = 25;
    private static final int STMM_EVENT_TYPE_USER_ACCENT = 32;
    private static final int STMM_EVENT_TYPE_OUTLINE = 47;

    public static MPMetadata GetMpMetadata(byte[] smfmf) {
        try {
            MPMetadata mpMetadata = new MPMetadata();
            byte[] stsa = SmfmfParse.getRawFrameData(HEADER_ID_STSA, smfmf);
            if (stsa == null) {
                throw new Exception();
            }
            mpMetadata.sabiStart = SmfmfParse.assembleUInt32BE(stsa, 20);
            byte[] stbf = SmfmfParse.getRawFrameData(HEADER_ID_STBF, smfmf);
            if (stbf == null) {
                throw new Exception();
            }
            mpMetadata.bpm = stbf[21] & 0xFF;
            int i = 0;
            while (i < 36) {
                mpMetadata.base[i] = (short)(stbf[20 + i] & 0xFF);
                ++i;
            }
            byte[] stmo = SmfmfParse.getRawFrameData(HEADER_ID_STMO, smfmf);
            if (stmo == null) {
                throw new Exception();
            }
            int i2 = 0;
            while (i2 < 10) {
                mpMetadata.mood[i2] = (short)(stmo[20 + 16 * i2 + 3] & 0xFF);
                ++i2;
            }
            byte[] sthf = SmfmfParse.getRawFrameData(HEADER_ID_STHF, smfmf);
            if (sthf == null) {
                throw new Exception();
            }
            int i3 = 0;
            while (i3 < 40) {
                mpMetadata.highLevelFeature[i3] = (short)(sthf[20 + 4 * i3 + 2] & 0xFF);
                ++i3;
            }
            return mpMetadata;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector GetTimelineMetadata(byte[] smfmf) {
        try {
            byte[] stmm = SmfmfParse.getRawFrameData(HEADER_ID_STMM, smfmf);
            if (stmm == null) {
                throw new Exception();
            }
            Vector<TimelineMetadata> vTimelineMetadata = new Vector<TimelineMetadata>();
            ByteArrayInputStream is = new ByteArrayInputStream(stmm);
            long samplingRate = 0L;
            is.skip(20L);
            long zoneSubFrameSize = SmfmfParse.readUInt32BE(is);
            is.skip(zoneSubFrameSize);
            long eventSubFrameSize = SmfmfParse.readUInt32BE(is);
            long eventSubFrameHeaderSize = SmfmfParse.readUInt32BE(is);
            samplingRate = SmfmfParse.readUInt32BE(is);
            long totalSamples = SmfmfParse.readUInt32BE(is);
            is.skip(8L);
            int cc = SmfmfParse.readUInt8(is);
            int bc = SmfmfParse.readUInt8(is);
            int nC = SmfmfParse.readUInt16BE(is);
            is.skip(4L);
            long totalEventCount = SmfmfParse.readUInt32BE(is);
            is.skip(nC * 4);
            long eventSubFrameBodySize = SmfmfParse.readUInt32BE(is);
            if (eventSubFrameBodySize != totalEventCount * 10L) {
                System.out.println("eventSubFrameBodySize = " + eventSubFrameBodySize);
                System.out.println("totalEventCount = " + totalEventCount);
            }
            long samplePos = 0L;
            long pos = 0L;
            int bar = 0;
            int key = 0;
            int bpm = 0;
            short beat = 0;
            short cn = 0;
            short sf = 0;
            short mt = 0;
            short mst = 0;
            short sn = 0;
            boolean minor = false;
            int i = 0;
            while ((long)i < totalEventCount) {
                TimelineMetadata last;
                int barInfo = SmfmfParse.readUInt16BE(is);
                long eventCode = SmfmfParse.readUInt32BE(is);
                long samplePosition = SmfmfParse.readUInt32BE(is);
                bar = barInfo >> 4 & 0xFFF;
                beat = (short)((barInfo & 0xF) > 0 ? barInfo & 0xF : 16);
                samplePos = samplePosition;
                pos = samplePosition * 1000L / samplingRate;
                int category = (int)(eventCode >> 24) & 0x7F;
                block1 : switch (category) {
                    case 47: {
                        int outlineCode = (int)eventCode & 0x7F;
                        int parameter = (int)(eventCode >> 7) & 0xFFFF;
                        switch (outlineCode) {
                            case 2: {
                                key = parameter;
                                break block1;
                            }
                            case 16: {
                                bpm = parameter;
                                break block1;
                            }
                        }
                        break;
                    }
                    case 16: {
                        mt = (short)(eventCode >> 7 & 0x1FL);
                        mst = (short)(eventCode >> 4 & 7L);
                        sn = (short)(eventCode & 0xFL);
                        break;
                    }
                    case 9: {
                        sf = (short)(eventCode & 3L);
                        cn = (short)(eventCode >> 2 & 7L);
                        minor = (eventCode >> 5 & 2L) != 0L;
                        break;
                    }
                }
                if (!vTimelineMetadata.isEmpty() && (last = (TimelineMetadata)vTimelineMetadata.lastElement()) != null && last.samplePos == samplePos) {
                    vTimelineMetadata.removeElementAt(vTimelineMetadata.size() - 1);
                }
                TimelineMetadata tlm = new TimelineMetadata();
                tlm.samplePos = samplePos;
                tlm.pos = pos;
                tlm.bar = bar;
                tlm.beat = beat;
                tlm.bpm = bpm;
                tlm.key = key;
                tlm.chord = SmfmfParse.getAbsoluteToneNumber(key, cn, sf);
                tlm.derivation = minor ? 1 : 0;
                tlm.mt = mt;
                vTimelineMetadata.addElement(tlm);
                ++i;
            }
            is.close();
            return vTimelineMetadata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static short getAbsoluteToneNumber(int key, short cn, short sf) {
        int atn = 255;
        if (key >= 1 && key <= 12 && cn >= 1 && cn <= 7 && sf >= 0 && sf <= 2) {
            int value = 0;
            switch (cn) {
                case 1: {
                    value = 0;
                    break;
                }
                case 2: {
                    value = 2;
                    break;
                }
                case 3: {
                    value = 4;
                    break;
                }
                case 4: {
                    value = 5;
                    break;
                }
                case 5: {
                    value = 7;
                    break;
                }
                case 6: {
                    value = 9;
                    break;
                }
                case 7: {
                    value = 11;
                }
            }
            if ((value += key) > 12) {
                value -= 12;
            }
            if (sf == 1) {
                int n = value = value > 1 ? value - 1 : 12;
            }
            if (sf == 2) {
                value = value < 12 ? value + 1 : 1;
            }
            switch (value) {
                case 1: {
                    atn = 1;
                    break;
                }
                case 2: {
                    atn = 2;
                    break;
                }
                case 3: {
                    atn = 3;
                    break;
                }
                case 4: {
                    atn = 4;
                    break;
                }
                case 5: {
                    atn = 5;
                    break;
                }
                case 6: {
                    atn = 6;
                    break;
                }
                case 7: {
                    atn = 7;
                    break;
                }
                case 8: {
                    atn = 8;
                    break;
                }
                case 9: {
                    atn = 9;
                    break;
                }
                case 10: {
                    atn = 10;
                    break;
                }
                case 11: {
                    atn = 11;
                    break;
                }
                case 12: {
                    atn = 12;
                }
            }
        }
        return (short)atn;
    }

    private static byte[] getRawFrameData(String id, byte[] data) {
        byte[] frame = null;
        try {
            int pos = 0;
            while (pos < data.length) {
                if (pos + 20 > data.length) {
                    throw new Exception();
                }
                String headerId = new String(data, pos, 4);
                int size = (data[pos + 16] & 0xFF) * 256 * 256 * 256 + (data[pos + 17] & 0xFF) * 256 * 256 + (data[pos + 18] & 0xFF) * 256 + (data[pos + 19] & 0xFF);
                if (size <= 0) break;
                if (headerId.equals(id)) {
                    frame = new byte[20 + size];
                    System.arraycopy(data, pos, frame, 0, 20 + size);
                    break;
                }
                pos += 20 + size;
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return frame;
    }

    private static long readUInt32BE(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return (buf[0] & 0xFF) * 256 * 256 * 256 + (buf[1] & 0xFF) * 256 * 256 + (buf[2] & 0xFF) * 256 + (buf[3] & 0xFF);
    }

    private static long assembleUInt32BE(byte[] buf, int offset) {
        return (buf[offset + 0] & 0xFF) * 255 * 255 * 255 + (buf[offset + 1] & 0xFF) * 255 * 255 + (buf[offset + 2] & 0xFF) * 255 + (buf[offset + 3] & 0xFF);
    }

    private static int readUInt16BE(InputStream is) throws IOException {
        byte[] buf = new byte[2];
        is.read(buf);
        return (buf[0] & 0xFF) * 256 + (buf[1] & 0xFF);
    }

    private static int readUInt8(InputStream is) throws IOException {
        byte[] buf = new byte[1];
        is.read(buf);
        return buf[0] & 0xFF;
    }
}

