/*
 * Decompiled with CFR 0.152.
 */
package com.sony.mutwo.musicplayer;

import com.mbounce.avatar.cavas.MainCanvas;
import com.mbounce.avatar.logic.GameMenu;
import com.mbounce.avatar.logic.GamePlay;
import com.sony.mutwo.lib.TimelineMetadata;
import com.sony.mutwo.musicplayer.MusicPlayer;
import com.sony.mutwo.musicplayer.MusicPlayerListener;
import java.util.Vector;

public class MusicPlayerHandler
implements Runnable {
    private static final int TIMER_INTERVAL = 50;
    private static Thread m_thread = null;
    private MusicPlayerListener m_playerListener = null;
    public static MusicPlayer m_musicPlayer = null;
    private long m_lTimelineDelay = 0L;
    private Vector m_vTimelineMetadata = null;
    public int m_nTimelineIndex = 0;
    private long m_lFadeInTime = 0L;
    private long m_lFadeOutTime = 0L;
    private long m_lFadeInStartPos = 0L;
    private long m_lFadeOutStartPos = 0L;
    public static long s_lTotalTime;
    public static long time;
    public static boolean ArrowOver;
    public static boolean MusicOver;
    public static boolean _MusicOver;
    public static long m_lTimerecord;
    private int lastIndex = 0;
    public long flagtime = 0L;

    static {
        time = 0L;
        m_lTimerecord = 0L;
    }

    public boolean stopState() {
        return MusicPlayer.state == 300;
    }

    public MusicPlayerHandler() {
        m_musicPlayer = new MusicPlayer();
        m_musicPlayer.LoadSound();
        s_lTotalTime = m_musicPlayer.getDuration();
        m_lTimerecord = 0L;
        MusicOver = false;
        _MusicOver = false;
        ArrowOver = false;
        this.lastIndex = -99;
        m_thread = new Thread(this);
        if (m_thread != null) {
            m_thread.start();
        }
        this.flagtime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GamePlay.speicedPause = false;
        while (m_thread != null) {
            try {
                MusicPlayerHandler musicPlayerHandler = this;
                synchronized (musicPlayerHandler) {
                    int level;
                    double rate;
                    if (this.m_lFadeInTime > 0L) {
                        rate = (double)(m_musicPlayer.getCurrentPosition() - this.m_lFadeInStartPos) / (double)this.m_lFadeInTime;
                        level = (int)(100.0 * rate * rate);
                        if (level >= 100) {
                            m_musicPlayer.setVolume(100);
                            this.m_lFadeInStartPos = 0L;
                            this.m_lFadeInTime = 0L;
                        } else {
                            m_musicPlayer.setVolume(level);
                        }
                    }
                    if (this.m_lFadeOutTime > 0L) {
                        rate = (double)(m_musicPlayer.getCurrentPosition() - this.m_lFadeOutStartPos) / (double)this.m_lFadeOutTime;
                        level = (int)(100.0 * (1.0 - rate) * (1.0 - rate));
                        if (level <= 0) {
                            m_musicPlayer.stop();
                            this.m_lFadeOutStartPos = 0L;
                            this.m_lFadeOutTime = 0L;
                        } else {
                            m_musicPlayer.setVolume(level);
                        }
                    }
                    if (m_musicPlayer.isPlaying()) {
                        this.flagtime = System.currentTimeMillis();
                        long pos = m_musicPlayer.getCurrentPosition();
                        ++MainCanvas.test1;
                        m_lTimerecord = pos;
                        if (this.m_playerListener != null) {
                            this.m_playerListener.onProgress(pos);
                        }
                        if (this.m_vTimelineMetadata != null && this.m_nTimelineIndex < this.m_vTimelineMetadata.size()) {
                            TimelineMetadata tlm = (TimelineMetadata)this.m_vTimelineMetadata.elementAt(this.m_nTimelineIndex);
                            ArrowOver = false;
                            if (pos >= tlm.pos + this.m_lTimelineDelay) {
                                if (this.m_playerListener != null) {
                                    TimelineMetadata pre_tlm;
                                    TimelineMetadata timelineMetadata = pre_tlm = this.m_nTimelineIndex > 0 ? (TimelineMetadata)this.m_vTimelineMetadata.elementAt(this.m_nTimelineIndex - 1) : null;
                                    if (this.lastIndex < tlm.count || tlm.type == 2) {
                                        this.m_playerListener.onUpdateTimelineEvent(0, tlm);
                                        if (tlm.type != 2) {
                                            this.lastIndex = tlm.count;
                                        }
                                    }
                                }
                                ++this.m_nTimelineIndex;
                            }
                        } else {
                            ArrowOver = true;
                        }
                    } else {
                        ++MainCanvas.test2;
                        long time = m_musicPlayer.getCurrentPosition();
                        if (s_lTotalTime - time < 2000L) {
                            MusicOver = true;
                        }
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                GamePlay.speicedPause = true;
            }
        }
    }

    public synchronized void play(String path, long startPos, long fadeInTime, Vector vTimelineMetadata) {
        this.stop();
        if (fadeInTime > 0L) {
            m_musicPlayer.setVolume(0);
            this.m_lFadeInTime = fadeInTime;
            this.m_lFadeInStartPos = startPos;
        } else {
            m_musicPlayer.setVolume(100);
        }
        this.m_vTimelineMetadata = vTimelineMetadata;
        if (vTimelineMetadata != null) {
            int i = 0;
            while (i < vTimelineMetadata.size()) {
                TimelineMetadata tlm = (TimelineMetadata)vTimelineMetadata.elementAt(i);
                if (tlm.pos >= startPos) break;
                ++this.m_nTimelineIndex;
                ++i;
            }
        }
        if (!GameMenu.soundOn) {
            m_musicPlayer.setVolume(0);
        }
        m_musicPlayer.play(path, startPos);
    }

    public synchronized void stop() {
        m_musicPlayer.stop();
        this.cleanup();
    }

    public synchronized void release() {
        try {
            m_musicPlayer.stop();
            this.cleanup();
            m_musicPlayer.close();
            m_thread.interrupt();
            m_thread = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void fadeOut(long lFadeOutTime) {
        if (lFadeOutTime > 0L) {
            this.m_lFadeOutStartPos = m_musicPlayer.getCurrentPosition();
            this.m_lFadeOutTime = lFadeOutTime;
        } else {
            this.stop();
        }
    }

    public synchronized void setTimelineDelay(long lTimelineDelay) {
        this.m_lTimelineDelay = lTimelineDelay;
    }

    public synchronized void setPlayerListener(MusicPlayerListener listener) {
        this.m_playerListener = listener;
        m_musicPlayer.setPlayerListener(listener);
    }

    public void cleanup() {
        this.m_vTimelineMetadata = null;
        this.m_nTimelineIndex = 0;
        this.m_lFadeInTime = 0L;
        this.m_lFadeOutTime = 0L;
        this.m_lFadeInStartPos = 0L;
        this.m_lFadeOutStartPos = 0L;
    }
}

