/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class GifDecoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected DataInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected int lx;
    protected int ly;
    protected int lw;
    protected int lh;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected byte[] pixels;
    protected int[] dest;
    protected String comment;

    GifDecoder() {
    }

    protected void init() {
        this.status = 0;
        this.gct = null;
        this.lct = null;
        this.pixels = null;
        this.dest = null;
    }

    public int[] getPixels() {
        return this.dest;
    }

    protected void setPixels() {
        this.dest = new int[this.width * this.height];
        int pass = 1;
        int inc = 8;
        int iline = 0;
        for (int i = 0; i < this.ih; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.height) continue;
            int k = line * this.width;
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.width < dlim) {
                dlim = k + this.width;
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                int index;
                int c;
                if ((c = this.act[index = this.pixels[sx++] & 0xFF]) != 0) {
                    this.dest[dx] = c;
                }
                ++dx;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getComment() {
        return this.comment;
    }

    public int read(InputStream is) {
        this.init();
        if (is != null) {
            if (!(is instanceof DataInputStream)) {
                this.in = new DataInputStream(is);
            }
            this.readHeader();
            if (!this.err()) {
                this.readContents();
            }
        } else {
            this.status = 2;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    protected void decodeImageData() {
        int code;
        short[] prefix = null;
        byte[] suffix = null;
        byte[] pixelStack = null;
        int NullCode = -1;
        int npix = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < npix) {
            this.pixels = new byte[npix];
        }
        if (prefix == null) {
            prefix = new short[4096];
        }
        if (suffix == null) {
            suffix = new byte[4096];
        }
        if (pixelStack == null) {
            pixelStack = new byte[4097];
        }
        int data_size = this.read();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        for (code = 0; code < clear; ++code) {
            prefix[code] = 0;
            suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    pixelStack[top++] = suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    pixelStack[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    pixelStack[top++] = suffix[code];
                    code = prefix[code];
                }
                first = suffix[code] & 0xFF;
                if (available >= 4096) break;
                pixelStack[top++] = (byte)first;
                prefix[available] = (short)old_code;
                suffix[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            this.pixels[pi++] = pixelStack[--top];
            ++i;
        }
        for (i = pi; i < npix; ++i) {
            this.pixels[i] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected int read() {
        int curByte = 0;
        try {
            curByte = this.in.read();
        }
        catch (IOException e) {
            this.status = 1;
        }
        return curByte;
    }

    protected int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int count = 0;
                for (n = 0; n < this.blockSize && (count = this.in.read(this.block, n, this.blockSize - n)) != -1; n += count) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int ncolors) {
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        boolean n = false;
        try {
            boolean size = false;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] temp = new byte[nbytes];
            this.in.read(temp);
            out.write(temp, 0, nbytes);
            c = out.toByteArray();
            out.close();
            out = null;
        }
        catch (IOException oe) {
            // empty catch block
        }
        tab = new int[256];
        int i = 0;
        int j = 0;
        while (i < ncolors) {
            int r = c[j++] & 0xFF;
            int g = c[j++] & 0xFF;
            int b = c[j++] & 0xFF;
            tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
        }
        return tab;
    }

    protected void readContents() {
        boolean done = false;
        while (!done && !this.err()) {
            int code = this.read();
            block0 : switch (code) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    code = this.read();
                    switch (code) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            String app = "";
                            for (int i = 0; i < 11; ++i) {
                                app = app + (char)this.block[i];
                            }
                            if (app.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                        case 254: {
                            this.readComment();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    done = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.transparency = (packed & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String id = "";
        for (int i = 0; i < 6; ++i) {
            id = id + (char)this.read();
        }
        if (!id.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int packed = this.read();
        this.lctFlag = (packed & 0x80) != 0;
        this.interlace = (packed & 0x40) != 0;
        this.lctSize = 2 << (packed & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int save = 0;
        if (this.transparency) {
            save = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        this.setPixels();
        if (this.transparency) {
            this.act[this.transIndex] = save;
        }
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int packed = this.read();
        this.gctFlag = (packed & 0x80) != 0;
        this.gctSize = 2 << (packed & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.loopCount = b2 << 8 | b1;
        } while (this.blockSize > 0 && !this.err());
    }

    protected void readComment() {
        try {
            int commentLength = this.in.read();
            char[] commentChar = new char[commentLength];
            for (int i = 0; i < commentLength; ++i) {
                commentChar[i] = (char)this.in.read();
            }
            this.comment = new String(commentChar);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }
}

