/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class GifEncoder {
    static final int BITS = 12;
    static final int HSIZE = 5003;
    private static int n_bits;
    private static int maxbits;
    private static int maxcode;
    private static int maxmaxcode;
    private static int[] htab;
    private static int[] codetab;
    private static int free_ent;
    private static boolean clear_flg;
    private static int g_init_bits;
    private static int EOFCode;
    private static int cur_accum;
    private static int cur_bits;
    private static int[] masks;
    private static int a_count;
    private static byte[] accum;
    static final byte[] m_gifhead;
    static final byte[] m_giftransport_datahead;

    GifEncoder() {
    }

    private static final void clearHashTable(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            GifEncoder.htab[i] = -1;
        }
    }

    private static final void output(int code, OutputStream outs) throws IOException {
        cur_accum &= masks[cur_bits];
        cur_accum = cur_bits > 0 ? (cur_accum |= code << cur_bits) : code;
        cur_bits += n_bits;
        while (cur_bits >= 8) {
            GifEncoder.accum[GifEncoder.a_count++] = (byte)(cur_accum & 0xFF);
            if (a_count >= 254) {
                outs.write(a_count);
                outs.write(accum, 0, a_count);
                a_count = 0;
            }
            cur_accum >>= 8;
            cur_bits -= 8;
        }
        if (free_ent > maxcode || clear_flg) {
            if (clear_flg) {
                int n_bits1 = n_bits = g_init_bits;
                maxcode = (1 << n_bits1) - 1;
                clear_flg = false;
            } else {
                maxcode = ++n_bits == maxbits ? maxmaxcode : (1 << n_bits) - 1;
            }
        }
        if (code == EOFCode) {
            while (cur_bits > 0) {
                GifEncoder.accum[GifEncoder.a_count++] = (byte)(cur_accum & 0xFF);
                if (a_count >= 254) {
                    outs.write(a_count);
                    outs.write(accum, 0, a_count);
                    a_count = 0;
                }
                cur_accum >>= 8;
                cur_bits -= 8;
            }
            if (a_count > 0) {
                outs.write(a_count);
                outs.write(accum, 0, a_count);
                a_count = 0;
            }
        }
    }

    private static void addComment(String comment, OutputStream outs) throws IOException {
        outs.write(33);
        outs.write(254);
        int remainder = comment.length() % 255;
        int nsubblocks_full = comment.length() / 255;
        int nsubblocks = nsubblocks_full + (remainder > 0 ? 1 : 0);
        int ibyte = 0;
        for (int isb = 0; isb < nsubblocks; ++isb) {
            int size = isb < nsubblocks_full ? 255 : remainder;
            outs.write(size);
            GifEncoder.ascii(comment.substring(ibyte, ibyte + size), outs);
            ibyte += size;
        }
        outs.write(0);
    }

    private static void ascii(String s, OutputStream os) throws IOException {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        os.write(bytes);
    }

    public static final byte[] makeGIFFromRGB(int pictureWidth, int pictureHeight, int[] RGBArray) {
        return GifEncoder.makeGIFFromRGB(pictureWidth, pictureHeight, RGBArray, null);
    }

    public static final byte[] makeGIFFromRGB(int pictureWidth, int pictureHeight, int[] RGBArray, String comment) {
        int d;
        int i;
        int[] paletteRGB = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            paletteRGB[i2] = 0xF0000F;
        }
        paletteRGB[0] = 0xFFFF00;
        int palNumber = 0;
        block5: for (int i3 = 0; i3 < pictureWidth * pictureHeight; ++i3) {
            if (RGBArray[i3] == 0xFFFF00) {
                RGBArray[i3] = 0;
                continue;
            }
            for (int j = 0; j < palNumber + 1; ++j) {
                if (RGBArray[i3] == paletteRGB[j]) {
                    RGBArray[i3] = j;
                    continue block5;
                }
                if (RGBArray[i3] == paletteRGB[j] || j != palNumber) continue;
                paletteRGB[++palNumber] = RGBArray[i3];
                RGBArray[i3] = palNumber;
                continue block5;
            }
        }
        int imgSize = pictureWidth * pictureHeight + 768;
        byte[] gis = new byte[imgSize];
        for (i = 0; i < 256; ++i) {
            gis[i * 3] = (byte)((paletteRGB[i] & 0xFF0000) >> 16);
            gis[i * 3 + 1] = (byte)((paletteRGB[i] & 0xFF00) >> 8);
            gis[i * 3 + 2] = (byte)(paletteRGB[i] & 0xFF);
        }
        i = 768;
        int j = 0;
        while (i < imgSize) {
            gis[i] = (byte)RGBArray[j];
            ++i;
            ++j;
        }
        byte[] pels = new byte[pictureWidth * pictureHeight];
        int cplen = 255;
        for (d = 2; cplen > d; d <<= 1) {
        }
        cplen *= 3;
        GifEncoder.m_giftransport_datahead[13] = GifEncoder.m_gifhead[6] = (byte)pictureWidth;
        GifEncoder.m_giftransport_datahead[15] = GifEncoder.m_gifhead[8] = (byte)pictureHeight;
        GifEncoder.m_gifhead[10] = -9;
        int point = 0;
        int z = 768;
        System.arraycopy(gis, z, pels, point, pictureWidth * pictureHeight);
        cplen = d * 3;
        try {
            int fcode;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int initCodeSize = 8;
            out.write(initCodeSize);
            int nPixelCount = pictureWidth * pictureHeight;
            int curPixel = 0;
            g_init_bits = ++initCodeSize;
            clear_flg = false;
            n_bits = g_init_bits;
            maxcode = (1 << n_bits) - 1;
            int clearCode = 1 << initCodeSize - 1;
            EOFCode = clearCode + 1;
            free_ent = clearCode + 2;
            a_count = 0;
            int ent = RGBArray[curPixel++] & 0xFF;
            int hshift = 0;
            for (fcode = 5003; fcode < 65536; fcode *= 2) {
                ++hshift;
            }
            hshift = 8 - hshift;
            int hsize_reg = 5003;
            GifEncoder.clearHashTable(hsize_reg);
            cur_bits = 0;
            GifEncoder.output(clearCode, out);
            block11: while (curPixel < nPixelCount) {
                int i4;
                int c;
                fcode = (c << maxbits) + ent;
                if (htab[i4 = (c = RGBArray[curPixel++] & 0xFF) << hshift ^ ent] == fcode) {
                    ent = codetab[i4];
                    continue;
                }
                if (htab[i4] >= 0) {
                    int disp = hsize_reg - i4;
                    if (i4 == 0) {
                        disp = 1;
                    }
                    do {
                        if ((i4 -= disp) < 0) {
                            i4 += hsize_reg;
                        }
                        if (htab[i4] != fcode) continue;
                        ent = codetab[i4];
                        continue block11;
                    } while (htab[i4] >= 0);
                }
                GifEncoder.output(ent, out);
                ent = c;
                if (free_ent < maxmaxcode) {
                    ++free_ent;
                    GifEncoder.htab[i4] = fcode;
                    continue;
                }
                GifEncoder.clearHashTable(5003);
                free_ent = clearCode + 2;
                clear_flg = true;
                GifEncoder.output(clearCode, out);
            }
            GifEncoder.output(ent, out);
            GifEncoder.output(EOFCode, out);
            out.write(0);
            if (comment != null) {
                GifEncoder.addComment(comment, out);
            }
            int ret = 0;
            int retLength = cplen + m_gifhead.length + m_giftransport_datahead.length + out.size() + 1;
            byte[] retArray = new byte[retLength];
            System.arraycopy(m_gifhead, 0, retArray, ret, m_gifhead.length);
            System.arraycopy(gis, 0, retArray, ret += m_gifhead.length, 768);
            System.arraycopy(m_giftransport_datahead, 0, retArray, ret += cplen, m_giftransport_datahead.length);
            System.arraycopy(out.toByteArray(), 0, retArray, ret += m_giftransport_datahead.length, out.size());
            ret += out.size();
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            out = null;
            pels = null;
            retArray[ret] = 59;
            return retArray;
        }
        catch (Exception exc) {
            return null;
        }
    }

    static {
        maxbits = 12;
        maxmaxcode = 4096;
        htab = new int[5003];
        codetab = new int[5003];
        free_ent = 0;
        clear_flg = false;
        cur_accum = 0;
        cur_bits = 0;
        masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        accum = new byte[256];
        m_gifhead = new byte[]{71, 73, 70, 56, 57, 97, 0, 0, 0, 0, 0, 0, 0};
        m_giftransport_datahead = new byte[]{33, -7, 4, 1, 0, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

