/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TPPixel {
    final int PX;
    final int PY;
    final int totalPixels;
    int pix;
    int padX;
    int padY;
    int fullWidth;
    int fullHeight;
    int currentTone = 1;
    int currentColourIndex = 0;
    int currentColour = TPUtil.COLOUR_SET[this.currentColourIndex][this.currentTone];
    TPGrid mainGrid = new TPGrid(new int[972]);
    TPGrid undoGrid = new TPGrid(new int[972]);
    private boolean loaded = true;

    public TPPixel() {
        this.PX = 27;
        this.PY = 36;
        this.totalPixels = 972;
        this.calculateSizes();
        this.setup();
    }

    void calculateSizes() {
        int pixX = TP.canvas.width / 27;
        int pixY = TP.canvas.height / 36;
        this.pix = pixX < pixY ? pixX : pixY;
        this.fullWidth = 27 * this.pix;
        this.fullHeight = 36 * this.pix;
        this.padX = (TP.canvas.width - this.fullWidth) / 2;
        this.padY = (TP.canvas.height - this.fullHeight) / 2;
    }

    void setup() {
        for (int i = 0; i < this.mainGrid.grid.length; ++i) {
            this.mainGrid.grid[i] = 0xFFFFFF;
        }
        TP.canvas.repaint();
    }

    void changeCell(int x, int y, int keyCode) {
        int size = TP.sel.selX[TP.sel.level + 1];
        int startX = x * size + TP.sel.x;
        int startY = y * size + TP.sel.y;
        if (TP.key.lastKey == keyCode || this.isCellTone(startX, startY, size, this.currentColour)) {
            this.incrementTone();
        }
        this.backUp();
        this.setCells(startX, startY, size);
        TP.canvas.repaint();
    }

    void set(int x, int y, int tone) {
        this.mainGrid.grid[y * 27 + x] = tone;
    }

    int get(int x, int y) {
        return this.mainGrid.getColour(x, y);
    }

    int[] getColourPixels() {
        return this.getColourPixels(1);
    }

    int[] getColourPixels(int scale) {
        if (scale <= 1) {
            int[] newGrid = new int[972];
            System.arraycopy(this.mainGrid.grid, 0, newGrid, 0, 972);
            return newGrid;
        }
        return TPUtil.resizeArray(this.mainGrid.grid, 27, 36, 27 * scale, 36 * scale);
    }

    Image getImage(int size) {
        TP.pix.getClass();
        TP.pix.getClass();
        Image image = Image.createImage((int)(27 * size), (int)(36 * size));
        Graphics g = image.getGraphics();
        int x = 0;
        while (true) {
            TP.pix.getClass();
            if (x >= 27) break;
            int y = 0;
            while (true) {
                TP.pix.getClass();
                if (y >= 36) break;
                g.setColor(TP.pix.get(x, y));
                g.fillRect(x * size, y * size, size, size);
                ++y;
            }
            ++x;
        }
        return image;
    }

    byte[] getGIF(int size) {
        int[] pixels = TP.pix.getColourPixels(size);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.start(bos);
        TP.pix.getClass();
        TP.pix.getClass();
        encoder.setSize(27 * size, 36 * size);
        encoder.addFrame(pixels);
        encoder.finish();
        return bos.toByteArray();
    }

    void setCells(int x, int y, int size) {
        this.setCells(x, y, size, size, this.currentColour);
    }

    void setCells(int x, int y, int size, int colour) {
        this.setCells(x, y, size, size, colour);
    }

    void setCells(int x, int y, int width, int height, int colour) {
        for (int i = x; i < x + width; ++i) {
            for (int j = y; j < y + height; ++j) {
                this.set(i, j, colour);
            }
        }
    }

    void incrementTone() {
        this.currentTone = this.currentTone >= TPUtil.TONES.length - 1 ? 0 : ++this.currentTone;
        this.currentColour = TPUtil.COLOUR_SET[this.currentColourIndex][this.currentTone];
    }

    void setColourIndex(int index) {
        this.currentColourIndex = index;
        this.currentTone = 1;
        this.currentColour = TPUtil.COLOUR_SET[this.currentColourIndex][this.currentTone];
    }

    boolean isCellTone(int x, int y, int size, int colour) {
        return this.isCellTone(x, y, size, size, colour);
    }

    boolean isCellTone(int x, int y, int width, int height, int colour) {
        for (int i = x; i < x + width; ++i) {
            for (int j = y; j < y + height; ++j) {
                if (this.get(i, j) == colour) continue;
                return false;
            }
        }
        return true;
    }

    void drawLine(int keyCode) {
        int size = TP.sel.selX[TP.sel.level + 1];
        int startX = TP.key.lastKeyPadX * size + TP.sel.x;
        int startY = TP.key.lastKeyPadY * size + TP.sel.y;
        switch (keyCode) {
            case 1: {
                if (startY <= 0) break;
                startY -= size;
                break;
            }
            case 6: {
                if (startY >= 36 - size) break;
                startY += size;
                break;
            }
            case 2: {
                if (startX <= 0) break;
                startX -= size;
                break;
            }
            case 5: {
                if (startX >= 27 - size) break;
                startX += size;
            }
        }
        this.setCells(startX, startY, size);
        TP.sel.x = startX - TP.key.lastKeyPadX * size;
        TP.sel.y = startY - TP.key.lastKeyPadY * size;
        if (!TP.key.joystick) {
            TP.canvas.repaint();
        }
    }

    void clear() {
        if (TP.key.lastKey == -8 || this.isCellTone(TP.sel.x, TP.sel.y, TP.sel.selX[TP.sel.level], TP.sel.selY[TP.sel.level], this.currentColour)) {
            this.incrementTone();
        }
        this.backUp();
        this.setCells(TP.sel.x, TP.sel.y, TP.sel.selX[TP.sel.level], TP.sel.selY[TP.sel.level], this.currentColour);
        TP.canvas.repaint();
    }

    void clearMove() {
        this.setCells(TP.sel.x, TP.sel.y, TP.sel.selX[TP.sel.level], TP.sel.selY[TP.sel.level], this.currentColour);
        if (!TP.key.joystick) {
            TP.canvas.repaint();
        }
    }

    void load(TPGrid grid) {
        TP.pix.mainGrid = grid;
    }

    void backUp() {
        if (this.loaded) {
            this.loaded = false;
        }
        this.mainGrid.clone(this.undoGrid);
    }

    void restore() {
        if (!this.loaded) {
            int[] temp = new int[972];
            System.arraycopy(this.mainGrid.grid, 0, temp, 0, this.mainGrid.grid.length);
            TPGrid tempGrid = new TPGrid(temp);
            this.undoGrid.clone(this.mainGrid);
            tempGrid.clone(this.undoGrid);
            TP.canvas.repaint();
        }
    }
}

