/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;

public class TPTimer {
    private TimerTask timerTask;
    private Timer timer;
    private TPTimerInterface target;
    private TPTimer myself;
    private boolean running = false;
    private int delay;
    private boolean repeat;

    TPTimer(TPTimerInterface target, int delay) {
        this.setup(target, delay, false);
    }

    TPTimer(TPTimerInterface target, int delay, boolean repeat) {
        this.setup(target, delay, repeat);
    }

    TPTimer(TimerTask timerTask, int delay) {
        this.timerTask = timerTask;
        this.delay = delay;
        this.repeat = false;
    }

    private void setup(TPTimerInterface target, int delay, boolean repeat) {
        this.target = target;
        this.delay = delay;
        this.repeat = repeat;
        this.myself = this;
    }

    int getDelay() {
        return this.delay;
    }

    void setDelay(int delay) {
        this.delay = delay;
    }

    boolean isRepeat() {
        return this.repeat;
    }

    void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    boolean isRunning() {
        return this.running;
    }

    void restartTimer() {
        if (this.running) {
            this.stopTimer();
        }
        this.startTimer();
    }

    void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.running = false;
    }

    void startTimer() {
        if (!this.running) {
            if (this.timerTask == null) {
                this.timerTask = new TimerTask(){

                    public void run() {
                        TPTimer.this.target.timerEvent(TPTimer.this.myself);
                    }
                };
            }
            if (this.timer == null) {
                this.timer = new Timer();
            }
            if (this.repeat) {
                this.timer.schedule(this.timerTask, this.delay, (long)this.delay);
            } else {
                this.timer.schedule(this.timerTask, this.delay);
            }
            this.running = true;
        }
    }
}

