/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class TPWaitCanvas
extends Canvas
implements TPTimerInterface {
    private int count = 0;
    private final int maximum;
    private final int interval;
    private TPTimer timer;
    private TPTimer exitTimer;
    private int diameter;
    final int x;
    final int y;
    final int stringX;
    final int stringY;
    private String message;
    private final String cancelLabel = TPLocale.getMessage("Cancel");
    boolean exitFlg = false;

    public TPWaitCanvas() {
        this.maximum = 36;
        this.interval = 100;
        this.setFullScreenMode(true);
        this.y = this.x = this.getWidth() / 10;
        int halfWidth = this.getWidth() / 12;
        int halfHeight = this.getHeight() / 12;
        this.diameter = Math.min(halfWidth, halfHeight);
        this.stringX = this.x + this.diameter + 5;
        this.stringY = this.y;
        this.timer = new TPTimer(this, 100, true);
    }

    void setMessage(String message) {
        this.message = message;
        this.timer.startTimer();
        this.addCancelCommand();
        this.repaint();
        TP.setDisplay((Displayable)this);
    }

    void setTempMessage(String message) {
        this.message = message;
        this.timer.startTimer();
        this.exitTimer = new TPTimer(this, 2000);
        this.exitTimer.startTimer();
        this.exitFlg = true;
        this.addCancelCommand();
        this.repaint();
        TP.setDisplay((Displayable)this);
    }

    void stopCanvas() {
        this.timer.stopTimer();
    }

    void startCanvas() {
        this.timer.startTimer();
    }

    private void addCancelCommand() {
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int theta = -(this.count * 360 / 36);
        if (this.message.endsWith("...")) {
            g.setColor(0x999999);
            g.drawArc(this.x, this.y, this.diameter, this.diameter, 0, 360);
            g.fillArc(this.x, this.y, this.diameter, this.diameter, theta + 90, 90);
            g.fillArc(this.x, this.y, this.diameter, this.diameter, theta + 270, 90);
        } else {
            g.drawArc(this.x, this.y, this.diameter, this.diameter, 0, 360);
        }
        g.setColor(0x999999);
        if (this.message != null) {
            g.setFont(TPUtil.FONT_SMALL);
            if (this.message.endsWith("...")) {
                g.drawString(this.message, this.stringX, this.stringY, 20);
            } else {
                g.drawString(this.message, this.x, this.y, 20);
            }
        }
        g.setColor(0x999999);
        if (!this.message.equals(TPLocale.getMessage("Saveing")) && this.message.endsWith("...")) {
            g.setFont(TPUtil.FONT_MEDIUM);
            g.drawString(this.cancelLabel, this.getWidth() - 8, this.getHeight() - 8, 40);
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -7 && !this.message.equals(TPLocale.getMessage("Saveing")) && !this.exitFlg) {
            TP.connect.cancel();
            TP.wait.stopCanvas();
            if (this.message.endsWith("...")) {
                TP.setDisplay((Displayable)TP.canvas);
            }
        }
    }

    public void timerEvent(TPTimer timer) {
        if (timer == this.timer) {
            this.count = (this.count + 1) % 36;
            this.repaint();
        } else if (timer == this.exitTimer) {
            this.exitFlg = false;
            this.timer.stopTimer();
            if (TP.thumb.deleteFlg) {
                TP.thumb.deleteFlg = false;
                if (TP.menu.onlineMenuIndex == 3) {
                    if (TP.connect.numberOfImages == 1 && TP.thumb.index == 0) {
                        TP.setDisplay((Displayable)TP.canvas);
                    } else {
                        TP.thumb.reset();
                        TP.wait.setMessage(TPLocale.getMessage("Connecting"));
                        TP.connect.go(2);
                    }
                }
                TP.thumb.reset();
            } else if (TP.menu.onlineMenuIndex == 2) {
                TP.menu.showKeyWord();
            } else {
                TP.returnToPreviousScreen();
            }
        }
    }
}

