/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class ResourceLoader {
    private static String[] map_key_filename;
    private static int[] map_value_pkg_id;
    private static final String PACKAGE_MAP = "/package_file_map.map";
    private static final String PACKAGE_NAME = "/package.pkg";
    public static final byte _KEEP_ORIGINAL_IMAGE = -1;

    public static void loadPkgMap() {
        if (map_key_filename == null) {
            FilterInputStream din = null;
            try {
                try {
                    din = new DataInputStream(PACKAGE_MAP.getClass().getResourceAsStream(PACKAGE_MAP));
                    int num = ((DataInputStream)din).readInt();
                    map_key_filename = new String[num];
                    map_value_pkg_id = new int[num];
                    int i = 0;
                    while (i < num) {
                        ResourceLoader.map_key_filename[i] = ((DataInputStream)din).readUTF().toLowerCase();
                        ResourceLoader.map_value_pkg_id[i] = ((DataInputStream)din).readByte() & 0xFF;
                        ++i;
                    }
                    i = 0;
                    while (i < num) {
                        int j = i + 1;
                        while (j < num) {
                            if (map_key_filename[i].compareTo(map_key_filename[j]) > 0) {
                                String ts = map_key_filename[i];
                                ResourceLoader.map_key_filename[i] = map_key_filename[j];
                                ResourceLoader.map_key_filename[j] = ts;
                                int ti = map_value_pkg_id[i];
                                ResourceLoader.map_value_pkg_id[i] = map_value_pkg_id[j];
                                ResourceLoader.map_value_pkg_id[j] = ti;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("!\tWARNING\t\tset package map NULL");
                    map_key_filename = new String[0];
                    map_value_pkg_id = new int[0];
                }
            }
            finally {
                try {
                    din.close();
                    din = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static int findFilePkgId(String filename) {
        if (map_key_filename == null) {
            return -1;
        }
        int low = 0;
        int high = map_key_filename.length - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            int r = filename.compareTo(map_key_filename[middle]);
            if (r < 0) {
                high = middle - 1;
                continue;
            }
            if (r > 0) {
                low = middle + 1;
                continue;
            }
            return map_value_pkg_id[middle];
        }
        return -1;
    }

    public static byte[] loadFromPkg(String pkgName, String filename) {
        byte[] data = null;
        try {
            DataInputStream din = new DataInputStream(pkgName.getClass().getResourceAsStream(pkgName));
            int n = din.readShort();
            int o = din.readInt();
            int skip = 0;
            int length = 0;
            boolean find = false;
            int i = 0;
            while (i < n) {
                String fn = din.readUTF().toLowerCase();
                int len = din.readInt();
                if (!find) {
                    if (fn.equals(filename)) {
                        length = len;
                        find = true;
                    } else {
                        skip += len;
                    }
                }
                ++i;
            }
            if (find) {
                data = new byte[length];
                din.skip(skip);
                din.read(data);
            }
            din.close();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] load(String filename) {
        int pkgId;
        byte[] data = ResourceLoader.loadFromLocal(filename = filename.toLowerCase());
        if (data != null) {
            return data;
        }
        ResourceLoader.loadPkgMap();
        String fn = filename;
        int i = fn.lastIndexOf(47);
        if (i >= 0) {
            fn = fn.substring(i + 1);
        }
        if ((pkgId = ResourceLoader.findFilePkgId(fn)) >= 0) {
            String pn = PACKAGE_NAME + pkgId;
            data = ResourceLoader.loadFromPkg(pn, fn);
            if (data == null) {
                System.out.println("!\tERROR\t\tcan't load file " + filename + " from package " + pn);
            }
        } else {
            data = ResourceLoader.loadFromLocal(filename);
        }
        return data;
    }

    /*
     * Loose catch block
     */
    public static byte[] loadFromLocal1(String filename) {
        byte[] data = null;
        FilterInputStream din = null;
        ByteArrayOutputStream baos = null;
        din = new DataInputStream(filename.getClass().getResourceAsStream(filename));
        baos = new ByteArrayOutputStream();
        int d = 0;
        while ((d = din.read()) != -1) {
            baos.write(d);
        }
        data = baos.toByteArray();
        baos.close();
        byte[] byArray = data;
        try {
            if (din != null) {
                din.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
        catch (Exception d2) {
            try {
                if (din != null) {
                    din.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    if (din != null) {
                        din.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static byte[] loadFromLocal(String filename) {
        filename = filename.toLowerCase();
        try {
            DataInputStream din = new DataInputStream(filename.getClass().getResourceAsStream(filename));
            int size = din.available();
            byte[] data = new byte[size];
            din.read(data);
            din.close();
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean IsFileExist(String filename) {
        byte[] data = ResourceLoader.load(filename);
        return data != null;
    }

    public static DataInputStream LoadStream(String name) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ResourceLoader.load("/" + name));
            DataInputStream din = new DataInputStream(bais);
            return din;
        }
        catch (Exception e) {
            System.out.println("!\tERROR\tload stream error:\t" + name);
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteRMS(String filename) {
        try {
            RecordStore.deleteRecordStore((String)filename);
        }
        catch (Exception e) {
            System.out.println("Can't delete rms with filename:" + filename);
        }
    }

    public static boolean saveToRMS(String filename, String string) {
        return ResourceLoader.saveToRMS(filename, string.getBytes());
    }

    public static boolean saveToRMS(String filename, byte[] data) {
        try {
            RecordStore.deleteRecordStore((String)filename);
        }
        catch (Exception e) {
            e.getMessage();
        }
        try {
            RecordStore mystore = RecordStore.openRecordStore((String)filename, (boolean)true, (int)1, (boolean)true);
            mystore.addRecord(data, 0, data.length);
            mystore.closeRecordStore();
        }
        catch (Exception e) {
            e.getMessage();
            return false;
        }
        return true;
    }

    public static String loadFromRMS(String filename, String defaultValue, boolean readOnly, String vendor, String midletName) {
        byte[] bytes = ResourceLoader.loadFromRMS(filename, null, readOnly, vendor, midletName);
        return bytes != null ? new String(bytes) : defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] loadFromRMS(String filename, byte[] defaultValue, boolean readOnly, String vendor, String midletName) {
        void var1_1;
        RecordStore mystore = null;
        try {
            mystore = readOnly ? RecordStore.openRecordStore((String)filename, (String)vendor, (String)midletName) : RecordStore.openRecordStore((String)filename, (boolean)false, (int)1, (boolean)true);
            byte[] byArray = mystore.getRecord(1);
            return byArray;
        }
        catch (Exception e) {
            e.getMessage();
        }
        finally {
            try {
                mystore.closeRecordStore();
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return var1_1;
    }

    public static String[] loadText(String url) {
        String[] txt = null;
        Vector<String> strings = new Vector<String>();
        byte[] data = ResourceLoader.load(url);
        int offset = 0;
        int length = 0;
        boolean isText = false;
        while (offset + length < data.length) {
            if (data[offset + length] == 34) {
                if (isText) {
                    String text = new String(data, offset, length);
                    strings.addElement(text);
                    isText = false;
                } else {
                    isText = true;
                }
                offset += length + 1;
                length = 0;
                continue;
            }
            ++length;
        }
        txt = new String[strings.size()];
        int i = 0;
        while (i < txt.length) {
            txt[i] = (String)strings.elementAt(i);
            ++i;
        }
        return txt;
    }

    public static Image GetImage(String Name) {
        return ResourceLoader.GetImage(Name, -1);
    }

    public static Image GetImage(String Name, int flag) {
        String palName = Name = Name.toLowerCase();
        int i = Name.indexOf(".png");
        if (i < 0) {
            Name = String.valueOf(Name) + ".png";
        } else {
            palName = palName.substring(0, i);
        }
        palName = String.valueOf(palName) + ".table";
        byte[] b = ResourceLoader.load("/" + Name);
        if (flag == -1) {
            try {
                return Image.createImage((byte[])b, (int)0, (int)b.length);
            }
            catch (Exception e) {
                System.out.println("!\tERROR\tcan't load image " + Name);
                e.printStackTrace();
                return null;
            }
        }
        try {
            byte[] c = ResourceLoader.load("/" + palName);
            Image img = ResourceLoader.ChangeColor(b, c, flag);
            return img;
        }
        catch (Exception e) {
            System.out.println("!\tERROR\tcan't change palette " + Name);
            return null;
        }
    }

    public static Image ChangeColor(byte[] data, byte[] color, int level) throws Exception {
        int table = (color.length - 1) / color[0];
        int Flag = -1;
        int i = 0;
        while (i < data.length) {
            if (data[i] == 80 && data[i + 1] == 76 && data[i + 2] == 84 && data[i + 3] == 69) {
                Flag = i + 4;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < table) {
            data[Flag + i] = color[i + table * level + 1];
            ++i;
        }
        Image im = Image.createImage((byte[])data, (int)0, (int)data.length);
        return im;
    }
}

