/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.sensor;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Condition;
import javax.microedition.sensor.ConditionListener;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.LimitCondition;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class MySensor
implements DataListener,
ConditionListener {
    public static final int TYPE_ACCELERATION = 0;
    public static final int TYPE_BATTERY = 1;
    public static final int TYPE_NET_SIGNAL = 2;
    public static final int TYPE_KEY_LOCK = 3;
    public int type;
    private SensorConnection sensor;
    public String URL;
    private MySensorDataListener dataListener;
    private String[] channelNames = new String[3];
    private int[] channels = new int[3];
    private int[][][] channelRanges;
    ChannelInfo handsfreeChannelInfo = null;
    public int key_lock_value = -1;
    public int key_lock_value_old = -1;
    public long keylock_time = 0L;
    public String[] names = new String[10];

    private MySensor() {
    }

    public static MySensor create(int sensorType) {
        String sensorVersion = System.getProperty("microedition.sensor.version");
        if (sensorVersion == null) {
            System.out.println("Error: Sensor not supported!");
            return null;
        }
        System.out.println("Sensor version: " + sensorVersion);
        MySensor newSensor = new MySensor();
        newSensor.type = sensorType;
        if (!newSensor.findDeviceInfo()) {
            System.out.println("Error: Failed to find a sensor from this device.");
            newSensor = null;
            return null;
        }
        return newSensor;
    }

    public boolean open(MySensorDataListener listener) {
        try {
            this.sensor = (SensorConnection)Connector.open((String)this.URL);
            this.dataListener = listener;
            this.sensor.setDataListener((DataListener)this, 1);
            if (this.type == 3) {
                this.handsfreeChannelInfo = this.sensor.getSensorInfo().getChannelInfos()[0];
                this.sensor.getChannel(this.handsfreeChannelInfo).addCondition((ConditionListener)this, (Condition)new LimitCondition(0.0, "gt"));
                this.key_lock_value = 0;
            }
            System.out.println("Sensor opened!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Failed to open sensor!");
            return false;
        }
        return true;
    }

    public MySensorDataListener getDataListener() {
        return this.dataListener;
    }

    public void setDataListener(MySensorDataListener listener) {
        this.dataListener = listener;
    }

    public void release() {
        try {
            this.sensor.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getType() {
        return this.type;
    }

    public int[][][] getChannelRanges() {
        return this.channelRanges;
    }

    private boolean findDeviceInfo() {
        if (this.type == 0) {
            SensorInfo[] si = SensorManager.findSensors((String)"acceleration", (String)"user");
            SensorInfo s = si[0];
            this.URL = s.getUrl();
            ChannelInfo[] cInfos = s.getChannelInfos();
            if (cInfos.length != 3) {
                System.out.println("A accelerometer should support 3 channels but reports " + cInfos.length);
                return false;
            }
            this.channelRanges = new int[cInfos.length][][];
            int r = 0;
            while (r < cInfos.length) {
                ChannelInfo c = cInfos[r];
                this.channelNames[r] = c.getName();
                System.out.println(" getName: " + this.channelNames[r]);
                int type = c.getDataType();
                switch (type) {
                    case 2: {
                        System.out.println(" Data type: TYPE_INT");
                        break;
                    }
                    case 1: {
                        System.out.println(" Data type: TYPE_DOUBLE, Should be TYPE_INT");
                        return false;
                    }
                    case 4: {
                        System.out.println(" Data type: TYPE_OBJECT, Should be TYPE_INT");
                        return false;
                    }
                }
                MeasurementRange[] ranges = c.getMeasurementRanges();
                this.channelRanges[r] = new int[ranges.length][];
                int p = 0;
                while (p < ranges.length) {
                    MeasurementRange m = ranges[p];
                    this.channelRanges[r][p] = new int[3];
                    this.channelRanges[r][p][0] = (int)m.getSmallestValue();
                    this.channelRanges[r][p][1] = (int)m.getLargestValue();
                    this.channelRanges[r][p][2] = (int)m.getResolution();
                    ++p;
                }
                ++r;
            }
        } else if (this.type == 1) {
            SensorInfo[] si = SensorManager.findSensors((String)"battery_charge", (String)"device");
            SensorInfo s = si[0];
            this.URL = s.getUrl();
        } else if (this.type == 2) {
            SensorInfo[] si = SensorManager.findSensors((String)"network_field_intensity", (String)"device");
            SensorInfo s = si[0];
            this.URL = s.getUrl();
        } else if (this.type == 3) {
            SensorInfo[] si = SensorManager.findSensors((String)"com.sonyericsson.io.sensor.keylock_changed", (String)"user");
            SensorInfo s = si[0];
            this.URL = s.getUrl();
        }
        return true;
    }

    public void conditionMet(SensorConnection sensor, Data data, Condition condition) {
        this.key_lock_value = -15;
        if (data.getChannelInfo().equals(this.handsfreeChannelInfo)) {
            if (data.getIntValues()[0] == 0) {
                sensor.getChannel(this.handsfreeChannelInfo).addCondition((ConditionListener)this, (Condition)new LimitCondition((double)data.getIntValues()[0], "gt"));
            } else {
                sensor.getChannel(this.handsfreeChannelInfo).addCondition((ConditionListener)this, (Condition)new LimitCondition((double)data.getIntValues()[0], "lt"));
            }
        }
        this.key_lock_value = data.getIntValues()[data.getIntValues().length - 1];
        if (this.key_lock_value == 1) {
            this.key_lock_value_old = 1;
        }
        if (this.key_lock_value == 0) {
            this.keylock_time = System.currentTimeMillis();
        }
    }

    public void dataReceived(SensorConnection sensorConnection, Data[] data, boolean isDataLost) {
        int i;
        if (this.type == 0) {
            i = 0;
            while (i < data.length) {
                if (data[i].getChannelInfo().getName().compareTo(this.channelNames[0]) == 0) {
                    this.channels[0] = data[i].getIntValues()[0];
                } else if (data[i].getChannelInfo().getName().compareTo(this.channelNames[1]) == 0) {
                    this.channels[1] = data[i].getIntValues()[0];
                } else if (data[i].getChannelInfo().getName().compareTo(this.channelNames[2]) == 0) {
                    this.channels[2] = data[i].getIntValues()[0];
                }
                ++i;
            }
        }
        if (this.type == 1) {
            i = 0;
            while (i < data.length) {
                if (data[i].getChannelInfo().getName().equals("battery_charge")) {
                    this.channels[0] = data[i].getIntValues()[0];
                }
                ++i;
            }
        }
        if (this.type == 2) {
            i = 0;
            while (i < data.length) {
                if (data[i].getChannelInfo().getName().equals("network_field_intensity")) {
                    this.channels[0] = data[i].getIntValues()[0];
                }
                ++i;
            }
        }
        this.dataListener.dataReceived(this, this.channels, isDataLost);
    }

    public static String getAllSensorInfo() {
        String info = "";
        SensorInfo[] si = SensorManager.findSensors(null, null);
        int i = 0;
        while (i < si.length) {
            SensorInfo s = si[i];
            info = String.valueOf(info) + "------ sensor : " + i + "-------" + "\n";
            info = String.valueOf(info) + "getDescription: " + s.getDescription() + "\n";
            info = String.valueOf(info) + "isAvailable: " + s.isAvailable() + "\n";
            info = String.valueOf(info) + "isAvailabilityPushSupported: " + s.isAvailabilityPushSupported() + "\n";
            info = String.valueOf(info) + "isConditionPushSupported: " + s.isConditionPushSupported() + "\n";
            info = String.valueOf(info) + "getConnectionType: " + s.getConnectionType() + "\n";
            info = String.valueOf(info) + "getContextType: " + s.getContextType() + "\n";
            info = String.valueOf(info) + "getMaxBufferSize: " + s.getMaxBufferSize() + "\n";
            info = String.valueOf(info) + "getModel: " + s.getModel() + "\n";
            info = String.valueOf(info) + "getQuantity: " + s.getQuantity() + "\n";
            info = String.valueOf(info) + "getUrl: " + s.getUrl() + "\n";
            info = String.valueOf(info) + "Properties:\n";
            String[] propNames = s.getPropertyNames();
            int r = 0;
            while (r < propNames.length) {
                info = String.valueOf(info) + " " + propNames[r] + ": " + s.getProperty(propNames[r]) + "\n";
                ++r;
            }
            ChannelInfo[] cInfos = s.getChannelInfos();
            info = String.valueOf(info) + "Channels:\n";
            int r2 = 0;
            while (r2 < cInfos.length) {
                ChannelInfo c = cInfos[r2];
                info = String.valueOf(info) + " getName: " + c.getName() + "\n";
                int type = c.getDataType();
                switch (type) {
                    case 2: {
                        info = String.valueOf(info) + " Data type: TYPE_INT\n";
                        break;
                    }
                    case 1: {
                        info = String.valueOf(info) + " Data type: TYPE_DOUBLE\n";
                        break;
                    }
                    case 4: {
                        info = String.valueOf(info) + " Data type: TYPE_OBJECT\n";
                    }
                }
                info = String.valueOf(info) + " getScale: " + c.getScale() + "\n";
                info = String.valueOf(info) + " getUnit: " + c.getUnit().toString() + "\n";
                info = String.valueOf(info) + " getAccuracy: " + c.getAccuracy() + "\n";
                MeasurementRange[] ranges = c.getMeasurementRanges();
                info = String.valueOf(info) + " Measurement range:\n";
                int p = 0;
                while (p < ranges.length) {
                    MeasurementRange m = ranges[p];
                    info = String.valueOf(info) + "    getSmallestValue:" + m.getSmallestValue() + "\n";
                    info = String.valueOf(info) + "    getLargestValue: " + m.getLargestValue() + "\n";
                    info = String.valueOf(info) + "    getResolution: " + m.getResolution() + "\n";
                    ++p;
                }
                ++r2;
            }
            ++i;
        }
        return info;
    }

    public static interface MySensorDataListener {
        public void dataReceived(MySensor var1, int[] var2, boolean var3);
    }
}

