/*
 * Decompiled with CFR 0.152.
 */
package com.mbounce.avatar.tools;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer {
    public static String[] MUSIC_FORMAT = new String[]{".mp3", ".aac", ".mp4", ".amr", ".wav", ".m4a", ".mid"};
    public static String[] MUSIC_TYPE = new String[]{"audio/mpeg", ".aac", "audio/mp4", ".amr", "audio/x-wav", ".m4a", "audio/midi"};
    private Player player = null;
    public static final String RES_PATH = "/com/mbounce/avatar/res/";
    public String musicName = null;
    public boolean isPlaying = false;
    private boolean isPlay = false;

    public void init(String fileName) {
        if (this.player != null) {
            return;
        }
        String type = null;
        int i = 0;
        while (i < MUSIC_FORMAT.length) {
            if (fileName.endsWith(MUSIC_FORMAT[i])) {
                type = MUSIC_TYPE[i];
                break;
            }
            ++i;
        }
        try {
            InputStream is = fileName.getClass().getResourceAsStream(RES_PATH + fileName);
            DataInputStream dis = new DataInputStream(is);
            this.player = Manager.createPlayer((InputStream)dis, (String)type);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.player = null;
        }
    }

    public void play(String fileName) {
        this.init(fileName);
        try {
            if (this.player != null && !this.isPlaying) {
                this.player.realize();
                this.player.prefetch();
                VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
                vc.setLevel(100);
                this.player.start();
                this.isPlaying = true;
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void release() {
        if (this.player != null) {
            try {
                this.player.stop();
                this.player.deallocate();
                this.player.close();
                this.player = null;
                this.isPlaying = false;
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }
}

