/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.VolumeControl;

public class PlayerInterface
implements PlayerListener {
    private static final int MAX_ARTISTS = 1000;
    private static final int MAX_ALBUMS = 1000;
    private static final int MAX_TRACKS = 1000;
    private static final int MAX_ARTIST_ALBUMS = 50;
    private static final int MAX_ALBUM_TRACKS = 50;
    private Player player;
    private boolean isPlaylistInitialised = false;
    private boolean isTrackSleeping;
    private boolean isTrackPlaying = false;
    private int initialTrackCount = 0;
    private boolean isTrackCountComplete = false;
    int trackCount;
    String[][] trackInfo;
    private String[] currentTrackData;
    private boolean isTrackValid;
    private String[] artists;
    private int artistCount;
    private String[] albums;
    private int albumCount;
    private int[][] artistAlbums;
    private int[] artistAlbumsCount;
    private int[][] albumTracks;
    private int[] albumTracksCount;
    private int[][] artistTracks;
    private int[] artistTracksCount;
    private String[] trackNames;
    private String[] trackUrls;
    private String[] playlist;
    private PlayerListener normalPlaybackPlayerListener = new NormalPlaybackPlayerListener(this);
    private int currentTrack;
    private String currentUrl;
    String[] originalArtists;
    String[] originalAlbums;
    String[] originalTrackNames;
    String[] originalTrackUrls;

    public void collectTrackCount() {
        this.collectInFileSystem();
        this.isTrackCountComplete = true;
    }

    public void collectTracks() {
        int maxTracks = 1000;
        this.trackCount = 0;
        if (this.trackInfo == null) {
            this.trackInfo = new String[maxTracks][];
        }
        this.artists = new String[1000];
        this.artistCount = 0;
        this.albums = new String[1000];
        this.albumCount = 0;
        this.artistAlbums = new int[1000][];
        this.artistAlbumsCount = new int[1000];
        this.albumTracks = new int[1000][];
        this.albumTracksCount = new int[1000];
        this.artistTracks = new int[1000][];
        this.artistTracksCount = new int[1000];
        this.trackNames = new String[1000];
        this.trackUrls = new String[1000];
        this.collectInFileSystem();
        this.backupDataPoints();
        this.sortArrays();
        this.adjustPointers();
        this.removeBackups();
    }

    private void backupDataPoints() {
        this.originalArtists = this.backupArray(this.artists, this.artistCount);
        this.originalAlbums = this.backupArray(this.albums, this.albumCount);
        this.originalTrackNames = this.backupArray(this.trackNames, this.trackCount);
        this.originalTrackUrls = this.backupArray(this.trackUrls, this.trackCount);
    }

    private void removeBackups() {
        this.originalTrackUrls = null;
        this.originalTrackNames = null;
        this.originalAlbums = null;
        this.originalArtists = null;
    }

    private String[] backupArray(String[] a, int size) {
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = a[i];
            ++i;
        }
        return result;
    }

    private void sortArrays() {
        this.sort(this.artists, this.artistCount);
        this.sort(this.albums, this.albumCount);
        this.sort(this.trackNames, this.trackCount);
    }

    private void adjustPointers() {
        int[] newAlbumIndexes = this.buildCorrespondence(this.originalAlbums, this.albums, this.albumCount);
        int[] newArtistIndexes = this.buildCorrespondence(this.originalArtists, this.artists, this.artistCount);
        int[] newTrackIndexes = this.buildCorrespondence(this.originalTrackNames, this.trackNames, this.trackCount);
        int[][] newArtistAlbums = new int[this.artistCount][];
        int[] newArtistAlbumsCount = new int[this.artistCount];
        int i = 0;
        while (i < this.artistCount) {
            newArtistAlbums[newArtistIndexes[i]] = this.artistAlbums[i];
            newArtistAlbumsCount[newArtistIndexes[i]] = this.artistAlbumsCount[i];
            ++i;
        }
        this.artistAlbums = newArtistAlbums;
        this.artistAlbumsCount = newArtistAlbumsCount;
        i = 0;
        while (i < this.artistCount) {
            int j = 0;
            while (j < this.artistAlbumsCount[i]) {
                this.artistAlbums[i][j] = newAlbumIndexes[this.artistAlbums[i][j]];
                ++j;
            }
            this.quickSort(this.artistAlbums[i], 0, this.artistAlbumsCount[i] - 1);
            ++i;
        }
        int[][] newAlbumTracks = new int[this.albumCount][];
        int[] newAlbumTracksCount = new int[this.albumCount];
        int i2 = 0;
        while (i2 < this.albumCount) {
            newAlbumTracks[newAlbumIndexes[i2]] = this.albumTracks[i2];
            newAlbumTracksCount[newAlbumIndexes[i2]] = this.albumTracksCount[i2];
            ++i2;
        }
        this.albumTracks = newAlbumTracks;
        this.albumTracksCount = newAlbumTracksCount;
        i2 = 0;
        while (i2 < this.albumCount) {
            int j = 0;
            while (j < this.albumTracksCount[i2]) {
                this.albumTracks[i2][j] = newTrackIndexes[this.albumTracks[i2][j]];
                ++j;
            }
            this.quickSort(this.albumTracks[i2], 0, this.albumTracksCount[i2] - 1);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.trackCount) {
            this.trackUrls[newTrackIndexes[i2]] = this.originalTrackUrls[i2];
            ++i2;
        }
    }

    private int[] buildCorrespondence(String[] original, String[] sorted, int size) {
        int[] result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = this.indexOfStringInSortedArray(original[i], sorted, size);
            ++i;
        }
        return result;
    }

    private int indexOfStringInSortedArray(String s, String[] array, int size) {
        return this.binarySearch(s, array, 0, size - 1);
    }

    private int binarySearch(String s, String[] a, int l, int r) {
        if (l >= r) {
            if (s.equals(a[l])) {
                return l;
            }
            return -1;
        }
        int m = (l + r) / 2;
        int cmp = s.compareTo(a[m]);
        if (cmp == 0) {
            return m;
        }
        if (cmp < 0) {
            return this.binarySearch(s, a, l, m - 1);
        }
        if (cmp > 0) {
            return this.binarySearch(s, a, l + 1, r);
        }
        return -1;
    }

    private void sort(String[] a, int size) {
        this.quickSort(a, 0, size - 1);
    }

    private void collectInFileSystem() {
        Enumeration roots = FileSystemRegistry.listRoots();
        while (roots.hasMoreElements()) {
            String root = (String)roots.nextElement();
            String[] soundsDirs = new String[]{"music/", "sounds/"};
            int i = 0;
            while (i < soundsDirs.length) {
                String dirName = "file:///" + root + soundsDirs[i];
                this.collectChildFiles(dirName);
                ++i;
            }
        }
    }

    private void collectChildFiles(String dirUrl) {
        try {
            FileConnection dir = (FileConnection)Connector.open((String)dirUrl);
            if (!dir.exists()) {
                return;
            }
            Enumeration children = dir.list();
            while (children.hasMoreElements()) {
                String childName = (String)children.nextElement();
                String childUrl = String.valueOf(dirUrl) + childName;
                if (childName.endsWith("/")) {
                    this.collectChildFiles(childUrl);
                    continue;
                }
                if (!childName.endsWith(".mp3")) continue;
                this.collectTrack(childUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void collectTrack(String url) {
        if (this.isTrackCountComplete) {
            this.getMetaDataForMp3File(url);
            if (this.isTrackValid) {
                this.addCurrentTrackDataToStructures();
            } else {
                --this.initialTrackCount;
            }
        } else {
            ++this.initialTrackCount;
        }
    }

    private void addCurrentTrackDataToStructures() {
        int trackIndex = this.addTrack(this.currentTrackData[0], this.currentTrackData[1]);
        this.trackInfo[trackIndex] = this.currentTrackData;
        int artistIndex = this.addArtist(this.currentTrackData[3]);
        int albumIndex = this.addAlbum(this.currentTrackData[2]);
        this.addArtistsAlbum(artistIndex, albumIndex);
        this.addAlbumsTrack(albumIndex, trackIndex);
    }

    private int indexOf(String[] array, int length, String element) {
        int i = 0;
        while (i < length) {
            if (array[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(int[] array, int length, int element) {
        int i = 0;
        while (i < length) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int addStringToArrayEnd(String s, String[] a, int size, boolean duplicate) {
        int index;
        if (duplicate && (index = this.indexOf(a, size, s)) != -1) {
            return -1;
        }
        this.insertAtIndex(size, s, a, size);
        return size;
    }

    private void insertAtIndex(int index, String s, String[] a, int size) {
        int i = size;
        while (i > index) {
            a[i] = a[i - 1];
            --i;
        }
        a[index] = s;
    }

    private int addArtist(String name) {
        int index = this.addStringToArrayEnd(name, this.artists, this.artistCount, true);
        if (index != -1) {
            ++this.artistCount;
        }
        return this.indexOf(this.artists, this.artistCount, name);
    }

    private int addAlbum(String name) {
        int index = this.addStringToArrayEnd(name, this.albums, this.albumCount, true);
        if (index != -1) {
            ++this.albumCount;
        }
        return this.indexOf(this.albums, this.albumCount, name);
    }

    private int addTrack(String url, String name) {
        int index = this.addStringToArrayEnd(name, this.trackNames, this.trackCount, false);
        this.insertAtIndex(index, url, this.trackUrls, this.trackCount);
        ++this.trackCount;
        return this.indexOf(this.trackNames, this.trackCount, name);
    }

    private void addArtistsAlbum(int artistIndex, int albumIndex) {
        int[] hisAlbums;
        if (this.artistAlbums[artistIndex] == null) {
            this.artistAlbums[artistIndex] = new int[50];
            this.artistAlbumsCount[artistIndex] = 0;
        }
        if (this.indexOf(hisAlbums = this.artistAlbums[artistIndex], this.artistAlbumsCount[artistIndex], albumIndex) == -1) {
            hisAlbums[this.artistAlbumsCount[artistIndex]] = albumIndex;
            int n = artistIndex;
            this.artistAlbumsCount[n] = this.artistAlbumsCount[n] + 1;
        }
    }

    private void addAlbumsTrack(int albumIndex, int trackIndex) {
        int[] itsTracks;
        if (this.albumTracks[albumIndex] == null) {
            this.albumTracks[albumIndex] = new int[50];
            this.albumTracksCount[albumIndex] = 0;
        }
        if (this.indexOf(itsTracks = this.albumTracks[albumIndex], this.albumTracksCount[albumIndex], trackIndex) == -1) {
            itsTracks[this.albumTracksCount[albumIndex]] = trackIndex;
            int n = albumIndex;
            this.albumTracksCount[n] = this.albumTracksCount[n] + 1;
        }
    }

    private void initCurrentTrackData(String url) {
        int lastFolderSymbolIndex = url.lastIndexOf(47) + 1;
        this.currentTrackData = new String[4];
        this.currentTrackData[0] = url;
        this.currentTrackData[1] = Theme.removeFirstChars(url, lastFolderSymbolIndex);
        this.currentTrackData[2] = "unknown";
        this.currentTrackData[3] = "unknown";
    }

    private void getMetaDataForMp3File(String url) {
        this.initCurrentTrackData(url);
        try {
            Player p = Manager.createPlayer((String)url);
            p.addPlayerListener((PlayerListener)this);
            p.realize();
            MetaDataControl mc = (MetaDataControl)p.getControl("MetaDataControl");
            if (mc == null) {
                this.currentTrackData[0] = "cannot get metadata";
                this.isTrackValid = false;
                return;
            }
            String[] keys = mc.getKeys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = mc.getKeyValue(key).trim();
                if (key.equals("title")) {
                    if (!value.equals("")) {
                        this.currentTrackData[1] = value;
                    }
                } else if (key.equals("album")) {
                    if (!value.equals("")) {
                        this.currentTrackData[2] = value;
                    }
                } else if ((key.equals("artist") || key.equals("author")) && this.currentTrackData[3].equals("unknown") && !value.equals("")) {
                    this.currentTrackData[3] = value;
                }
                ++i;
            }
            this.isTrackValid = true;
            p.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.isTrackValid = false;
            return;
        }
        catch (MediaException e) {
            e.printStackTrace();
            this.isTrackValid = false;
            return;
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("started")) {
            MetaDataControl mc;
            VolumeControl vc = (VolumeControl)player.getControl("VolumeControl");
            if (vc != null) {
                vc.setMute(true);
            }
            if ((mc = (MetaDataControl)player.getControl("MetaDataControl")) == null) {
                this.currentTrackData[0] = "cannot get metadata";
                return;
            }
            String[] keys = mc.getKeys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = mc.getKeyValue(key).trim();
                if (key.equals("title")) {
                    if (!value.equals("")) {
                        this.currentTrackData[1] = value;
                    }
                } else if (key.equals("album")) {
                    if (!value.equals("")) {
                        this.currentTrackData[2] = value;
                    }
                } else if ((key.equals("artist") || key.equals("author")) && this.currentTrackData[3].equals("unknown") && !value.equals("")) {
                    this.currentTrackData[3] = value;
                }
                ++i;
            }
            try {
                player.stop();
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    public String playTrack(int number) {
        if (this.playlist == null || this.playlist.length <= number) {
            return "Number is wrong";
        }
        this.currentUrl = null;
        this.currentTrack = number;
        return this.startPlaying();
    }

    public String playURL(String url) {
        this.currentUrl = url;
        return this.startPlaying();
    }

    private String getUrlForPlaying() {
        if (this.isPlayingUrl()) {
            return this.currentUrl;
        }
        return this.playlist[this.currentTrack];
    }

    private String startPlaying() {
        try {
            String url;
            if (this.player != null) {
                this.player.deallocate();
            }
            if ((url = this.getUrlForPlaying()).endsWith(".mid")) {
                InputStream is = this.getClass().getResourceAsStream(url);
                this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            } else {
                this.player = Manager.createPlayer((String)url);
            }
            this.player.addPlayerListener(this.normalPlaybackPlayerListener);
            this.player.realize();
            this.player.prefetch();
            this.player.start();
            this.isPlaylistInitialised = true;
            this.isTrackPlaying = true;
        }
        catch (IOException e) {
            return "Cannot read file " + this.playlist[this.currentTrack] + " : " + e.toString();
        }
        catch (MediaException e) {
            return "Cannot play " + this.playlist[this.currentTrack] + " : " + e.toString();
        }
        catch (OutOfMemoryError e) {
            return e.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
        return "";
    }

    public String[] getInfo(String url) {
        this.getMetaDataForMp3File(url);
        return this.currentTrackData;
    }

    public String stop() {
        try {
            this.player.stop();
            this.player.setMediaTime(0L);
            this.isPlaylistInitialised = false;
            this.isTrackPlaying = false;
        }
        catch (MediaException e) {
            e.printStackTrace();
            return "Cannot stop";
        }
        return "";
    }

    public String pause() {
        try {
            if (this.isPlaying()) {
                this.player.stop();
                this.isTrackPlaying = false;
            } else {
                this.player.start();
                this.isTrackPlaying = true;
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
            return "Cannot pause";
        }
        return "";
    }

    private boolean isPlaying() {
        return this.player.getState() == 400;
    }

    public boolean getIsPlaylistInitialised() {
        return this.isPlaylistInitialised;
    }

    public boolean getIsTrackPlaying() {
        return this.isTrackPlaying;
    }

    public String getArtists() {
        return this.getArtists(0, this.artistCount);
    }

    public String getArtists(int startIndex, int count) {
        int n = Math.min(this.artistCount - startIndex, count);
        String[] returnedArtists = new String[n];
        int i = 0;
        while (i < n) {
            returnedArtists[i] = this.artists[i + startIndex];
            ++i;
        }
        this.quickSort(returnedArtists, 0, n - 1);
        return this.toReturnedList(returnedArtists);
    }

    private String toReturnedList(String[] a) {
        int maxLength = 10000;
        StringBuffer result = new StringBuffer(maxLength);
        int i = 0;
        while (i < a.length) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(a[i]);
            ++i;
        }
        return result.toString();
    }

    public int getArtistCount() {
        return this.artistCount;
    }

    public String getAlbums() {
        return this.getAlbums(0, this.albumCount);
    }

    public String getAlbums(String artist) {
        int artistIndex = this.getArtistIndex(artist);
        if (artistIndex == -1) {
            return this.getAlbums();
        }
        return this.getAlbums(artist, 0, this.artistAlbumsCount[artistIndex]);
    }

    public String getAlbums(int startIndex, int count) {
        int n = Math.min(this.albumCount - startIndex, count);
        String[] returned = new String[n];
        int i = 0;
        while (i < n) {
            returned[i] = this.albums[i + startIndex];
            ++i;
        }
        this.quickSort(returned, 0, n - 1);
        return this.toReturnedList(returned);
    }

    public String getAlbums(String artist, int startIndex, int count) {
        int artistIndex = this.getArtistIndex(artist);
        if (artistIndex == -1) {
            return this.getAlbums();
        }
        int n = Math.min(this.artistAlbumsCount[artistIndex] - startIndex, count);
        String[] returned = new String[n];
        int i = 0;
        while (i < n) {
            returned[i] = this.albums[this.artistAlbums[artistIndex][i + startIndex]];
            ++i;
        }
        this.quickSort(returned, 0, n - 1);
        return this.toReturnedList(returned);
    }

    public int getAlbumCount() {
        return this.albumCount;
    }

    public int getAlbumCount(String artist) {
        int artistIndex = this.getArtistIndex(artist);
        if (artistIndex == -1) {
            return 0;
        }
        return this.artistAlbumsCount[artistIndex];
    }

    private int getArtistIndex(String artist) {
        return this.indexOf(this.artists, this.artistCount, artist);
    }

    private int getAlbumIndex(String album) {
        return this.indexOf(this.albums, this.albumCount, album);
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public String getTracks() {
        return this.getTracks(0, this.trackCount);
    }

    public String getTracks(int startIndex, int count) {
        int n = Math.min(this.trackCount - startIndex, count);
        String[] returned = new String[n];
        this.playlist = new String[n];
        int i = 0;
        while (i < n) {
            returned[i] = this.trackNames[i + startIndex];
            this.playlist[i] = this.trackUrls[i + startIndex];
            ++i;
        }
        this.sortArrayAndPlaylist(returned, n);
        String returnedList = this.toReturnedList(returned);
        return returnedList;
    }

    public String getTracksByAlbum(String album) {
        return this.getTracksByAlbum(album, 0, 1000);
    }

    public String getTracksByAlbum(String album, int startIndex, int count) {
        int albumIndex = this.getAlbumIndex(album);
        if (albumIndex == -1) {
            return this.getTracks();
        }
        int n = Math.min(this.albumTracksCount[albumIndex] - startIndex, count);
        String[] returned = new String[n];
        this.playlist = new String[n];
        int i = 0;
        while (i < n) {
            returned[i] = this.trackNames[this.albumTracks[albumIndex][i + startIndex]];
            this.playlist[i] = this.trackUrls[this.albumTracks[albumIndex][i + startIndex]];
            ++i;
        }
        this.sortArrayAndPlaylist(returned, n);
        return this.toReturnedList(returned);
    }

    public String getTracksByArtist(String artist) {
        return this.getTracksByArtist(artist, 0, 1000);
    }

    public String getTracksByArtist(String artist, int startIndex, int count) {
        int artistIndex = this.getArtistIndex(artist);
        if (artistIndex == -1) {
            return this.getTracks();
        }
        int n = Math.min(this.artistTracksCount[artistIndex] - startIndex, count);
        String[] returned = new String[n];
        this.playlist = new String[n];
        int i = 0;
        while (i < n) {
            returned[i] = this.trackNames[this.artistTracks[artistIndex][i + startIndex]];
            this.playlist[i] = this.trackUrls[this.artistTracks[artistIndex][i + startIndex]];
            ++i;
        }
        this.sortArrayAndPlaylist(returned, n);
        return this.toReturnedList(returned);
    }

    private void sortArrayAndPlaylist(String[] first, int n) {
        this.quickSortWithCustomSwap(first, 0, n - 1);
    }

    public int getPlaylistLength() {
        return this.playlist.length;
    }

    public String getPlaylistUrls() {
        return this.toReturnedList(this.playlist);
    }

    public boolean getIsTrackCountComplete() {
        return this.isTrackCountComplete;
    }

    public int getInitialTrackCount() {
        return this.initialTrackCount;
    }

    public void playNextTrack() {
        this.player.deallocate();
        if (this.isPlayingUrl()) {
            this.startPlaying();
        } else {
            ++this.currentTrack;
            if (this.currentTrack < this.playlist.length) {
                this.startPlaying();
            } else {
                this.isPlaylistInitialised = false;
            }
        }
    }

    private boolean isPlayingUrl() {
        return this.currentUrl != null;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(String[] v, int l, int r) {
        if (l >= r) {
            return;
        }
        l1 = l;
        r1 = r;
        m = (r + l) / 2;
        ** GOTO lbl21
        {
            ++l;
            do {
                if (this.isRightOrder(v[l], v[m]) && l < m) continue block0;
                while (r > m && this.isRightOrder(v[m], v[r])) {
                    --r;
                }
                tmp = v[l];
                v[l] = v[r];
                v[r] = tmp;
                if (l == m) {
                    m = r;
                    continue;
                }
                if (r != m) continue;
                m = l;
lbl21:
                // 4 sources

            } while (l < r);
        }
        this.quickSort(v, l1, m - 1);
        this.quickSort(v, m + 1, r1);
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(int[] v, int l, int r) {
        if (l >= r) {
            return;
        }
        l1 = l;
        r1 = r;
        m = (r + l) / 2;
        ** GOTO lbl21
        {
            ++l;
            do {
                if (this.isRightOrder(v[l], v[m]) && l < m) continue block0;
                while (r > m && this.isRightOrder(v[m], v[r])) {
                    --r;
                }
                tmp = v[l];
                v[l] = v[r];
                v[r] = tmp;
                if (l == m) {
                    m = r;
                    continue;
                }
                if (r != m) continue;
                m = l;
lbl21:
                // 4 sources

            } while (l < r);
        }
        this.quickSort(v, l1, m - 1);
        this.quickSort(v, m + 1, r1);
    }

    private boolean isRightOrder(String s1, String s2) {
        return s1.compareTo(s2) <= 0;
    }

    private boolean isRightOrder(int a, int b) {
        return a < b;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSortWithCustomSwap(String[] v, int l, int r) {
        if (l >= r) {
            return;
        }
        l1 = l;
        r1 = r;
        m = (r + l) / 2;
        ** GOTO lbl22
        {
            ++l;
            do {
                if (this.isRightOrder(v[l], v[m]) && l < m) continue block0;
                while (r > m && this.isRightOrder(v[m], v[r])) {
                    --r;
                }
                tmp = v[l];
                v[l] = v[r];
                v[r] = tmp;
                this.customSwap(l, r);
                if (l == m) {
                    m = r;
                    continue;
                }
                if (r != m) continue;
                m = l;
lbl22:
                // 4 sources

            } while (l < r);
        }
        this.quickSortWithCustomSwap(v, l1, m - 1);
        this.quickSortWithCustomSwap(v, m + 1, r1);
    }

    private void customSwap(int l, int r) {
        String tmp = this.playlist[l];
        this.playlist[l] = this.playlist[r];
        this.playlist[r] = tmp;
    }

    public void setTrackSleeping(boolean sleeping) {
        this.isTrackSleeping = sleeping;
    }

    public boolean getTrackSleeping() {
        return this.isTrackSleeping;
    }
}

