/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class Theme {
    private static final String BASE_QUADRAPOP_FOLDER = "file:///c:/other/quadrapop/";
    private static final String BASE_THEMES_FOLDER = "file:///c:/other/quadrapop/themes/";
    private static final String[] DEFAULT_THEMES = new String[]{"Quadrapop Creatures", "Entertainment Unlimited", "Space Hoppers"};
    private static String themesStr;
    private static int themeCounter;
    private static final int MAX_STRAY_THEMES = 1000;
    private static String[] strayThemes;
    private static int strayThemeCounter;
    private static String THEME_FILE_TYPE;

    static {
        THEME_FILE_TYPE = ".qth";
    }

    public static void initThemeCollection() {
        themesStr = "";
        themeCounter = 0;
        strayThemeCounter = 0;
        strayThemes = new String[1000];
    }

    public static void collectAllThemes() {
        Theme.initThemeCollection();
        Theme.collectInstalledThemes();
        Theme.collectStrayThemes();
        Theme.installStrayThemes();
    }

    private static void collectInstalledThemes() {
        try {
            FileConnection dir = (FileConnection)Connector.open((String)BASE_THEMES_FOLDER);
            if (!dir.exists()) {
                return;
            }
            Enumeration children = dir.list();
            while (children.hasMoreElements()) {
                String child = (String)children.nextElement();
                if (child.endsWith(THEME_FILE_TYPE)) {
                    String currentElement = Theme.removeLastChars(child, 4);
                    themesStr = String.valueOf(themesStr) + currentElement + "|";
                    ++themeCounter;
                    continue;
                }
                Theme.deleteFile(BASE_THEMES_FOLDER + child);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void collectStrayThemes() {
        Enumeration roots = FileSystemRegistry.listRoots();
        while (roots.hasMoreElements()) {
            String root = (String)roots.nextElement();
            String dirName = "file:///" + root;
            Theme.collectChildFiles(dirName);
        }
    }

    private static void collectChildFiles(String dirUrl) {
        if (!dirUrl.equals(BASE_QUADRAPOP_FOLDER)) {
            try {
                FileConnection dir = (FileConnection)Connector.open((String)dirUrl);
                if (!dir.exists()) {
                    return;
                }
                Enumeration children = dir.list();
                while (children.hasMoreElements()) {
                    String childName = (String)children.nextElement();
                    String childUrl = String.valueOf(dirUrl) + childName;
                    if (childName.endsWith("/")) {
                        Theme.collectChildFiles(childUrl);
                        continue;
                    }
                    if (!childName.endsWith(".qth")) continue;
                    Theme.strayThemes[Theme.strayThemeCounter] = String.valueOf(dirUrl) + childName;
                    ++strayThemeCounter;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static void installStrayThemes() {
        int i = 0;
        while (i < strayThemeCounter) {
            Theme.installTheme(strayThemes[i]);
            ++i;
        }
    }

    public static void checkThemeFolder() {
        block4: {
            try {
                FileConnection newDir = (FileConnection)Connector.open((String)BASE_QUADRAPOP_FOLDER);
                if (newDir.exists()) break block4;
                newDir.mkdir();
                try {
                    newDir = (FileConnection)Connector.open((String)BASE_THEMES_FOLDER);
                    newDir.mkdir();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static void installTheme(String url) {
        int lastFolderSymbolIndex = url.lastIndexOf(47) + 1;
        String themeName = Theme.removeLastChars(url, 4);
        themeName = Theme.removeFirstChars(themeName, lastFolderSymbolIndex);
        String newFileName = BASE_THEMES_FOLDER + themeName;
        try {
            FileConnection newFile = (FileConnection)Connector.open((String)(String.valueOf(newFileName) + THEME_FILE_TYPE));
            if (newFile.exists() || Theme.isThemeDefault(themeName)) {
                newFileName = Theme.validateFileExistence(newFileName, THEME_FILE_TYPE);
                lastFolderSymbolIndex = newFileName.lastIndexOf(47) + 1;
                themeName = Theme.removeFirstChars(newFileName, lastFolderSymbolIndex);
            }
            themesStr = String.valueOf(themesStr) + themeName + "|";
            ++themeCounter;
            Theme.copyFile(url, String.valueOf(newFileName) + THEME_FILE_TYPE);
            Theme.deleteFile(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isThemeDefault(String theme) {
        int i = 0;
        while (i < DEFAULT_THEMES.length) {
            if (theme.equals(DEFAULT_THEMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteInstalledTheme(String theme) {
        String filePath = BASE_THEMES_FOLDER + theme + THEME_FILE_TYPE;
        Theme.deleteFile(filePath);
    }

    public static boolean verifyTheme(String theme) {
        String themeFile = BASE_THEMES_FOLDER + theme + THEME_FILE_TYPE;
        try {
            FileConnection themeFiles = (FileConnection)Connector.open((String)themeFile);
            return themeFiles.exists();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void copyFile(String oldFile, String newFile) {
        try {
            int ch;
            FileConnection fci = (FileConnection)Connector.open((String)oldFile);
            FileConnection fco = (FileConnection)Connector.open((String)newFile);
            fco.create();
            InputStream is = fci.openInputStream();
            OutputStream os = fco.openOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void deleteFile(String filePath) {
        try {
            FileConnection file = (FileConnection)Connector.open((String)filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static String removeFirstChars(String a, int numChars) {
        int lastCharIndex = a.length();
        return a.substring(numChars, lastCharIndex);
    }

    public static String removeLastChars(String a, int numChars) {
        int lastCharIndex = a.length() - numChars;
        return a.substring(0, lastCharIndex);
    }

    public static String getThemes() {
        if (themesStr.equals("")) {
            return themesStr;
        }
        return Theme.removeLastChars(themesStr, 1);
    }

    public static int getNumThemes() {
        return themeCounter;
    }

    private static String validateFileExistence(String fileName, String fileType) {
        String validFile = "Error";
        try {
            FileConnection tempFco = (FileConnection)Connector.open((String)(String.valueOf(fileName) + fileType));
            boolean doesFileExist = true;
            int counter = 1;
            do {
                String copyIncrement = "(" + counter + ")";
                tempFco = (FileConnection)Connector.open((String)(String.valueOf(fileName) + copyIncrement + fileType));
                if (!tempFco.exists()) {
                    doesFileExist = false;
                    validFile = String.valueOf(fileName) + copyIncrement;
                }
                ++counter;
            } while (doesFileExist);
            return validFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return validFile;
        }
    }
}

