/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.httpfacebook.codec;

import com.sonyericsson.httpfacebook.util.StringCodec;

public final class AttributeCodec
implements StringCodec {
    private static StringCodec instance;
    private static final char[] chars;

    static {
        chars = new char[]{'?', '&', '=', ';', '%'};
    }

    private static boolean isReservedChar(char c) {
        int i = 0;
        while (i < chars.length) {
            if (c == chars[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static StringCodec getStringCodec() {
        if (instance == null) {
            instance = new AttributeCodec();
        }
        return instance;
    }

    public static String decodeAttribute(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '%') {
                try {
                    char parsedChar = (char)Byte.parseByte(string.substring(i + 1, i + 3), 16);
                    if (AttributeCodec.isReservedChar(parsedChar)) {
                        c = parsedChar;
                        i += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String encodeAttribute(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (AttributeCodec.isReservedChar(c)) {
                sb.append('%');
                sb.append(Integer.toHexString(c).toUpperCase());
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String decode(String s) {
        return AttributeCodec.decodeAttribute(s);
    }

    public String encode(String s) {
        return AttributeCodec.encodeAttribute(s);
    }
}

