/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.httpfacebook.service.transfer;

import com.sonyericsson.httpfacebook.http.HttpRequest;
import com.sonyericsson.httpfacebook.service.transfer.TransferRequestProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class TransferRequest
extends HttpRequest {
    public static final int DEFAULT_BUFSIZE = 1024;
    private int bufSize;
    protected TransferRequestProgressListener listener;
    protected boolean cancelled;
    protected int nrTransferredBytes;
    protected int progressInterval;
    private boolean completed;

    protected TransferRequest(String method, String url, Hashtable headers, int bufSize) {
        super(method, url, headers);
        this.bufSize = bufSize;
    }

    public void setTransferRequestProgressListener(TransferRequestProgressListener listener, int progressInterval) {
        this.listener = listener;
        this.progressInterval = progressInterval;
    }

    public void cancel() {
        if (!this.completed) {
            this.cancelled = true;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getNrTransferredBytes() {
        return this.nrTransferredBytes;
    }

    protected void copyStream(InputStream is, OutputStream os) throws IOException {
        int nrBytes = 0;
        byte[] bytes = new byte[this.bufSize];
        int nextProgressNotify = this.progressInterval;
        this.nrTransferredBytes = 0;
        while (!this.cancelled && (nrBytes = is.read(bytes)) > 0) {
            os.write(bytes, 0, nrBytes);
            this.nrTransferredBytes += nrBytes;
            if (this.listener == null || this.nrTransferredBytes < nextProgressNotify) continue;
            this.listener.requestProgressNotify();
            nextProgressNotify += this.progressInterval;
        }
        if (!this.cancelled) {
            this.completed = true;
        }
    }
}

