/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.ObjectFactory;
import com.sonyericsson.walkmate.controller.Controller;
import com.sonyericsson.walkmate.controller.ControllerListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class WalkmateApp
extends MIDlet
implements ControllerListener {
    public ObjectFactory objectFactory;
    private Controller controller;
    private boolean appIsRunning = false;

    public WalkmateApp() {
        String log = this.getAppProperty("SEMC-Walkmate-LogEnabled");
        Logger.setEnabled("Y".equalsIgnoreCase(log));
        Logger.printOut("[WALKMATE]: WalkmateApp - Constructor");
        this.objectFactory = new ObjectFactory(this);
        this.controller = this.objectFactory.getController();
        this.controller.setListener(this);
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        Logger.printOut("[WALKMATE]: WalkmateApp - destroyApp()");
        this.controller.stopController();
        this.notifyDestroyed();
    }

    protected void pauseApp() {
        Logger.printOut("[WALKMATE]: WalkmateApp - pauseApp()");
        this.notifyPaused();
    }

    protected void startApp() throws MIDletStateChangeException {
        Logger.printOut("[WALKMATE]: WalkmateApp - startApp");
        if (this.appIsRunning) {
            Logger.printOut("[WALKMATE]: WalkmateApp - startApp - appIsRunning");
            return;
        }
        this.appIsRunning = true;
        this.controller.startController();
    }

    public void controlEvent(int event) {
        Logger.printOut("[WALKMATE]: WalkmateApp - controlEvent");
        if (event == 0 || event == 1) {
            try {
                Logger.printOut("[WALKMATE]: WalkmateApp - destroyApp(true)");
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException e) {
                Logger.printOut("[WALKMATE]: WalkmateApp - controlEvent - Exception");
            }
        }
    }

    public void controlEvent(int event, boolean isActive) {
        Logger.printOut("[WALKMATE]: WalkmateApp - controlEvent - isActive: " + isActive);
        if (event == 1) {
            if (isActive) {
                try {
                    Logger.printOut("[WALKMATE]: WalkmateApp - destroyApp(true)");
                    this.destroyApp(true);
                }
                catch (MIDletStateChangeException e) {
                    Logger.printOut("[WALKMATE]: WalkmateApp - controlEvent - Exception");
                }
                this.notifyDestroyed();
            } else {
                Logger.printOut("[WALKMATE]: *** WalkmateApp - Exit - AS_WALLPAPER");
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.objectFactory.getView());
                Display.getDisplay((MIDlet)this).setCurrent(null);
                Display.getDisplay((MIDlet)this).setCurrent(null);
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.objectFactory.getView());
                Display.getDisplay((MIDlet)this).setCurrent(null);
                Display.getDisplay((MIDlet)this).setCurrent(null);
            }
        }
    }
}

