/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ConnectSetup
extends Canvas
implements CommandListener {
    private static final int ACTIVE_ALWAYS = 1;
    private static final int ACTIVE_YES = 2;
    private static final int ACTIVE_NO = 3;
    private static final String IMG_INFO = "/images/info_bkg.png";
    private int activeState = 1;
    private Command back = null;
    private Command selectConnect = null;
    private GuiListener listener;
    private Font messageFont;
    private String messageTxt;
    private Image infoBkg;
    private Display display;
    private int messageLength;
    private int messageWidth;
    private int linePosition;
    private int lineStart;
    private int line;

    public ConnectSetup(GuiListener listener, Display display) {
        this.listener = listener;
        this.display = display;
        this.setSoftKeys();
        this.setCommandListener(this);
        try {
            this.infoBkg = Image.createImage((String)IMG_INFO);
        }
        catch (Exception error) {
            Logger.printOut("[WALKMATE]: Couldn\u00b4t load the image: " + error.getMessage());
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintScreen(graphics);
    }

    public void setSoftKeys() {
        this.removeCommand(this.back);
        this.removeCommand(this.selectConnect);
        this.back = new Command(Translator.getMessage("WF_RSK_BACK_TXT"), 2, 1);
        this.selectConnect = new Command(Translator.getMessage("WF_MSK_SELECT_TXT"), 4, 2);
        this.addCommand(this.back);
        this.addCommand(this.selectConnect);
    }

    protected void showNotify() {
        super.showNotify();
        this.setSoftKeys();
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: {
                if (this.activeState == 1) {
                    this.activeState = 3;
                    break;
                }
                if (this.activeState == 3) {
                    this.activeState = 2;
                    break;
                }
                if (this.activeState != 2) break;
                this.activeState = 1;
                break;
            }
            case -2: {
                if (this.activeState == 3) {
                    this.activeState = 1;
                    break;
                }
                if (this.activeState == 2) {
                    this.activeState = 3;
                    break;
                }
                if (this.activeState != 1) break;
                this.activeState = 2;
                break;
            }
            default: {
                super.keyPressed(keyCode);
            }
        }
        this.repaint();
    }

    protected void paintScreen(Graphics graphics) {
        Font mFont = Font.getFont((int)64, (int)0, (int)8);
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.infoBkg, 0, 0, 20);
        graphics.setColor(0xFFFFFF);
        this.write(graphics, Translator.getMessage("WF_ACCES_INTERNET_TXT"), 18, 27, 207, mFont);
        mFont = Font.getFont((int)64, (int)1, (int)8);
        this.write(graphics, Translator.getMessage("WF_CONNECT_TXT"), 57, 140, 225, mFont);
        mFont = Font.getFont((int)64, (int)0, (int)8);
        graphics.setFont(mFont);
        graphics.drawLine(52, 165, 187, 165);
        graphics.drawString(Translator.getMessage("WF_INTERNET_YES_NEVER_ASK_TXT"), 25, 185, 20);
        graphics.drawString(Translator.getMessage("WF_INTERNET_YES_TXT"), 25, 205, 20);
        graphics.drawString(Translator.getMessage("WF_INTENERT_NO_TXT"), 25, 225, 20);
        if (this.activeState == 1) {
            graphics.setColor(3889560);
            graphics.fillRect(16, 182, 209, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Translator.getMessage("WF_INTERNET_YES_NEVER_ASK_TXT"), 25, 185, 20);
        } else if (this.activeState == 2) {
            graphics.setColor(3889560);
            graphics.fillRect(16, 202, 209, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Translator.getMessage("WF_INTERNET_YES_TXT"), 25, 205, 20);
        } else {
            graphics.setColor(3889560);
            graphics.fillRect(16, 222, 209, 20);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Translator.getMessage("WF_INTENERT_NO_TXT"), 25, 225, 20);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.back) {
            this.listener.controlViewEvent(15);
        } else if (command == this.selectConnect) {
            this.listener.controlViewEvent(5);
        }
    }

    public void setActiveState(int state) {
        this.activeState = state;
    }

    public int getActiveState() {
        return this.activeState;
    }

    public int write(Graphics g, String txt, int x, int y, int width, Font font) {
        this.messageFont = font;
        this.messageTxt = txt;
        this.messageLength = txt.length();
        this.messageWidth = width;
        this.linePosition = 0;
        this.lineStart = 0;
        int fontHight = this.messageFont.getHeight() + 1;
        g.setFont(this.messageFont);
        while (this.hasMoreLines()) {
            String firstPage = this.nextLine().trim();
            g.drawString(firstPage, x, y, 20);
            y += fontHight;
        }
        return y;
    }

    private boolean hasMoreLines() {
        ++this.line;
        return this.linePosition < this.messageLength - 1;
    }

    private String nextLine() {
        int maxLength = this.messageTxt.length();
        String s = null;
        int next = this.next();
        if (this.lineStart < maxLength && next <= maxLength) {
            s = this.messageTxt.substring(this.lineStart, next);
            this.lineStart = next;
            if (this.messageTxt.length() - 1 > this.lineStart && (this.messageTxt.charAt(this.lineStart) == '\n' || this.messageTxt.charAt(this.lineStart) == ' ')) {
                ++this.linePosition;
                ++this.lineStart;
            }
        }
        return s;
    }

    private int next() {
        int i = this.getNextWord(this.linePosition);
        int lastBreak = -1;
        String line = this.messageTxt.substring(this.linePosition, i);
        int lineWidth = this.messageFont.stringWidth(line);
        while (i < this.messageLength && lineWidth <= this.messageWidth) {
            if (this.messageTxt.charAt(i) == ' ') {
                lastBreak = i;
            } else if (this.messageTxt.charAt(i) == '\n') {
                lastBreak = i;
                break;
            }
            if (++i >= this.messageLength) continue;
            i = this.getNextWord(i);
            line = this.messageTxt.substring(this.linePosition, i);
            lineWidth = this.messageFont.stringWidth(line);
        }
        this.linePosition = i == this.messageLength && lineWidth <= this.messageWidth ? i : (lastBreak == this.linePosition ? ++this.linePosition : (lastBreak < this.linePosition ? i : lastBreak));
        return this.linePosition;
    }

    private int getNextWord(int startIndex) {
        int nextWord = 0;
        int space = this.messageTxt.indexOf(32, startIndex);
        int newLine = this.messageTxt.indexOf(10, startIndex);
        if (space == -1) {
            space = this.messageLength;
        }
        if (newLine == -1) {
            newLine = this.messageLength;
        }
        nextWord = space < newLine ? space : newLine;
        return nextWord;
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -9999 && !this.display.flashBacklight(0)) {
            this.listener.controlViewEvent(18);
        }
    }
}

