/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.FbInfoDatastore;
import com.sonyericsson.walkmate.utils.TextFormatUtils;
import com.sonyericsson.walkmate.utils.TimeOut;
import com.sonyericsson.walkmate.utils.TimerListener;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FbAlert
extends Canvas
implements Runnable,
CommandListener,
TimerListener {
    private static final int MAX_LINE_NUMBER = 10;
    private static final int MAX_LINE_NUMBER_USER_MSG = 5;
    private static final long STEP_INTERVAL = 500L;
    private static final String IMG_INFO = "/images/info_bkg.png";
    private static final String IMG_PUBLISHED = "/images/published_bkg.png";
    private static final String IMG_PROGRESS_BAR = "/images/progress_animated.png";
    private static final String IMG_PROGRESS_BKG = "/images/progress_background.png";
    private static final int progressBarX = 25;
    private static final int progressBarY = 170;
    private static final int progressBarW = 192;
    private static final int progressBarH = 16;
    private int imageSize;
    private int shift = 0;
    private int animationSteps = 3;
    private boolean lineSeparator;
    private boolean invalidUserPass;
    private boolean hasOkButton;
    private boolean warning;
    private boolean geonames;
    private boolean msgSavedLogin = false;
    private Command cmdCancel;
    private Command cmdOk;
    private Command ok;
    private Command exit;
    private Command okGeonames;
    private String msgUser;
    private String msg3;
    private String msgInfo;
    private Image infoBkg;
    private Image imgInfo;
    private Image imgProgressBkg;
    private Image imgPublished;
    private Image imageProgressBar;
    private Display display;
    private GuiListener eventListener;
    private TextFormatUtils textFormat = new TextFormatUtils();
    private Timer timerFbAlert;
    private TimeOut timeOut;

    public void run() {
        if (this.hasOkButton && !this.warning && !this.geonames) {
            this.cmdOk = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.addCommand(this.cmdOk);
        } else if (!(this.hasOkButton || this.warning || this.geonames)) {
            this.cmdCancel = new Command(Translator.getMessage("WF_RSK_CANCEL_TXT"), 4, 2);
            this.addCommand(this.cmdCancel);
        } else if (this.warning) {
            this.ok = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.exit = new Command(Translator.getMessage("JAVAAPPS_WM_EXIT_SK"), 7, 2);
            this.addCommand(this.ok);
            this.addCommand(this.exit);
        } else if (this.geonames) {
            this.okGeonames = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.addCommand(this.okGeonames);
        }
        this.setCommandListener(this);
        Logger.printOut("[WALKMATE]: FbAlert - run()");
    }

    public FbAlert(GuiListener eventListener, Display display, String msgInfo) {
        this.display = display;
        this.msgInfo = msgInfo;
        this.eventListener = eventListener;
        this.msgUser = null;
        this.msg3 = null;
        this.lineSeparator = false;
        this.msgSavedLogin = false;
        this.timerFbAlert = new Timer();
        try {
            this.imageProgressBar = Image.createImage((String)IMG_PROGRESS_BAR);
            this.imgInfo = Image.createImage((String)IMG_INFO);
            this.imgPublished = Image.createImage((String)IMG_PUBLISHED);
            this.imgProgressBkg = Image.createImage((String)IMG_PROGRESS_BKG);
        }
        catch (IOException error) {
            Logger.printOut("[WALKMATE]: FbAlert - Couldn\u00b4t load the image: " + error.getMessage());
        }
        new Thread(this).start();
    }

    public FbAlert(GuiListener eventListener, Display display, String msgInfo, boolean hasOkButton) {
        this.hasOkButton = hasOkButton;
        this.display = display;
        this.msgInfo = msgInfo;
        this.eventListener = eventListener;
        this.msgUser = null;
        this.msg3 = null;
        this.lineSeparator = false;
        this.msgSavedLogin = false;
        try {
            this.imgInfo = Image.createImage((String)IMG_INFO);
            this.imgProgressBkg = Image.createImage((String)IMG_PROGRESS_BKG);
            this.imgPublished = Image.createImage((String)IMG_PUBLISHED);
        }
        catch (IOException error) {
            Logger.printOut("[WALKMATE]: FbAlert - Couldn\u00b4t load the image: " + error.getMessage());
        }
        new Thread(this).start();
    }

    public FbAlert(GuiListener eventListener, Display display, String msgInfo, String msgUser, String msg3, boolean line, boolean invalidUserPass) {
        this.hasOkButton = true;
        this.display = display;
        this.msgInfo = msgInfo;
        this.msgUser = msgUser;
        this.msg3 = msg3;
        this.eventListener = eventListener;
        this.lineSeparator = line;
        this.invalidUserPass = invalidUserPass;
        this.msgSavedLogin = true;
        try {
            this.imgInfo = Image.createImage((String)IMG_INFO);
            this.imgProgressBkg = Image.createImage((String)IMG_PROGRESS_BKG);
            this.imgPublished = Image.createImage((String)IMG_PUBLISHED);
        }
        catch (IOException error) {
            Logger.printOut("[WALKMATE]: FbAlert - Couldn\u00b4t load the image: " + error.getMessage());
        }
        new Thread(this).start();
    }

    public FbAlert(String description, GuiListener eventListener, Display display) {
        this.eventListener = eventListener;
        this.warning = true;
        this.display = display;
        this.msgInfo = description;
        this.msgUser = null;
        this.msg3 = null;
        this.lineSeparator = false;
        this.msgSavedLogin = false;
        try {
            this.imgInfo = Image.createImage((String)IMG_INFO);
        }
        catch (IOException error) {
            Logger.printOut("[WALKMATE]: FbAlert - Couldn\u00b4t load the image: " + error.getMessage());
        }
        new Thread(this).start();
    }

    public FbAlert(String description, GuiListener eventListener, Display display, boolean geonames) {
        this.eventListener = eventListener;
        this.display = display;
        this.msgInfo = description;
        this.geonames = true;
        this.msgUser = null;
        this.msg3 = null;
        this.lineSeparator = false;
        this.msgSavedLogin = false;
        try {
            this.imgInfo = Image.createImage((String)IMG_INFO);
        }
        catch (IOException error) {
            Logger.printOut("[WALKMATE]: FbAlert - Couldn\u00b4t load the image: " + error.getMessage());
        }
        new Thread(this).start();
    }

    public void commandAction(Command command, Displayable displayable) {
        Logger.printOut("[WALKMATE]: commandAction - ");
        if (command == this.cmdCancel) {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - cmdCancel");
            this.stopProgressBar();
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - cmdCancel - sending CANCEL_OPERATION");
            this.eventListener.controlViewEvent(4);
        } else if (command == this.cmdOk) {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - cmdOk");
            this.stopProgressBar();
            if (this.msgInfo.equals(Translator.getMessage("WF_FACEBOOK_LOGIN_INFO1_TXT"))) {
                this.eventListener.controlViewEvent(14);
            } else if (this.msgInfo.equals(Translator.getMessage("WF_ERROR_INCORRECT_EMAIL_TITLE_HLP"))) {
                this.eventListener.controlViewEvent(17);
            } else {
                this.eventListener.controlViewEvent(13);
            }
        } else if (command == this.ok) {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - ok");
            FbInfoDatastore db = new FbInfoDatastore();
            db.setFBWallpaperInfo("FACEBOOK_WALLPAPER_DB");
            this.eventListener.controlViewEvent(24);
        } else if (command == this.exit) {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - exit");
            FbInfoDatastore db = new FbInfoDatastore();
            db.setFBWallpaperInfo("FACEBOOK_WALLPAPER_DB");
            this.eventListener.controlViewEvent(23);
        } else if (command == this.okGeonames) {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - okGeonames");
            FbInfoDatastore db = new FbInfoDatastore();
            db.setFBWallpaperInfo("FACEBOOK_GEONAME_DB");
            this.eventListener.controlViewEvent(25);
        } else {
            Logger.printOut("[WALKMATE]: FbAlert - commandAction - OTHERS?!?!?!?!");
        }
    }

    public void setSoftKeys() {
        if (this.hasOkButton && !this.warning && !this.geonames) {
            this.removeCommand(this.cmdOk);
            this.cmdOk = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.addCommand(this.cmdOk);
        } else if (!(this.hasOkButton || this.warning || this.geonames)) {
            this.removeCommand(this.cmdCancel);
            this.cmdCancel = new Command(Translator.getMessage("WF_RSK_CANCEL_TXT"), 4, 2);
            this.addCommand(this.cmdCancel);
        } else if (this.warning) {
            this.removeCommand(this.ok);
            this.removeCommand(this.exit);
            this.ok = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.exit = new Command(Translator.getMessage("JAVAAPPS_WM_EXIT_SK"), 7, 2);
            this.addCommand(this.ok);
            this.addCommand(this.exit);
        } else if (this.geonames) {
            this.removeCommand(this.okGeonames);
            this.okGeonames = new Command(Translator.getMessage("JAVAAPPS_WM_OK_SK"), 4, 2);
            this.addCommand(this.okGeonames);
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.setSoftKeys();
        Logger.printOut("[WALKMATE]: FbAlert - hideNotify");
    }

    protected void showNotify() {
        super.showNotify();
        this.display.setCurrent((Displayable)this);
        Logger.printOut("[WALKMATE]: FbAlert - showNotify - display: " + this.display);
    }

    protected void paint(Graphics g) {
        int x = 20;
        int y = 65;
        int lineHeight = 0;
        int y_bkg = 0;
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.hasOkButton) {
            if (!this.lineSeparator) {
                this.infoBkg = this.imgInfo;
                y = 55;
            } else if (this.msgSavedLogin && this.msg3 != null) {
                this.infoBkg = this.imgInfo;
                y = 10;
            } else {
                this.infoBkg = this.imgPublished;
                y = 30;
            }
        } else if (this.geonames || this.warning) {
            y = 10;
            this.infoBkg = this.imgInfo;
        } else {
            y_bkg = 45;
            this.infoBkg = this.imgProgressBkg;
        }
        this.imageSize = this.infoBkg.getWidth();
        g.drawImage(this.infoBkg, 0, y_bkg, 20);
        Font mFont = Font.getFont((int)64, (int)1, (int)8);
        g.setColor(0xFFFFFF);
        if (this.msg3 != null) {
            lineHeight = mFont.getHeight();
            this.textFormat.write(g, this.msgInfo, 0, y + 30, 220, mFont, 2, 0, this.imageSize, 10, 2, false);
            if (this.lineSeparator) {
                g.drawLine(61, y + lineHeight + 31, 181, y + lineHeight + 31);
            }
            this.textFormat.write(g, this.msgUser, 0, y + 70, 220, mFont, 4, 0, this.imageSize, 5, 2, false);
            this.textFormat.write(g, this.msg3, 0, y + 125, 220, mFont, 4, 0, this.imageSize, 3, 2, false);
        } else if (this.msgUser != null) {
            mFont = Font.getFont((int)64, (int)0, (int)8);
            if (this.hasOkButton && this.invalidUserPass) {
                if (this.lineSeparator) {
                    this.textFormat.write(g, Translator.getMessage("WF_FACEBOOK_PUBLISHED_TXT"), 0, 6, 200, mFont, 10, 0, this.imageSize, 10, 2, false);
                }
                this.textFormat.write(g, this.msgInfo, x, y + 46, 220, mFont, 10, 0, this.imageSize, 5, 2, false);
                if (this.lineSeparator) {
                    g.drawLine(61, 130, 181, 130);
                }
                this.textFormat.write(g, this.msgUser, x, y + 120, 200, mFont, 6, 0, this.imageSize, 5, 2, false);
            } else {
                if (this.lineSeparator) {
                    this.textFormat.write(g, Translator.getMessage("WF_FACEBOOK_PUBLISHED_TXT"), 0, 6, 200, mFont, 10, 0, this.imageSize, 10, 2, false);
                }
                this.textFormat.write(g, this.msgInfo, x, y + 20, 220, mFont, 5, 0, this.imageSize, 5, 2, false);
                if (this.lineSeparator) {
                    g.drawLine(61, 137, 181, 137);
                    this.textFormat.write(g, this.msgUser, x + 5, y + 120, 220, mFont, 5, 0, this.imageSize, 3, 2, true);
                } else {
                    this.textFormat.write(g, this.msgUser, x + 5, y + 100, 220, mFont, 5, 0, this.imageSize, 3, 2, false);
                }
            }
        } else {
            this.textFormat.write(g, this.msgInfo, x, y + 41, 220, mFont, 10, 0, this.imageSize, 10, 2, false);
        }
        if (!(this.hasOkButton || this.warning || this.geonames)) {
            this.animation(g);
            this.timeOut = new TimeOut(this);
            this.timerFbAlert.schedule((TimerTask)this.timeOut, 500L);
        }
    }

    protected void animation(Graphics g) {
        g.setClip(25, 170, 192, 16);
        g.drawImage(this.imageProgressBar, 25, 170 - 16 * this.shift, 20);
        g.setClip(0, 0, 320, 240);
    }

    private void stopProgressBar() {
        Logger.printOut("[WALKMATE]: FbAlert - stopProgressBar");
        if (this.timerFbAlert != null) {
            this.timerFbAlert.cancel();
            this.timerFbAlert = null;
        } else {
            Logger.printOut("[WALKMATE]: FbAlert - stopProgressBar - timerFbAlert == null");
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == -9999 && !this.display.flashBacklight(0)) {
            this.stopProgressBar();
            this.eventListener.controlViewEvent(18);
        }
    }

    public void timeoutEvent(int event) {
        switch (event) {
            case 0: {
                ++this.shift;
                if (this.shift == this.animationSteps) {
                    this.shift = 0;
                }
                this.repaint();
            }
        }
    }
}

