/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.font.FontRenderer;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.utils.DateUtils;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Gui15
extends Gui {
    private static final int COLOR_TEXT_TODAY = 0xFFFFFF;
    private static final int ANIM_SMALL_FRAME_WIDTH = 29;
    private static final int UPDATE_CHECK_INTERVAL = 1000;
    private static final int SCREEN_WIDTH = 240;
    private static final int ANIM_BIG_FRAME_WIDTH = 30;
    protected final int[] barX = new int[]{32, 62, 92, 123, 154, 184, 215};
    protected final int[] barAngle;
    protected double scaleMax;
    protected final int scaleSteps;
    private int animationFrameWidth;
    private int coordsLeftTextX;
    private int coordsLeftTextY;
    private int coordsLeftDigitsX;
    private int coordsLeftDigitsY;
    private int coordsRightTextX;
    private int coordsRightTextY;
    private int coordsRightDigitsX;
    private int coordsRightDigitsY;
    private Image imageBarScaleMarker;
    private Image imagePersonIdle;
    private Image imagePersonWalk;
    private Image imagePersonHealth;
    private Image imageBarGradient;
    private double oldScaleMax;

    public Gui15(Display display, Datastore model) {
        super(display, model);
        int[] nArray = new int[7];
        nArray[0] = 45;
        nArray[1] = 30;
        nArray[2] = 15;
        nArray[4] = -15;
        nArray[5] = -30;
        nArray[6] = -45;
        this.barAngle = nArray;
        this.scaleMax = 10000.0;
        this.scaleSteps = 5;
        this.oldScaleMax = 10000.0;
        this.initializeColors();
    }

    public boolean startView() {
        super.startView();
        this.animationCounter = 15;
        this.animationFrameWidth = 29;
        return true;
    }

    public void initializeColors() {
        this.COLOR_LINE_SCALE = 0x474747;
        this.COLOR_LINE_HEALTH = 3170317;
        this.COLOR_TEXT_AVERAGE = 0xB9B8B8;
        this.COLOR_TEXT_HEADLINES = 0xB9B8B8;
        this.COLOR_TEXT_THISWEEK = 0xB9B8B8;
    }

    protected void initializeCoords() {
        this.coordsBackgroundY = -4;
        this.coordsScaleZero = this.coordsBackgroundY + 181;
        this.coordsScaleHeight = 65;
        this.coordsLeftTextX = 2;
        this.coordsLeftTextY = this.coordsScaleZero - 101;
        this.coordsLeftDigitsX = 2;
        this.coordsLeftDigitsY = this.coordsScaleZero - 82;
        this.coordsRightTextX = 236;
        this.coordsRightTextY = this.coordsScaleZero - 101;
        this.coordsRightDigitsX = 236;
        this.coordsRightDigitsY = this.coordsScaleZero - 82;
    }

    protected boolean initializeImages() {
        try {
            Logger.printOut("Gui15 - initializeImages");
            super.initializeImages();
            this.imageBackground = Image.createImage((String)"/images/background.png");
            Logger.printOut("Gui15 - initializeImages - imageBackground: " + this.imageBackground);
            this.imagePersonIdle = Image.createImage((String)"/images/walkingPersonWhiteIdle.png");
            this.imagePersonWalk = Image.createImage((String)"/images/walkingPersonWhite.png");
            this.imagePersonHealth = Image.createImage((String)"/images/walkingPersonWhiteWinner.png");
            this.imageBarGradient = Image.createImage((String)"/images/barGradient.png");
            this.imageBarScaleMarker = Image.createImage((String)"/images/barScaleMarker.png");
        }
        catch (IOException ex) {
            Logger.printOut("Gui15 - initializeImages - EXCEPTION");
            return false;
        }
        Logger.printOut("Gui15 - initializeImages - OK!!!!!!!!!!!!!!");
        return true;
    }

    public final void run() {
        if (this.doAnimate) {
            long currentMillis = System.currentTimeMillis();
            if (this.nextRepaintMillis == -1L || currentMillis >= this.nextRepaintMillis || Math.abs(currentMillis - this.nextRepaintMillis) > 5000L) {
                int frames = 1;
                frames = (int)((currentMillis - this.nextRepaintMillis) / (long)this.animationInterval);
                frames = frames == 0 ? 1 : 2;
                int i = 0;
                while (i != frames) {
                    this.updateCounter += this.animationInterval;
                    if (this.updateCounter >= 1000) {
                        this.updateCounter = 0;
                        if (DateUtils.getMillisToday() != this.millisToday) {
                            this.checkTimeAndDate();
                        }
                    }
                    if (this.isPastNextSwitchTimestamp()) {
                        this.setNextSwitchTimestamp();
                        boolean bl = this.showHealth = !this.showHealth;
                    }
                    if (this.showHealth && this.healthWidth != 240) {
                        this.healthWidth += 20;
                    } else if (!this.showHealth && this.healthWidth != 0) {
                        this.healthWidth -= 20;
                    }
                    if (this.manIsMoving || this.currentState != 1 && !this.manIsMoving && this.animationCounter != 15) {
                        if (this.currentState != 3 && this.stepsToday >= 10000 && this.stepsToday < 11000 && this.animationLoops != 1) {
                            this.animationCounter = 0;
                            this.animationLoops = 0;
                            this.animationFrames = 79;
                            this.animationFrameWidth = 29;
                            this.currentState = (byte)3;
                        } else if (this.currentState != 2 && (this.stepsToday < 10000 || this.stepsToday >= 11000) || this.currentState == 3 && this.stepsToday >= 10000 && this.stepsToday <= 11000 && this.animationLoops == 1) {
                            this.animationCounter = 0;
                            this.animationFrames = 28;
                            this.animationFrameWidth = 30;
                            this.currentState = (byte)2;
                        }
                    }
                    if ((this.currentState == 2 && !this.manIsMoving && this.animationCounter == 15 || this.currentState == 3 && !this.manIsMoving && (this.animationCounter < 15 || this.animationCounter > 50)) && this.currentState != 1) {
                        this.animationCounter = 0;
                        this.animationLoops = 0;
                        this.animationFrames = 81;
                        this.animationFrameWidth = 29;
                        this.currentState = 1;
                    }
                    this.animationCounter = (this.animationCounter + 1) % this.animationFrames;
                    if (this.currentState == 3 && this.animationCounter == 0 && this.animationLoops != 1) {
                        ++this.animationLoops;
                    }
                    ++i;
                }
                this.repaint();
                this.nextRepaintMillis = System.currentTimeMillis() + (long)this.animationInterval;
            } else if (this.nextRepaintMillis - currentMillis > 0L) {
                try {
                    Thread.sleep(this.nextRepaintMillis - currentMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.display.callSerially((Runnable)this);
        }
    }

    public void setListener(GuiListener listener) {
        Logger.printOut("[WALKMATE]: View1_5 - setListener");
        super.setListener(listener);
    }

    public void commandAction(Command command, Displayable displayable) {
        Logger.printOut("[WALKMATE]: View1_5 - commandAction");
        super.commandAction(command, displayable);
    }

    protected void drawBar(Graphics g, int x, int y, int angle, int width, int maxHeight, int scaleSteps, double heightFactor, int dayIndex) {
        int x1 = x;
        int y1 = y;
        int h1 = MathUtils.roundSpecial((double)maxHeight * heightFactor);
        int w1 = width;
        int x2 = x1 + MathUtils.roundSpecial((double)w1 * ((double)angle / 180.0));
        int y2 = y1 - MathUtils.roundSpecial((double)w1 * 0.25);
        int h2 = heightFactor == 1.0 ? h1 - MathUtils.roundSpecial(heightFactor * (double)w1 * 0.25) : h1 - MathUtils.roundSpecial(0.75 * heightFactor * (double)w1 * 0.25);
        int w2 = w1;
        int colorSide = 0;
        int colorFront = 0;
        int colorTop = 0;
        if (dayIndex == this.dayOfWeek) {
            if (this.stepsToday >= 10000) {
                colorSide = this.COLOR_BAR_HEALTH_SIDE;
                colorFront = this.COLOR_BAR_HEALTH_FRONT;
                colorTop = this.COLOR_BAR_HEALTH_TOP;
            } else {
                colorSide = this.COLOR_BAR_TODAY_SIDE;
                colorFront = this.COLOR_BAR_TODAY_FRONT;
                colorTop = this.COLOR_BAR_TODAY_TOP;
            }
        } else if (dayIndex < this.dayOfWeek) {
            if (this.stepsLastWeek[dayIndex] >= 10000) {
                colorSide = this.COLOR_BAR_HEALTH_SIDE;
                colorFront = this.COLOR_BAR_HEALTH_FRONT;
                colorTop = this.COLOR_BAR_HEALTH_TOP;
            } else {
                colorSide = this.COLOR_BAR_BEFORE_SIDE;
                colorFront = this.COLOR_BAR_BEFORE_FRONT;
                colorTop = this.COLOR_BAR_BEFORE_TOP;
            }
        } else if (this.stepsLastWeek[dayIndex] >= 10000) {
            colorSide = this.COLOR_BAR_HEALTH_AFTER_SIDE;
            colorFront = Gui.COLOR_BAR_HEALTH_AFTER_FRONT;
            colorTop = this.COLOR_BAR_HEALTH_AFTER_TOP;
        } else {
            colorSide = this.COLOR_BAR_AFTER_SIDE;
            colorFront = this.COLOR_BAR_AFTER_FRONT;
            colorTop = this.COLOR_BAR_AFTER_TOP;
        }
        double scaleStep = (double)maxHeight / (double)scaleSteps;
        if (heightFactor != 0.0) {
            int reflectionCorrectionY = (int)MathUtils.round((double)this.imageBarReflection.getHeight() * (1.0 - heightFactor / 1.25));
            if (angle <= 0) {
                g.setClip(x2 - 2, y2 - 1, Math.abs(x2 - x1) + 3, this.imageBarReflection.getHeight());
            } else {
                g.setClip(x1 + w1, y2 - 1, Math.abs(x2 - x1) + 3, this.imageBarReflection.getHeight());
            }
            if (angle < 0) {
                g.drawImage(this.imageBarReflection, x2 - 2, y2 - 5 - reflectionCorrectionY, 20);
            } else if (angle > 0) {
                g.drawImage(this.imageBarReflection, x2 - 1, y2 - 5 - reflectionCorrectionY, 20);
            }
            g.setClip(x1 - 1, y1 - 1, this.imageBarReflection.getWidth(), this.imageBarReflection.getHeight());
            g.drawImage(this.imageBarReflection, x1 - 1, y1 - 1 - reflectionCorrectionY, 20);
            g.setClip(0, 0, 240, 320);
            g.drawImage(this.imageBarShadow, x1 + MathUtils.roundSpecial((double)(x2 - x1) / 1.5) - 8, y1 - 16, 20);
            g.setColor(colorSide);
            g.fillRect(x2, y2 - h2, w2, h2);
            g.fillTriangle(x1 + w1, y1, x2 + w2, y2, x2 + w2, y2 - h2);
            g.fillTriangle(x1 + w1, y1, x1 + w1, y1 - h1, x2 + w2, y2 - h2);
            g.fillTriangle(x1, y1, x2, y2, x2, y2 - h2);
            g.fillTriangle(x1, y1, x1, y1 - h1, x2, y2 - h2);
            g.setColor(colorFront);
            g.fillRect(x1, y1 - h1, w1, h1);
            g.setColor(colorTop);
            g.fillTriangle(x1, y1 - h1, x2, y2 - h2, x2 + w2, y2 - h2);
            g.fillTriangle(x1, y1 - h1, x1 + w1, y1 - h1, x2 + w2, y2 - h2);
            if ((double)h1 > scaleStep) {
                g.setClip(0, y1 - h1, 240, h1);
                g.drawImage(this.imageBarGradient, x1 + 1, y1 - h1, 20);
                g.setClip(0, 0, 240, 320);
            }
        }
        int i = 1;
        while (i != scaleSteps) {
            int scaleY = MathUtils.roundSpecial((double)y1 - scaleStep * (double)i);
            if (scaleY <= y1 - h1) break;
            g.drawImage(this.imageBarScaleMarker, x1 + 1, scaleY, 20);
            ++i;
        }
        String weekdayString = this.textWeekdays[dayIndex];
        int tx = x1 + w1 / 2;
        int ty = y1 + 4 + FontRenderer.getTextHeight(0, weekdayString) / 2;
        FontRenderer.drawText(g, tx + 1, ty + 1, 1, 0, this.COLOR_TEXT_SHADOW, weekdayString);
        int weekdayColor = dayIndex == this.dayOfWeek ? 0xFFFFFF : (dayIndex > this.dayOfWeek ? this.COLOR_TEXT_PASTWEEK : this.COLOR_TEXT_THISWEEK);
        FontRenderer.drawText(g, tx, ty, 1, 0, weekdayColor, weekdayString);
        if (dayIndex == this.dayOfWeek) {
            Image currentImage = this.imagePersonIdle;
            if (this.currentState == 2) {
                currentImage = this.imagePersonWalk;
            } else if (this.currentState == 1) {
                currentImage = this.imagePersonIdle;
            } else if (this.currentState == 3) {
                currentImage = this.imagePersonHealth;
            }
            int walkingPersonX = x1 + w1 / 2 + (x2 - x1) / 2 - 16;
            int walkingPersonY = y1 - h1 + (h1 - h2) / 2;
            int walkingPersonW = this.animationFrameWidth;
            int walkingPersonH = currentImage.getHeight();
            g.setClip(walkingPersonX, walkingPersonY - walkingPersonH, walkingPersonW, walkingPersonH - 2);
            g.drawImage(currentImage, walkingPersonX - this.animationCounter * walkingPersonW, walkingPersonY, 36);
            g.setClip(0, 0, 240, 320);
        }
    }

    protected void showNotify() {
        super.showNotify();
    }

    public void paintFase1(Graphics g) {
        g.setClip(0, 0, 240, 320);
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imageBackground, 0, this.coordsBackgroundY, 20);
        this.scaleMax = 10000.0;
        while (this.scaleMax < (double)this.biggestNumberOfSteps) {
            this.scaleMax += 5000.0;
        }
        if (this.oldScaleMax == 10000.0 && this.scaleMax > this.oldScaleMax && this.currentState == 3 && this.stepsToday >= 10000) {
            this.scaleMax = this.oldScaleMax;
        } else {
            this.oldScaleMax = this.scaleMax;
        }
        double scaleDistance = (double)this.coordsScaleHeight / 5.0;
        int scaleStep = (int)this.scaleMax / 5;
        int biggestWidth = 0;
        int i = 1;
        while (i != 6) {
            int w = FontRenderer.getTextWidth(g, 0, String.valueOf(scaleStep / 1000 * i) + this.textKilo);
            if (w > biggestWidth) {
                biggestWidth = w;
            }
            ++i;
        }
        if (this.healthWidth != 0) {
            int i2;
            int lineY = this.coordsScaleZero - MathUtils.roundSpecial(10000.0 / this.scaleMax * (double)this.coordsScaleHeight);
            g.setColor(this.COLOR_LINE_HEALTH);
            if (this.showHealth) {
                i2 = biggestWidth;
                while (i2 < this.healthWidth) {
                    g.drawLine(i2, lineY, i2 + 1, lineY);
                    i2 += 4;
                }
            } else {
                i2 = biggestWidth + (240 - this.healthWidth);
                while (i2 < 240) {
                    g.drawLine(i2, lineY, i2 + 1, lineY);
                    i2 += 4;
                }
            }
        }
        g.setColor(this.COLOR_LINE_SCALE);
        i = 1;
        while (i != 6) {
            int y = MathUtils.roundSpecial((double)this.coordsScaleZero - scaleDistance * (double)i);
            g.drawLine(0, y, biggestWidth + 3, y);
            FontRenderer.drawText(g, biggestWidth, y + 3, 8, 0, this.COLOR_TEXT_SCALE, String.valueOf(scaleStep / 1000 * i) + this.textKilo);
            ++i;
        }
    }

    public void paintFase2(Graphics g, Graphics savedGraphics) {
        g.setClip(0, 0, 240, 320);
        String steps = "" + this.stepsToday;
        String healthGoal = "10000";
        String average = "" + this.dailyAverage;
        FontRenderer.drawText(g, this.coordsLeftTextX, this.coordsLeftTextY, 4, 0, this.COLOR_TEXT_HEADLINES, this.textStepsToday);
        FontRenderer.drawText(g, this.coordsLeftDigitsX + 1, this.coordsLeftDigitsY + 1, 4, 1, this.COLOR_TEXT_SHADOW, steps);
        FontRenderer.drawText(g, this.coordsLeftDigitsX, this.coordsLeftDigitsY, 4, 1, this.COLOR_TEXT_STEPS, steps);
        if (this.showHealth) {
            FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY, 8, 0, this.COLOR_TEXT_HEADLINES, this.textHealthGoal);
            FontRenderer.drawText(g, this.coordsRightDigitsX + 1, this.coordsRightDigitsY + 1, 8, 1, this.COLOR_TEXT_SHADOW, "10000");
            FontRenderer.drawText(g, this.coordsRightDigitsX, this.coordsRightDigitsY, 8, 1, this.COLOR_TEXT_HEALTH, "10000");
        } else {
            FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY, 8, 0, this.COLOR_TEXT_HEADLINES, this.textDailyAverage);
            FontRenderer.drawText(g, this.coordsRightDigitsX + 1, this.coordsRightDigitsY + 1, 8, 1, this.COLOR_TEXT_SHADOW, average);
            FontRenderer.drawText(g, this.coordsRightDigitsX, this.coordsRightDigitsY, 8, 1, this.COLOR_TEXT_AVERAGE, average);
        }
        g.setClip(0, 0, 240, 320);
        savedGraphics.drawImage(this.offscreenBuffer, 0, 0, 20);
    }

    public void paint(Graphics g) {
        Graphics savedGraphics = g;
        g = this.offscreenBuffer.getGraphics();
        this.paintFase1(g);
        int i = 0;
        while (i != 7) {
            this.drawBar(g, this.barX[i], this.coordsScaleZero, this.barAngle[i], 20, this.coordsScaleHeight, 5, (double)this.stepsLastWeek[i] / this.scaleMax, i);
            ++i;
        }
        this.paintFase2(g, savedGraphics);
    }
}

