/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.font.FontRenderer;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.IdleScreen;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.utils.CarbonDioxideSaved;
import com.sonyericsson.walkmate.utils.DateUtils;
import com.sonyericsson.walkmate.utils.MathUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GuiGreenHeart
extends Gui {
    private int COLOR_GH_TXT_ORANGE;
    private int COLOR_GH_TXT_WHITE;
    private int COLOR_GH_TXT_DARK_GRAY;
    private int COLOR_GH_TXT_DARK_BROWN;
    private int COLOR_GH_TXT_STRONG_GREEN;
    private int COLOR_GH_TXT_DARK_GREEN;
    private int COLOR_GH_TXT_LIGHT_GREEN;
    private int COLOR_GH_TXT_SCALE;
    private int COLOR_GH_LINE_GREEN;
    private static final int ANIM_SMALL_FRAME_WIDTH = 29;
    private static final int UPDATE_CHECK_INTERVAL = 1000;
    private static final int SCREEN_WIDTH = 240;
    private static final int ANIM_BIG_FRAME_WIDTH = 30;
    protected final int[] barX = new int[]{30, 60, 90, 121, 152, 182, 213};
    protected final int[] barAngle;
    protected double scaleMax;
    protected final int scaleSteps;
    private int animationFrameWidth;
    private int coordsLeftTextX;
    private int coordsLeftTextY;
    private int coordsLeftDigitsX;
    private int coordsLeftDigitsY;
    private int coordsRightTextX;
    private int coordsRightTextY;
    private int coordsRightDigitsX;
    private int coordsRightDigitsY;
    private Image imagePersonIdle;
    private Image imagePersonWalk;
    private Image imagePersonHealth;
    private Image imageBarHealthGoal;
    private Image imageBarHealthLast;
    private Image imageBarLastDays;
    private Image imageBarLastWeek;
    private Image imageBarToday;
    private Image imageBkgTop;
    private Image imageBkgBottom;
    private Image imageCO2Saved;
    private Image leaf0;
    private Image leaf1;
    private Image leaf2;
    private Image leaf3;
    private Image leaf4;
    private Image leaf5;
    private Image leaf6;
    private Image leaf7;
    private Image leaf8;
    private Image leaf9;
    private Image leaf10;
    private Image leaf11;
    private Image leaf12;
    private Image leaf13;
    private Image leaf14;
    private int switchStage;
    private static final int SHOW_HEALTH = 1;
    private static final int DAILY_AVERAGE = 2;
    private static final int CO2_SAVED = 3;
    private int averageWidth;
    private static int LoopState = 1;
    private String co2SavedText1;
    private String co2SavedText2;
    private String co2SavedText3;
    private String textWalkMateEco;
    private double oldScaleMax;
    private IdleScreen idleScreen;
    private String language;
    private Font m_font;
    private int size;

    public GuiGreenHeart(Display display, Datastore model) {
        super(display, model);
        int[] nArray = new int[7];
        nArray[0] = 45;
        nArray[1] = 30;
        nArray[2] = 15;
        nArray[4] = -15;
        nArray[5] = -30;
        nArray[6] = -45;
        this.barAngle = nArray;
        this.scaleMax = 10000.0;
        this.scaleSteps = 5;
        this.averageWidth = 0;
        this.co2SavedText1 = "";
        this.co2SavedText2 = "";
        this.co2SavedText3 = "";
        this.textWalkMateEco = "Walk Mate Eco";
        this.oldScaleMax = 10000.0;
        this.idleScreen = null;
        this.language = "";
        this.m_font = null;
        this.initializeColors();
        this.m_font = Font.getFont((int)64, (int)1, (int)8);
    }

    public void commandAction(Command command, Displayable displayable) {
        Logger.printOut("[WALKMATE]: View - commandAction");
        super.commandAction(command, displayable);
        if (command == this.rskCommand) {
            this.display.setCurrent(null);
        }
    }

    public boolean startView() {
        super.startView();
        this.animationCounter = 15;
        this.animationFrameWidth = 29;
        return true;
    }

    public void initializeColors() {
        this.COLOR_LINE_SCALE = 0x474747;
        this.COLOR_LINE_AVERAGE = 16732928;
        this.COLOR_LINE_HEALTH = 3170317;
        this.COLOR_TEXT_AVERAGE = 0xB9B8B8;
        this.COLOR_TEXT_HEADLINES = 0xB9B8B8;
        this.COLOR_TEXT_THISWEEK = 0xB9B8B8;
        this.COLOR_GH_TXT_WHITE = 0xFFFFFF;
        this.COLOR_GH_TXT_ORANGE = 16732928;
        this.COLOR_GH_TXT_DARK_GRAY = 0x535353;
        this.COLOR_GH_TXT_DARK_BROWN = 8683885;
        this.COLOR_GH_TXT_STRONG_GREEN = 6653720;
        this.COLOR_GH_TXT_DARK_GREEN = 3954945;
        this.COLOR_GH_TXT_LIGHT_GREEN = 8296031;
        this.COLOR_GH_TXT_SCALE = 11051403;
        this.COLOR_GH_LINE_GREEN = 8305411;
    }

    protected void initializeCoords() {
        this.coordsBackgroundY = -4;
        this.coordsScaleZero = 192;
        this.coordsScaleHeight = 65;
        this.coordsLeftTextX = 2;
        this.coordsLeftTextY = this.coordsScaleZero - 136;
        this.coordsLeftDigitsX = 2;
        this.coordsLeftDigitsY = this.coordsScaleZero - 117;
        this.coordsRightTextX = 236;
        this.coordsRightTextY = this.coordsScaleZero - 136;
        this.coordsRightDigitsX = 236;
        this.coordsRightDigitsY = this.coordsScaleZero - 117;
    }

    protected boolean initializeImages() {
        try {
            this.imageBkgTop = Image.createImage((String)"/images/topbar.png");
            this.imageBkgBottom = Image.createImage((String)"/images/bottombar.png");
            this.imagePersonIdle = Image.createImage((String)"/images/walkingPersonGreenHeartIdle.png");
            this.imagePersonWalk = Image.createImage((String)"/images/walkingPersonGreenHeart.png");
            this.imagePersonHealth = Image.createImage((String)"/images/walkingPersonGreenHeartWinner.png");
            this.imageBarHealthGoal = Image.createImage((String)"/images/bar_healthgoal.png");
            this.imageBarHealthLast = Image.createImage((String)"/images/bar_healthgoal_lastweek.png");
            this.imageBarLastDays = Image.createImage((String)"/images/bar_lastdays.png");
            this.imageBarLastWeek = Image.createImage((String)"/images/bar_lastweek.png");
            this.imageBarToday = Image.createImage((String)"/images/bar_stepstoday.png");
            this.leaf0 = Image.createImage((String)"/images/leaf_0000.png");
            this.leaf1 = Image.createImage((String)"/images/leaf_1000.png");
            this.leaf2 = Image.createImage((String)"/images/leaf_2000.png");
            this.leaf3 = Image.createImage((String)"/images/leaf_3000.png");
            this.leaf4 = Image.createImage((String)"/images/leaf_4000.png");
            this.leaf5 = Image.createImage((String)"/images/leaf_5000.png");
            this.leaf6 = Image.createImage((String)"/images/leaf_6000.png");
            this.leaf7 = Image.createImage((String)"/images/leaf_7000.png");
            this.leaf8 = Image.createImage((String)"/images/leaf_8000.png");
            this.leaf9 = Image.createImage((String)"/images/leaf_9000.png");
            this.leaf10 = Image.createImage((String)"/images/leaf_10000.png");
            this.leaf11 = Image.createImage((String)"/images/leaf_11000.png");
            this.leaf12 = Image.createImage((String)"/images/leaf_12000.png");
            this.leaf13 = Image.createImage((String)"/images/leaf_13000.png");
            this.leaf14 = Image.createImage((String)"/images/leaf_14000.png");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void setIdleScreen(IdleScreen idleScreen) {
        this.idleScreen = idleScreen;
    }

    public void initializeGUI(int[] stepsLastWeek, int daysWithStepsLastWeek, int dayOfWeek) {
        Logger.printOut("[WALKMATE]: GuiGreenHeart - initializeGUI - stepsLastWeek: " + stepsLastWeek);
        Logger.printOut("PASSOU NO GUI GREEN HEART: " + this.idleScreen.getIdleScreen());
        if (this.idleScreen.getIdleScreen()) {
            this.display.setCurrent((Displayable)this);
        }
        this.stepsToday = this.stepsLastWeek[dayOfWeek];
        this.daysWithStepsLastWeek = daysWithStepsLastWeek;
        this.dayOfWeek = dayOfWeek;
        this.millisToday = DateUtils.getMillisToday();
        this.dailyAverage = this.getDailyAverage();
        this.biggestNumberOfSteps = this.getBiggestNumberOfSteps();
    }

    public final void run() {
        if (this.doAnimate) {
            long currentMillis = System.currentTimeMillis();
            if (this.nextRepaintMillis == -1L || currentMillis >= this.nextRepaintMillis || Math.abs(currentMillis - this.nextRepaintMillis) > 5000L) {
                int frames = 1;
                frames = (int)((currentMillis - this.nextRepaintMillis) / (long)this.animationInterval);
                frames = frames == 0 ? 1 : 2;
                int i = 0;
                while (i != frames) {
                    this.updateCounter += this.animationInterval;
                    if (this.updateCounter >= 1000) {
                        this.updateCounter = 0;
                        if (DateUtils.getMillisToday() != this.millisToday) {
                            this.checkTimeAndDate();
                        }
                    }
                    if (this.isPastNextSwitchTimestamp()) {
                        ++this.switchStage;
                        if (this.switchStage == 2) {
                            this.switchStage = 0;
                            this.setNextSwitchTimestamp();
                        } else {
                            switch (LoopState) {
                                case 1: {
                                    LoopState = 2;
                                    break;
                                }
                                case 2: {
                                    LoopState = 3;
                                    break;
                                }
                                case 3: {
                                    LoopState = 1;
                                }
                            }
                        }
                    }
                    if (LoopState == 1 && this.healthWidth != 240) {
                        this.healthWidth += 20;
                    } else if (LoopState != 1 && this.healthWidth > 0) {
                        this.healthWidth -= 20;
                    }
                    if (LoopState == 2 && this.averageWidth != 240) {
                        this.averageWidth += 20;
                    } else if (LoopState != 2 && this.averageWidth > 0) {
                        this.averageWidth -= 20;
                    }
                    if (this.manIsMoving || this.currentState != 1 && !this.manIsMoving && this.animationCounter != 15) {
                        if (this.currentState != 3 && this.stepsToday >= 10000 && this.stepsToday < 11000 && this.animationLoops != 1) {
                            this.animationCounter = 0;
                            this.animationLoops = 0;
                            this.animationFrames = 79;
                            this.animationFrameWidth = 29;
                            this.currentState = (byte)3;
                        } else if (this.currentState != 2 && (this.stepsToday < 10000 || this.stepsToday >= 11000) || this.currentState == 3 && this.stepsToday >= 10000 && this.stepsToday <= 11000 && this.animationLoops == 1) {
                            this.animationCounter = 0;
                            this.animationFrames = 28;
                            this.animationFrameWidth = 30;
                            this.currentState = (byte)2;
                        }
                    }
                    if ((this.currentState == 2 && !this.manIsMoving && this.animationCounter == 15 || this.currentState == 3 && !this.manIsMoving && (this.animationCounter < 15 || this.animationCounter > 50)) && this.currentState != 1) {
                        this.animationCounter = 0;
                        this.animationLoops = 0;
                        this.animationFrames = 81;
                        this.animationFrameWidth = 29;
                        this.currentState = 1;
                    }
                    this.animationCounter = (this.animationCounter + 1) % this.animationFrames;
                    if (this.currentState == 3 && this.animationCounter == 0 && this.animationLoops != 1) {
                        ++this.animationLoops;
                    }
                    ++i;
                }
                this.repaint();
                this.nextRepaintMillis = System.currentTimeMillis() + (long)this.animationInterval;
            } else if (this.nextRepaintMillis - currentMillis > 0L) {
                try {
                    Thread.sleep(this.nextRepaintMillis - currentMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.display.callSerially((Runnable)this);
        }
    }

    protected void updateLanguage() {
        super.updateLanguage();
        this.language = System.getProperty("microedition.locale");
        this.co2SavedText1 = Translator.getMessage("JAVAAPPS_GH_CO2_SAVED1_TXT");
        this.co2SavedText2 = Translator.getMessage("JAVAAPPS_GH_2_SUBSCRIPT_TXT");
        this.co2SavedText3 = Translator.getMessage("JAVAAPPS_GH_CO2_SAVED2_TXT");
    }

    private void drawBar(Graphics g, int x, int y, int angle, int width, int maxHeight, int scaleSteps, double heightFactor, int dayIndex) {
        int h2;
        int x1 = x;
        int y2 = y;
        int w1 = width;
        int h1 = MathUtils.roundSpecial((double)maxHeight * heightFactor);
        if (dayIndex == this.dayOfWeek && this.stepsToday > 0 && h1 == 0) {
            h1 = 1;
        } else if (this.stepsLastWeek[dayIndex] > 0 && h1 == 0) {
            h1 = 1;
        }
        int x2 = x1 + MathUtils.roundSpecial((double)w1 * ((double)angle / 180.0));
        int n = h2 = heightFactor == 1.0 ? h1 - MathUtils.roundSpecial(heightFactor * (double)w1 * 0.25) : h1 - MathUtils.roundSpecial(0.75 * heightFactor * (double)w1 * 0.25);
        if (h1 > 0) {
            if (dayIndex == this.dayOfWeek) {
                if (this.stepsToday >= 10000) {
                    g.drawImage(this.imageBarHealthGoal, x1, y2 - h2, 0);
                } else {
                    g.drawImage(this.imageBarToday, x1, y2 - h2, 0);
                }
            } else if (dayIndex < this.dayOfWeek) {
                if (this.stepsLastWeek[dayIndex] >= 10000) {
                    g.drawImage(this.imageBarHealthGoal, x1, y2 - h2, 0);
                } else {
                    g.drawImage(this.imageBarLastDays, x1, y2 - h2, 0);
                }
            } else if (this.stepsLastWeek[dayIndex] >= 10000) {
                g.drawImage(this.imageBarHealthLast, x1, y2 - h2, 0);
            } else {
                g.drawImage(this.imageBarLastWeek, x1, y2 - h2, 0);
            }
        }
        if (dayIndex == this.dayOfWeek) {
            Image currentImage = this.imagePersonIdle;
            if (this.currentState == 2) {
                currentImage = this.imagePersonWalk;
            } else if (this.currentState == 1) {
                currentImage = this.imagePersonIdle;
            } else if (this.currentState == 3) {
                currentImage = this.imagePersonHealth;
            }
            int walkingPersonX = x1 + w1 / 2 + (x2 - x1) / 2 - 16 + 10;
            int walkingPersonY = y2 - h1 + (h1 - h2) / 2 + 6;
            int walkingPersonW = this.animationFrameWidth;
            int walkingPersonH = currentImage.getHeight();
            g.setClip(walkingPersonX, walkingPersonY - walkingPersonH, walkingPersonW, walkingPersonH - 2);
            g.drawImage(currentImage, walkingPersonX - this.animationCounter * walkingPersonW, walkingPersonY, 36);
            g.setClip(0, 0, 240, 320);
        }
    }

    private void drawDaysOfWeek(Graphics g, int dayIndex, int x1, int y1, int w1) {
        String weekdayString = this.textWeekdays[dayIndex];
        int tx = x1 + w1 / 2 + 2;
        int ty = y1 + 4 + FontRenderer.getTextHeight(0, weekdayString) / 2;
        int weekdayColor = dayIndex == this.dayOfWeek ? (this.stepsToday >= 10000 ? this.COLOR_GH_TXT_STRONG_GREEN : this.COLOR_GH_TXT_ORANGE) : (dayIndex < this.dayOfWeek ? (this.stepsLastWeek[dayIndex] >= 10000 ? this.COLOR_GH_TXT_STRONG_GREEN : this.COLOR_GH_TXT_LIGHT_GREEN) : (this.stepsLastWeek[dayIndex] >= 10000 ? this.COLOR_GH_TXT_DARK_GREEN : this.COLOR_GH_TXT_DARK_BROWN));
        FontRenderer.drawText(g, tx, ty + 2, 1, 0, weekdayColor, weekdayString);
    }

    protected void showNotify() {
        Logger.printOut("[WALKMATE]: CO2 GreenHeart - showNotify");
        this.listener.controlViewEvent(30);
        super.showNotify();
        this.updateLanguage();
    }

    public void paint(Graphics g) {
        Graphics savedGraphics = g;
        g = this.offscreenBuffer.getGraphics();
        g.setClip(0, 0, 240, 320);
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.imageBkgTop, 0, 0, 20);
        FontRenderer.drawText(g, this.getWidth() / 2, 25, 1, 0, this.COLOR_GH_TXT_WHITE, this.textWalkMateEco);
        this.scaleMax = 10000.0;
        while (this.scaleMax < (double)this.biggestNumberOfSteps) {
            this.scaleMax += 5000.0;
        }
        if (this.oldScaleMax == 10000.0 && this.scaleMax > this.oldScaleMax && this.currentState == 3 && this.stepsToday >= 10000) {
            this.scaleMax = this.oldScaleMax;
        } else {
            this.oldScaleMax = this.scaleMax;
        }
        double scaleDistance = (double)this.coordsScaleHeight / 5.0;
        int scaleStep = (int)this.scaleMax / 5;
        int biggestWidth = 0;
        int i = 1;
        while (i != 6) {
            int w = FontRenderer.getTextWidth(g, 0, String.valueOf(scaleStep / 1000 * i) + this.textKilo);
            if (w > biggestWidth) {
                biggestWidth = w;
            }
            ++i;
        }
        if (this.healthWidth != 0 || this.averageWidth != 0) {
            int i2;
            int healthLineY = this.coordsScaleZero - MathUtils.roundSpecial(10000.0 / this.scaleMax * (double)this.coordsScaleHeight);
            int averageLineY = this.coordsScaleZero - MathUtils.roundSpecial((double)this.dailyAverage / this.scaleMax * (double)this.coordsScaleHeight);
            if (LoopState == 1) {
                g.setColor(this.COLOR_GH_LINE_GREEN);
                i2 = biggestWidth;
                while (i2 < this.healthWidth) {
                    g.drawLine(i2, healthLineY, i2 + 1, healthLineY);
                    i2 += 4;
                }
            } else if (LoopState == 2) {
                g.setColor(this.COLOR_GH_LINE_GREEN);
                i2 = biggestWidth + (240 - this.healthWidth);
                while (i2 < 240) {
                    g.drawLine(i2, healthLineY, i2 + 1, healthLineY);
                    i2 += 4;
                }
                g.setColor(this.COLOR_LINE_AVERAGE);
                i2 = biggestWidth;
                while (i2 < this.averageWidth) {
                    g.drawLine(i2, averageLineY, i2 + 1, averageLineY);
                    i2 += 4;
                }
            } else {
                g.setColor(this.COLOR_LINE_AVERAGE);
                i2 = biggestWidth + (240 - this.averageWidth);
                while (i2 < 240) {
                    g.drawLine(i2, averageLineY, i2 + 1, averageLineY);
                    i2 += 4;
                }
            }
        }
        g.setColor(this.COLOR_GH_TXT_SCALE);
        i = 1;
        while (i != 6) {
            int y = MathUtils.roundSpecial((double)this.coordsScaleZero - scaleDistance * (double)i);
            g.drawLine(0, y, biggestWidth + 3, y);
            FontRenderer.drawText(g, biggestWidth, y + 3, 8, 0, this.COLOR_GH_TXT_SCALE, String.valueOf(scaleStep / 1000 * i) + this.textKilo);
            ++i;
        }
        i = 0;
        while (i != 7) {
            this.drawBar(g, this.barX[i], this.coordsScaleZero, this.barAngle[i], 5, this.coordsScaleHeight, 5, (double)this.stepsLastWeek[i] / this.scaleMax, i);
            ++i;
        }
        g.setClip(0, 0, 240, 320);
        g.drawImage(this.imageBkgBottom, 0, this.getHeight() - this.imageBkgBottom.getHeight(), 0);
        i = 0;
        while (i != 7) {
            this.drawDaysOfWeek(g, i, this.barX[i], this.coordsScaleZero + 3, 20);
            ++i;
        }
        String steps = "" + this.stepsToday;
        String healthGoal = "10000";
        String average = "" + this.dailyAverage;
        String co2SavedToday = String.valueOf(CarbonDioxideSaved.convertStepsToCO2(this.stepsToday)) + "g";
        FontRenderer.drawText(g, this.coordsLeftTextX, this.coordsLeftTextY, 4, 0, this.COLOR_GH_TXT_DARK_GRAY, this.textStepsToday);
        FontRenderer.drawText(g, this.coordsLeftDigitsX, this.coordsLeftDigitsY, 4, 1, this.COLOR_GH_TXT_ORANGE, steps);
        if (LoopState == 1) {
            FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.textHealthGoal);
            FontRenderer.drawText(g, this.coordsRightDigitsX, this.coordsRightDigitsY, 8, 1, this.COLOR_GH_TXT_STRONG_GREEN, "10000");
        } else if (LoopState == 2) {
            FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.textDailyAverage);
            FontRenderer.drawText(g, this.coordsRightDigitsX, this.coordsRightDigitsY, 8, 1, this.COLOR_GH_TXT_ORANGE, average);
        } else if (LoopState == 3) {
            this.DrawImageGreenHeart(g);
            if (this.language.compareTo("es") == 0 || this.language.compareTo("zh-HK") == 0 || this.language.compareTo("zh-CN") == 0 || this.language.compareTo("zh-TW") == 0) {
                this.size = this.m_font.stringWidth(this.co2SavedText1);
                FontRenderer.drawText(g, this.coordsRightTextX - 5, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText1);
                FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY + 8, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText2);
                FontRenderer.drawText(g, this.coordsRightTextX - this.size - 7, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText3);
            } else {
                this.size = this.m_font.stringWidth(this.co2SavedText3);
                FontRenderer.drawText(g, this.coordsRightTextX - this.size - 10, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText1);
                FontRenderer.drawText(g, this.coordsRightTextX - this.size - 6, this.coordsRightTextY + 8, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText2);
                FontRenderer.drawText(g, this.coordsRightTextX, this.coordsRightTextY, 8, 0, this.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText3);
            }
            FontRenderer.drawText(g, this.coordsRightDigitsX, this.coordsRightDigitsY, 8, 1, this.COLOR_GH_TXT_ORANGE, co2SavedToday);
        }
        g.setClip(0, 0, 240, 320);
        savedGraphics.drawImage(this.offscreenBuffer, 0, 0, 20);
    }

    private void DrawImageGreenHeart(Graphics g) {
        this.imageCO2Saved = this.stepsToday >= 1000 && this.stepsToday < 2000 ? this.leaf1 : (this.stepsToday >= 2000 && this.stepsToday < 3000 ? this.leaf2 : (this.stepsToday >= 3000 && this.stepsToday < 4000 ? this.leaf3 : (this.stepsToday >= 4000 && this.stepsToday < 5000 ? this.leaf4 : (this.stepsToday >= 5000 && this.stepsToday < 6000 ? this.leaf5 : (this.stepsToday >= 6000 && this.stepsToday < 7000 ? this.leaf6 : (this.stepsToday >= 7000 && this.stepsToday < 8000 ? this.leaf7 : (this.stepsToday >= 8000 && this.stepsToday < 9000 ? this.leaf8 : (this.stepsToday >= 9000 && this.stepsToday < 10000 ? this.leaf9 : (this.stepsToday >= 10000 && this.stepsToday < 11000 ? this.leaf10 : (this.stepsToday >= 11000 && this.stepsToday < 12000 ? this.leaf11 : (this.stepsToday >= 12000 && this.stepsToday < 13000 ? this.leaf12 : (this.stepsToday >= 13000 && this.stepsToday < 14000 ? this.leaf13 : (this.stepsToday >= 14000 ? this.leaf14 : this.leaf0)))))))))))));
        g.drawImage(this.imageCO2Saved, this.coordsRightTextX - 54, this.coordsRightTextY, 24);
    }
}

