/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.lcdui.IdleItem;
import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.language.Translator;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;

public class IdleScreen
extends IdleItem
implements ItemCommandListener {
    public boolean idleScreen = true;
    private boolean paintIdleScreen = false;
    protected Image image;
    protected static final int ANIM_SMALL_FRAME_WIDTH = 29;
    protected static final int ANIM_BIG_FRAME_WIDTH = 30;
    protected static final int ANIM_FRAMES_IDLE = 81;
    protected static final int ANIM_FRAMES_WALK = 28;
    protected static final int ANIM_FRAMES_HEALTH = 79;
    protected static final byte STATE_IDLE = 1;
    protected static final byte STATE_WALK = 2;
    protected static final byte STATE_HEALTH = 3;
    protected static final int HEALTH_GOAL = 10000;
    protected static final int MIN_HEIGHT = 148;
    protected static final int MIN_WIDTH = 210;
    protected static final int PREF_WIDTH = 210;
    protected static final int PREF_HEIGHT = 200;
    protected static final int SCREEN_WIDTH = 240;
    protected byte currentState = 1;
    protected Image imagePersonIdle;
    protected Image imagePersonWalk;
    protected Image imagePersonHealth;
    int animationCounter;
    int animationLoops;
    int animationFrames = 81;
    int animationFrameWidth = 29;
    protected Display display;
    protected Gui fullScreen;
    private Timer timer;
    protected static int COLOR_GH_TXT_DARK_GRAY = 0x535353;
    protected static int COLOR_GH_TXT_ORANGE = 16732928;
    protected static int COLOR_GH_TXT_WHITE = 0xFFFFFF;
    protected String textStepsToday = "";
    protected int center = 0;
    protected String language = "";
    protected Font m_font = null;
    protected int size;
    protected int sizeCo;
    protected int position;

    public IdleScreen(Display display, Gui fullScreen) {
        super("WallkmateApp");
        Logger.printOut("WallkmateApp idleScreen");
        this.display = display;
        this.fullScreen = fullScreen;
        this.m_font = Font.getFont((int)64, (int)1, (int)8);
        this.setItemCommandListener(this);
        this.animationCounter = 15;
        this.animationLoops = 0;
    }

    public void commandAction(Command cmd, Item item) {
    }

    protected int getMinContentHeight() {
        return 148;
    }

    protected int getMinContentWidth() {
        return 210;
    }

    protected int getPrefContentHeight(int width) {
        return 200;
    }

    protected int getPrefContentWidth(int height) {
        return 210;
    }

    protected void onSizeChanged() {
        this.repaint();
    }

    protected void updateLanguage() {
        this.language = System.getProperty("microedition.locale");
        this.textStepsToday = Translator.getMessage("JAVAAPPS_WM_STEPS_TODAY_TXT");
    }

    protected void paint(Graphics g, int width, int height) {
        this.idleScreen = false;
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRectInout) {
        this.display.setCurrent(null);
        this.display.setCurrent((Displayable)this.fullScreen);
        return false;
    }

    protected void traverseOut() {
    }

    public boolean getIdleScreen() {
        return this.idleScreen;
    }

    public void showNotify() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                IdleScreen.this.duderinoUpdate();
                IdleScreen.this.repaint();
            }
        }, 50L, 50L);
        this.fullScreen.checkTimeAndDate();
        if (Translator.localeHasChanged()) {
            Translator.initLocalizationSupport();
        }
        this.updateLanguage();
        if (!this.paintIdleScreen) {
            this.idleScreen = true;
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    protected void removedFromDisplay(Display d) {
        this.idleScreen = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    protected void addedToDisplay(Display d) {
        this.idleScreen = false;
    }

    private void duderinoUpdate() {
        if (this.fullScreen.manIsMoving || this.currentState != 1 && !this.fullScreen.manIsMoving && this.animationCounter != 15) {
            if (this.currentState != 3 && this.fullScreen.stepsToday >= 10000 && this.fullScreen.stepsToday < 11000 && this.animationLoops != 1) {
                this.animationCounter = 0;
                this.animationLoops = 0;
                this.animationFrames = 79;
                this.animationFrameWidth = 29;
                this.currentState = (byte)3;
            } else if (this.currentState != 2 && (this.fullScreen.stepsToday < 10000 || this.fullScreen.stepsToday >= 11000) || this.currentState == 3 && this.fullScreen.stepsToday >= 10000 && this.fullScreen.stepsToday <= 11000 && this.animationLoops == 1) {
                this.animationCounter = 0;
                this.animationFrames = 28;
                this.animationFrameWidth = 30;
                this.currentState = (byte)2;
            }
        }
        if ((this.currentState == 2 && !this.fullScreen.manIsMoving && this.animationCounter == 15 || this.currentState == 3 && !this.fullScreen.manIsMoving && (this.animationCounter < 15 || this.animationCounter > 50)) && this.currentState != 1) {
            this.animationCounter = 0;
            this.animationLoops = 0;
            this.animationFrames = 81;
            this.animationFrameWidth = 29;
            this.currentState = 1;
        }
        this.animationCounter = (this.animationCounter + 1) % this.animationFrames;
        if (this.currentState == 3 && this.animationCounter == 0 && this.animationLoops != 1) {
            ++this.animationLoops;
        }
    }

    public void fullscreenOut() {
        this.display.setCurrent(null);
    }
}

