/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.font.FontRenderer;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.IdleScreen;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.utils.DateUtils;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IdleScreen15
extends IdleScreen {
    private boolean showHealth = true;
    private long nextSwitchTimestamp;
    private static final int SWITCH_INTERVAL = 8000;
    private String textHealthGoal = "";
    private String textDailyAverage = "";

    public IdleScreen15(Display display, Gui fullScreen) {
        super(display, fullScreen);
        try {
            this.image = Image.createImage((String)"/images/background_idle_screen15.png");
            this.imagePersonIdle = Image.createImage((String)"/images/walkingPersonWhiteIdle.png");
            this.imagePersonWalk = Image.createImage((String)"/images/walkingPersonWhite.png");
            this.imagePersonHealth = Image.createImage((String)"/images/walkingPersonWhiteWinner.png");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    protected void updateLanguage() {
        super.updateLanguage();
        this.language = System.getProperty("microedition.locale");
        this.textStepsToday = Translator.getMessage("JAVAAPPS_WM_STEPS_TODAY_TXT");
        this.textHealthGoal = Translator.getMessage("JAVAAPPS_WM_HEALTH_GOAL_TXT");
        this.textDailyAverage = Translator.getMessage("JAVAAPPS_WM_DAILY_AVERAGE_TXT");
    }

    protected void paint(Graphics g, int width, int height) {
        super.paint(g, width, height);
        Image currentImage = this.imagePersonIdle;
        int x = (width - this.image.getWidth()) / 2;
        int y = (height - this.image.getHeight()) / 2;
        g.drawImage(this.image, x, y, 20);
        this.center = this.image.getWidth() / 2;
        FontRenderer.drawText(g, this.center, y + 18, 1, 0, IdleScreen.COLOR_GH_TXT_WHITE, "Walk Mate");
        if (DateUtils.getMillisToday() != this.fullScreen.millisToday) {
            this.fullScreen.checkTimeAndDate();
        }
        FontRenderer.drawText(g, this.center, y + 37, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.textStepsToday);
        FontRenderer.drawText(g, this.center, y + 59, 1, 2, IdleScreen.COLOR_GH_TXT_DARK_GRAY, Integer.toString(this.fullScreen.stepsToday));
        if (this.currentState == 2) {
            currentImage = this.imagePersonWalk;
        } else if (this.currentState == 1) {
            currentImage = this.imagePersonIdle;
        } else if (this.currentState == 3) {
            currentImage = this.imagePersonHealth;
        }
        int walkingPersonX = this.image.getWidth() / 2 - 14;
        int walkingPersonW = this.animationFrameWidth;
        int walkingPersonY = y + 105;
        int walkingPersonH = currentImage.getHeight();
        g.setClip(walkingPersonX, walkingPersonY - walkingPersonH, walkingPersonW, walkingPersonH - 2);
        g.drawImage(currentImage, walkingPersonX - this.animationCounter * walkingPersonW, walkingPersonY, 36);
        g.setClip(0, 0, 240, 320);
        if (this.showHealth) {
            Logger.printOut("[WALKMATE]: IdleScreen15 - Health Goal");
            FontRenderer.drawText(g, this.center, y + 119, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.textHealthGoal);
            FontRenderer.drawText(g, this.center, y + 141, 1, 2, this.fullScreen.COLOR_TEXT_HEALTH, Integer.toString(10000));
        } else {
            Logger.printOut("[WALKMATE]: IdleScreen15 - Daily Average");
            FontRenderer.drawText(g, this.center, y + 119, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.textDailyAverage);
            FontRenderer.drawText(g, this.center, y + 141, 1, 2, IdleScreen.COLOR_GH_TXT_DARK_GRAY, Integer.toString(this.fullScreen.dailyAverage));
        }
        if (this.isPastNextSwitchTimestamp()) {
            this.setNextSwitchTimestamp();
            this.showHealth = !this.showHealth;
        }
    }

    protected final boolean isPastNextSwitchTimestamp() {
        return System.currentTimeMillis() >= this.nextSwitchTimestamp || this.nextSwitchTimestamp - System.currentTimeMillis() > 16000L;
    }

    protected final void setNextSwitchTimestamp() {
        this.nextSwitchTimestamp = System.currentTimeMillis() + 8000L;
    }
}

