/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.font.FontRenderer;
import com.sonyericsson.walkmate.gui.Gui;
import com.sonyericsson.walkmate.gui.IdleScreen;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.utils.CarbonDioxideSaved;
import com.sonyericsson.walkmate.utils.DateUtils;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IdleScreenGreenHeart
extends IdleScreen {
    private Image imageCO2Saved;
    private Image leaf0;
    private Image leaf1;
    private Image leaf2;
    private Image leaf3;
    private Image leaf4;
    private Image leaf5;
    private Image leaf6;
    private Image leaf7;
    private Image leaf8;
    private Image leaf9;
    private Image leaf10;
    private Image leaf11;
    private Image leaf12;
    private Image leaf13;
    private Image leaf14;
    private String co2SavedText1 = "";
    private String co2SavedText2 = "";
    private String co2SavedText3 = "";
    private String concat = "";
    private String co2SavedToday = "";

    public IdleScreenGreenHeart(Display display, Gui fullScreen) {
        super(display, fullScreen);
        try {
            this.image = Image.createImage((String)"/images/homescreen_background.png");
            this.imagePersonIdle = Image.createImage((String)"/images/walkingPersonGreenHeartIdle.png");
            this.imagePersonWalk = Image.createImage((String)"/images/walkingPersonGreenHeart.png");
            this.imagePersonHealth = Image.createImage((String)"/images/walkingPersonGreenHeartWinner.png");
            this.leaf0 = Image.createImage((String)"/images/leaf_0000.png");
            this.leaf1 = Image.createImage((String)"/images/leaf_1000.png");
            this.leaf2 = Image.createImage((String)"/images/leaf_2000.png");
            this.leaf3 = Image.createImage((String)"/images/leaf_3000.png");
            this.leaf4 = Image.createImage((String)"/images/leaf_4000.png");
            this.leaf5 = Image.createImage((String)"/images/leaf_5000.png");
            this.leaf6 = Image.createImage((String)"/images/leaf_6000.png");
            this.leaf7 = Image.createImage((String)"/images/leaf_7000.png");
            this.leaf8 = Image.createImage((String)"/images/leaf_8000.png");
            this.leaf9 = Image.createImage((String)"/images/leaf_9000.png");
            this.leaf10 = Image.createImage((String)"/images/leaf_10000.png");
            this.leaf11 = Image.createImage((String)"/images/leaf_11000.png");
            this.leaf12 = Image.createImage((String)"/images/leaf_12000.png");
            this.leaf13 = Image.createImage((String)"/images/leaf_13000.png");
            this.leaf14 = Image.createImage((String)"/images/leaf_14000.png");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    protected void updateLanguage() {
        super.updateLanguage();
        this.co2SavedText1 = Translator.getMessage("JAVAAPPS_GH_CO2_SAVED1_TXT");
        this.co2SavedText2 = Translator.getMessage("JAVAAPPS_GH_2_SUBSCRIPT_TXT");
        this.co2SavedText3 = Translator.getMessage("JAVAAPPS_GH_CO2_SAVED2_TXT");
    }

    protected void paint(Graphics g, int width, int height) {
        super.paint(g, width, height);
        Image currentImage = this.imagePersonIdle;
        int x = (width - this.image.getWidth()) / 2;
        int y = (height - this.image.getHeight()) / 2;
        g.drawImage(this.image, x, y, 20);
        this.center = this.image.getWidth() / 2;
        FontRenderer.drawText(g, this.center, y + 18, 1, 0, IdleScreen.COLOR_GH_TXT_WHITE, "Walk Mate Eco");
        if (DateUtils.getMillisToday() != this.fullScreen.millisToday) {
            this.fullScreen.checkTimeAndDate();
        }
        FontRenderer.drawText(g, this.center, y + 39, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.textStepsToday);
        FontRenderer.drawText(g, this.center, y + 58, 1, 1, IdleScreen.COLOR_GH_TXT_ORANGE, Integer.toString(this.fullScreen.stepsToday));
        this.co2SavedToday = String.valueOf(CarbonDioxideSaved.convertStepsToCO2(this.fullScreen.getStepsToday())) + "g";
        if (this.language.compareTo("es") == 0 || this.language.compareTo("zh-HK") == 0 || this.language.compareTo("zh-CN") == 0 || this.language.compareTo("zh-TW") == 0) {
            this.concat = String.valueOf(this.co2SavedText3) + this.co2SavedText1;
            this.size = this.m_font.stringWidth(this.concat);
            FontRenderer.drawText(g, this.center + this.size / 2 + 1, y + 130, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText2);
            FontRenderer.drawText(g, this.center, y + 122, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.concat);
        } else {
            this.concat = String.valueOf(this.co2SavedText1) + "  " + this.co2SavedText3;
            this.size = this.m_font.stringWidth(this.concat);
            this.sizeCo = this.m_font.stringWidth(this.co2SavedText1);
            this.position = 120 - this.size / 2 + this.sizeCo - 12;
            FontRenderer.drawText(g, this.position - 2, y + 130, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.co2SavedText2);
            FontRenderer.drawText(g, this.center, y + 122, 1, 0, IdleScreen.COLOR_GH_TXT_DARK_GRAY, this.concat);
        }
        FontRenderer.drawText(g, this.center + 37, y + 142, 8, 1, IdleScreen.COLOR_GH_TXT_ORANGE, this.co2SavedToday);
        this.DrawImageGreenHeart(g, this.center - 19, y + 123);
        if (this.currentState == 2) {
            currentImage = this.imagePersonWalk;
        } else if (this.currentState == 1) {
            currentImage = this.imagePersonIdle;
        } else if (this.currentState == 3) {
            currentImage = this.imagePersonHealth;
        }
        int walkingPersonX = this.image.getWidth() / 2 - 14;
        int walkingPersonW = this.animationFrameWidth;
        int walkingPersonY = y + 107;
        int walkingPersonH = currentImage.getHeight();
        g.setClip(walkingPersonX, walkingPersonY - walkingPersonH, walkingPersonW, walkingPersonH - 2);
        g.drawImage(currentImage, walkingPersonX - this.animationCounter * walkingPersonW, walkingPersonY, 36);
        g.setClip(0, 0, 240, 320);
    }

    private void DrawImageGreenHeart(Graphics g, int x, int y) {
        this.imageCO2Saved = this.fullScreen.stepsToday >= 1000 && this.fullScreen.stepsToday < 2000 ? this.leaf1 : (this.fullScreen.stepsToday >= 2000 && this.fullScreen.stepsToday < 3000 ? this.leaf2 : (this.fullScreen.stepsToday >= 3000 && this.fullScreen.stepsToday < 4000 ? this.leaf3 : (this.fullScreen.stepsToday >= 4000 && this.fullScreen.stepsToday < 5000 ? this.leaf4 : (this.fullScreen.stepsToday >= 5000 && this.fullScreen.stepsToday < 6000 ? this.leaf5 : (this.fullScreen.stepsToday >= 6000 && this.fullScreen.stepsToday < 7000 ? this.leaf6 : (this.fullScreen.stepsToday >= 7000 && this.fullScreen.stepsToday < 8000 ? this.leaf7 : (this.fullScreen.stepsToday >= 8000 && this.fullScreen.stepsToday < 9000 ? this.leaf8 : (this.fullScreen.stepsToday >= 9000 && this.fullScreen.stepsToday < 10000 ? this.leaf9 : (this.fullScreen.stepsToday >= 10000 && this.fullScreen.stepsToday < 11000 ? this.leaf10 : (this.fullScreen.stepsToday >= 11000 && this.fullScreen.stepsToday < 12000 ? this.leaf11 : (this.fullScreen.stepsToday >= 12000 && this.fullScreen.stepsToday < 13000 ? this.leaf12 : (this.fullScreen.stepsToday >= 13000 && this.fullScreen.stepsToday < 14000 ? this.leaf13 : (this.fullScreen.stepsToday >= 14000 ? this.leaf14 : this.leaf0)))))))))))));
        g.drawImage(this.imageCO2Saved, x, y, 24);
    }
}

