/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.gui.FbAlert;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.utils.TimeOut;
import com.sonyericsson.walkmate.utils.TimerListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class LocatorAction
implements Runnable,
TimerListener,
GuiListener {
    private static final long TIMER_VALUE = 10000L;
    private Display mainDisplay;
    private GuiListener listener;
    private String URL = "";
    private String cellname = null;
    private String geoname = null;
    private HttpConnection connection;
    private boolean operationCancelled;
    private boolean hasconnected = true;
    private Timer timer = null;
    private FbAlert alert;

    public LocatorAction(Display main, GuiListener listener) {
        this.mainDisplay = main;
        this.listener = listener;
        this.locationAlert();
    }

    public void run() {
        DataInputStream is = null;
        StringBuffer stringBuffer = new StringBuffer();
        this.URL = this.getLocation();
        this.timer = new Timer();
        TimeOut timeOut = new TimeOut(this);
        this.timer.schedule((TimerTask)timeOut, 10000L);
        try {
            int ch;
            this.connection = (HttpConnection)Connector.open((String)this.URL);
            this.connection.setRequestMethod("GET");
            this.connection.setRequestProperty("IF-Modified-Since", "20 Jan 2001 16:19:14 GMT");
            this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            is = this.connection.openDataInputStream();
            while ((ch = ((InputStream)is).read()) != -1 && !this.operationCancelled) {
                stringBuffer.append((char)ch);
            }
            if (!this.operationCancelled) {
                this.cellname = this.XMLParser("cellname", stringBuffer.toString());
                this.geoname = this.XMLParser("geoname", stringBuffer.toString());
            }
        }
        catch (IOException e) {
            Logger.printOut("[WALKMATE]: IOException " + e);
            e.printStackTrace();
        }
        if (this.cellname == null || this.geoname == null) {
            this.hasconnected = false;
        }
        try {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Logger.printOut("[WALKMATE]: LocatorAction - IOException - connection.close();" + e);
                e.printStackTrace();
                if (!this.operationCancelled) {
                    this.cancelTimer();
                    Logger.printOut("[WALKMATE]: LocatorAction - sending END_LOCATOR_THREAD 1 ");
                    this.listener.controlViewEvent(3);
                }
            }
        }
        finally {
            if (!this.operationCancelled) {
                this.cancelTimer();
                Logger.printOut("[WALKMATE]: LocatorAction - sending END_LOCATOR_THREAD 1 ");
                this.listener.controlViewEvent(3);
            }
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        } else {
            Logger.printOut("[WALKMATE]: LocatorAction - cancelTimer - timer == null");
        }
        this.timer = null;
    }

    private String XMLParser(String fieldName, String buffer) {
        String beginField = "<" + fieldName + ">";
        String endField = "</" + fieldName + ">";
        int startStr = buffer.indexOf(beginField) + beginField.length();
        int endStr = buffer.indexOf(endField);
        return buffer.substring(startStr, endStr);
    }

    private String getLocation() {
        String locateURL = "";
        String mnc = System.getProperty("com.sonyericsson.net.cmnc");
        String mcc = System.getProperty("com.sonyericsson.net.mcc");
        String cellId = System.getProperty("com.sonyericsson.net.cellid");
        String lac = System.getProperty("com.sonyericsson.net.lac");
        String rat = System.getProperty("com.sonyericsson.net.rat");
        locateURL = "http://www.sercpos.com/service/cellchecknew.php?phonenumber=walkmate&password=miles500&cellcmnc=" + mnc + "&" + "cellcmcc" + "=" + mcc + "&" + "cellcellid" + "=" + cellId + "&" + "celllac" + "=" + lac + "&" + "cellrat" + "=" + rat;
        return locateURL;
    }

    public void locationAlert() {
        Logger.printOut("[WALKMATE]: LocationAlert - before creating FBAlert");
        this.alert = new FbAlert(this, this.mainDisplay, Translator.getMessage("WF_PROGRESS_GETTING_INFO_TXT"));
        this.mainDisplay.setCurrent((Displayable)this.alert);
        Logger.printOut("[WALKMATE]: LocationAlert - after creating FBAlert");
    }

    public void setCurrentCanvas() {
        if (this.alert != null) {
            this.mainDisplay.setCurrent((Displayable)this.alert);
            Logger.printOut("[WALKMATE]: LocatorAction - setCurrentCanvas");
        } else {
            Logger.printOut("[WALKMATE]: LocatorAction - setCurrentCanvas - ALERT == NULL");
        }
    }

    public boolean getConnectionStatus() {
        return this.hasconnected;
    }

    public String getCellName() {
        return this.cellname;
    }

    public String getGeoName() {
        return this.geoname;
    }

    public void timeoutEvent(int event) {
        if (event == 0) {
            Logger.printOut("[WALKMATE]: LocatorAction - TIMEOUT_EVENT");
            this.cancelTimer();
            this.operationCancelled = true;
            this.hasconnected = false;
            Logger.printOut("[WALKMATE]: LocatorAction - sending END_LOCATOR_THREAD 2 ");
            this.listener.controlViewEvent(3);
        }
    }

    public void controlViewEvent(int event) {
        if (event == 4) {
            this.operationCancelled = true;
            this.cancelTimer();
            Logger.printOut("[WALKMATE]: LocatorAction - CANCEL_LOCATION_ACTION");
            this.listener.controlViewEvent(9);
        } else if (event == 18) {
            this.operationCancelled = true;
            this.cancelTimer();
            Logger.printOut("[WALKMATE]: LocatorAction - CANCEL_OPERATION_KEY_RELEASED");
            this.listener.controlViewEvent(18);
        }
    }
}

