/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.httpfacebook.service.ServiceException;
import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.facebook.FacebookErrors;
import com.sonyericsson.walkmate.facebook.FacebookHttpUtil;
import com.sonyericsson.walkmate.facebook.PostRequest;
import com.sonyericsson.walkmate.facebook.utils.RMSAuth;
import com.sonyericsson.walkmate.facebook.utils.SignInParser;
import com.sonyericsson.walkmate.gui.FbAlert;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.utils.TimeOut;
import com.sonyericsson.walkmate.utils.TimerListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class PostAction
implements Runnable,
TimerListener,
GuiListener {
    private static final long TIMER_VALUE = 40000L;
    private static final int CONNECTION_ERROR = 3;
    private static final int NOT_AUTHORIZED = 4;
    private static final int SUCCESS_POST = 5;
    private RMSAuth rmsAuth;
    private boolean operationCancelled = false;
    private String message;
    private GuiListener listener;
    private int postResult = 0;
    private Display mainDisplay;
    private Timer timer = null;
    private FbAlert alert;
    private PostRequest postReq;

    public PostAction(Display mainDysplay, String message, GuiListener listener) {
        this.mainDisplay = mainDysplay;
        this.message = message;
        this.listener = listener;
    }

    public void run() {
        block8: {
            this.rmsAuth = RMSAuth.getRMSAuth();
            int result = 12;
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            String errorCode = "";
            SignInParser parser = new SignInParser();
            this.submitAlert();
            this.timer = new Timer();
            TimeOut timeOut = new TimeOut(this);
            this.timer.schedule((TimerTask)timeOut, 40000L);
            try {
                try {
                    this.postReq = new PostRequest(parser, sessionKey, secret, this.message);
                    Logger.printOut("POST URL" + this.postReq);
                    result = FacebookHttpUtil.doRequest(this.postReq);
                    errorCode = parser.getErrorCode();
                    if (result == 0 && !errorCode.trim().equalsIgnoreCase("") && !this.operationCancelled) {
                        result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                        if (result == 5) {
                            this.postResult = 4;
                            throw new ServiceException(0);
                        }
                        break block8;
                    }
                    if (result == 0) {
                        result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                        this.postResult = 5;
                        break block8;
                    }
                    this.postResult = 3;
                }
                catch (ServiceException se) {
                    Logger.printOut("[WALKMATE]: ServiceException performing Posting Action: " + se.getMessage());
                    result = se.getResult();
                    this.cancelTimer();
                    Logger.printOut("[WALKMATE]: PostAction - sending END_POST_THREAD 1 ");
                    this.listener.controlViewEvent(2);
                }
            }
            finally {
                this.cancelTimer();
                Logger.printOut("[WALKMATE]: PostAction - sending END_POST_THREAD 1 ");
                this.listener.controlViewEvent(2);
            }
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        } else {
            Logger.printOut("[WALKMATE]: PostAction - cancelTimer - timer == null");
        }
        this.timer = null;
    }

    public void submitAlert() {
        this.alert = new FbAlert(this, this.mainDisplay, Translator.getMessage("WF_PROGRESS_PUBLISHING_TXT"));
        this.mainDisplay.setCurrent((Displayable)this.alert);
    }

    public int getPostResult() {
        return this.postResult;
    }

    public void setCurrentCanvas() {
        if (this.alert != null) {
            this.mainDisplay.setCurrent((Displayable)this.alert);
            Logger.printOut("[WALKMATE]: PostAction - setCurrentCanvas");
        } else {
            Logger.printOut("[WALKMATE]: PostAction - setCurrentCanvas - ALERT == NULL");
        }
    }

    public void timeoutEvent(int event) {
        if (event == 0) {
            Logger.printOut("[WALKMATE]: LocatorAction - TIMEOUT_EVENT");
            this.cancelTimer();
            this.operationCancelled = true;
            Logger.printOut("[WALKMATE]: PostAction - sending END_POST_THREAD 2 ");
            this.listener.controlViewEvent(2);
        }
    }

    public void controlViewEvent(int event) {
        if (event == 4) {
            this.operationCancelled = true;
            Logger.printOut("[WALKMATE]: PostAction - controlViewEvent - CANCEL_OPERATION");
            this.cancelTimer();
            Logger.printOut("[WALKMATE]: PostAction - controlViewEvent - CANCEL_OPERATION - cancel timer");
            this.listener.controlViewEvent(12);
        } else if (event == 18) {
            this.operationCancelled = true;
            this.cancelTimer();
            this.listener.controlViewEvent(18);
        }
    }
}

