/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.gui;

import com.sonyericsson.httpfacebook.service.ServiceException;
import com.sonyericsson.walkmate.Logger;
import com.sonyericsson.walkmate.facebook.FacebookErrors;
import com.sonyericsson.walkmate.facebook.FacebookHttpUtil;
import com.sonyericsson.walkmate.facebook.SignInRequest;
import com.sonyericsson.walkmate.facebook.UserInfoRequest;
import com.sonyericsson.walkmate.facebook.utils.RMSAuth;
import com.sonyericsson.walkmate.facebook.utils.SignInParser;
import com.sonyericsson.walkmate.facebook.utils.UserInfoParser;
import com.sonyericsson.walkmate.gui.FbAlert;
import com.sonyericsson.walkmate.gui.GuiListener;
import com.sonyericsson.walkmate.language.Translator;
import com.sonyericsson.walkmate.utils.TimeOut;
import com.sonyericsson.walkmate.utils.TimerListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class SignInAction
implements GuiListener,
Runnable,
TimerListener {
    private static final int SUCCESS_LOGIN = 1;
    private static final int INVALID_USER_PASS = 2;
    private static final int CONNECTION_ERROR = 3;
    private static final int TIMER_VALUE = 75000;
    private RMSAuth rmsAuth;
    private String user;
    private String password;
    private Display mainDisplay;
    private int userLoginState = 0;
    private GuiListener listener;
    public int loginResult = 12;
    public int userInfoResult = 12;
    private boolean operationCancelled;
    private Timer timer;
    private FbAlert alert;
    private SignInRequest signInReq;
    private UserInfoRequest userInfoReq;

    public SignInAction(String user, String password, Display mainDisplay) {
        Logger.printOut("[WALKMATE]: SignInAction - constructor 1");
        this.user = user;
        this.password = password;
        this.mainDisplay = mainDisplay;
    }

    public SignInAction(Display mainDisplay) {
        Logger.printOut("[WALKMATE]: SignInAction - constructor 2");
        this.mainDisplay = mainDisplay;
    }

    public void run() {
        Logger.printOut("[WALKMATE]: SignInAction - run");
        this.rmsAuth = RMSAuth.getRMSAuth();
        String sessionKey = null;
        String uid = null;
        String secret = null;
        String name = null;
        String nickname = null;
        String errorCode = "";
        SignInParser parser = new SignInParser();
        this.timer = new Timer();
        TimeOut timeOut = new TimeOut(this);
        this.timer.schedule((TimerTask)timeOut, 75000L);
        this.loggingAlert();
        try {
            if (this.user == null || this.password == null) {
                throw new ServiceException(4);
            }
            if (this.user.trim().length() <= 0 || this.password.trim().length() <= 0) {
                throw new ServiceException(0);
            }
            this.signInReq = new SignInRequest(parser, this.user, this.password);
            this.loginResult = FacebookHttpUtil.doRequest(this.signInReq);
            errorCode = parser.getErrorCode();
            if (this.loginResult == 0 && !errorCode.trim().equalsIgnoreCase("") && !this.operationCancelled) {
                this.loginResult = FacebookErrors.getWebAlbumErrorCode(errorCode);
                if (this.loginResult == 5) {
                    this.userLoginState = 2;
                    this.rmsAuth.clearSessionKey();
                    throw new ServiceException(0);
                }
            } else if (this.loginResult == 0 && !this.operationCancelled) {
                sessionKey = parser.getSessionValue();
                uid = parser.getUidValue();
                secret = parser.getSecretValue();
                if (sessionKey != null && sessionKey.trim().length() > 0 && uid != null && uid.trim().length() > 0 && secret != null && secret.trim().length() > 0 && !this.operationCancelled) {
                    this.rmsAuth.setSessionKey(sessionKey);
                    this.rmsAuth.setUid(uid);
                    this.rmsAuth.setSecret(secret);
                    this.rmsAuth.setName("");
                    this.rmsAuth.setNick("");
                    this.rmsAuth.setSubscriberNumber(this.getSubscriberNumber());
                    this.userLoginState = 1;
                    UserInfoParser userInfoParser = new UserInfoParser();
                    Vector<String> uidVector = new Vector<String>();
                    uidVector.addElement(uid);
                    this.userInfoReq = new UserInfoRequest(userInfoParser, uidVector, sessionKey, secret);
                    this.userInfoResult = FacebookHttpUtil.doRequest(this.userInfoReq);
                    errorCode = userInfoParser.getErrorCode();
                    if (this.userInfoResult == 0 && !errorCode.trim().equalsIgnoreCase("") && !this.operationCancelled) {
                        this.userInfoResult = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    } else if (this.userInfoResult == 0 && !this.operationCancelled) {
                        name = userInfoParser.getUserName();
                        nickname = userInfoParser.getNickName();
                        this.rmsAuth.setLocale(userInfoParser.getLocale());
                        if (name != null) {
                            this.rmsAuth.setName(name);
                        }
                        if (nickname != null) {
                            this.rmsAuth.setNick(nickname);
                        }
                    }
                } else {
                    this.userLoginState = 3;
                    this.rmsAuth.clearSessionKey();
                }
            } else {
                this.userLoginState = 3;
                this.rmsAuth.clearSessionKey();
            }
        }
        catch (ServiceException se) {
            Logger.printOut("[WALKMATE]: ServiceException performing Sign-in Action: " + se.getMessage());
            this.loginResult = se.getResult();
        }
        if (!this.operationCancelled) {
            this.timer.cancel();
            this.timer = null;
            this.listener.controlViewEvent(1);
        }
    }

    public String getSubscriberNumber() {
        String subscriberNumber = System.getProperty("com.sonyericsson.sim.subscribernumber");
        return subscriberNumber;
    }

    public void loggingAlert() {
        Logger.printOut("[WALKMATE]: SignInAction - LoggingAlert");
        this.alert = new FbAlert(this, this.mainDisplay, Translator.getMessage("WF_PROGRESS_LOGGING_TXT"));
        this.mainDisplay.setCurrent((Displayable)this.alert);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getUserLoginState() {
        return this.userLoginState;
    }

    public void setListener(GuiListener listener) {
        Logger.printOut("[WALKMATE]: SignInAction - setListener - listener: " + listener);
        this.listener = listener;
    }

    public void setCurrentCanvas() {
        Logger.printOut("[WALKMATE]: SignInAction - setCurrentCanvas");
        if (this.alert != null) {
            Logger.printOut("[WALKMATE]: SignInAction - setCurrentCanvas - alert != null");
            this.mainDisplay.setCurrent((Displayable)this.alert);
            Logger.printOut("[WALKMATE]: SignInAction - setCurrentCanvas");
        } else {
            Logger.printOut("[WALKMATE]: SignInAction - setCurrentCanvas - ALERT == NULL");
        }
    }

    public void controlViewEvent(int event) {
        Logger.printOut("[WALKMATE]: SignInAction - controlViewEvent");
        if (event == 4) {
            Logger.printOut("[WALKMATE]: SignInAction - controlViewEvent - CANCEL_OPERATION");
            this.operationCancelled = true;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            Logger.printOut("[WALKMATE]: SignInAction - controlViewEvent - CANCEL_OPERATION - listener: " + this.listener);
            this.listener.controlViewEvent(10);
        } else if (event == 18) {
            Logger.printOut("[WALKMATE]: SignInAction - controlViewEvent - CANCEL_OPERATION_KEY_RELEASED");
            this.operationCancelled = true;
            this.timer.cancel();
            this.timer = null;
            this.listener.controlViewEvent(18);
        }
    }

    public void timeoutEvent(int event) {
        Logger.printOut("[WALKMATE]: SignInAction - timeoutEvent");
        if (event == 0) {
            Logger.printOut("[WALKMATE]: SignInAction - timeoutEvent - sending END_LOGIN_THREAD");
            this.timer = null;
            this.operationCancelled = true;
            this.userLoginState = 3;
            this.listener.controlViewEvent(1);
        }
    }
}

