/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.walkmate.model.datastore;

import com.sonyericsson.walkmate.model.datastore.Datastore;
import com.sonyericsson.walkmate.utils.DateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FbDatastore
extends Datastore {
    private static final int STEPS = 0;
    private static final int FACEBOOK_ICON = 1;
    private static int[] result;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        result = nArray;
    }

    public final void setStepsForToday(int steps) throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        this.setSteps(this.getFacebookIconForToday(), steps, date[0], date[1], date[2], false);
    }

    public final void setFacebookIconForToday(int steps, int facebookIcon) throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        this.setSteps(facebookIcon, steps, date[0], date[1], date[2], false);
    }

    public final void setSteps(int facebookIcon, int steps, int year, int month, int day, boolean saveSteps) throws RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)"PEDWPMIDLET", (boolean)true);
        if (saveSteps) {
            facebookIcon = result[1];
        }
        int id = this.getRecordId(recordStore, year, month, day);
        byte[] record = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeShort((short)year);
            dataOutputStream.writeByte((byte)month);
            dataOutputStream.writeByte((byte)day);
            dataOutputStream.writeInt(steps);
            dataOutputStream.writeInt(facebookIcon);
            dataOutputStream.flush();
            record = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        if (id != -1 && record != null) {
            recordStore.setRecord(id, record, 0, record.length);
        } else if (record != null) {
            if (recordStore.getNumRecords() == 7) {
                int[] obsoleteIds = this.getObsoleteRecordIds(recordStore, (short)year, (byte)month, (byte)day);
                int i = 0;
                while (i != obsoleteIds.length) {
                    recordStore.deleteRecord(obsoleteIds[i]);
                    ++i;
                }
            }
            recordStore.addRecord(record, 0, record.length);
        }
        recordStore.closeRecordStore();
    }

    public final int getFacebookIconForToday() throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        int facebookIcon = -1;
        this.getSteps(date[0], date[1], date[2]);
        if (result[1] != -1) {
            facebookIcon = result[1];
        }
        return facebookIcon;
    }

    public final int getStepsForToday() throws RecordStoreException {
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        int steps = 0;
        this.getSteps(date[0], date[1], date[2]);
        if (result[0] != -1) {
            steps = result[0];
        }
        return steps;
    }

    public final int getSteps(int year, int month, int day) throws RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)"PEDWPMIDLET", (boolean)true);
        int id = this.getRecordId(recordStore, year, month, day);
        if (id != -1) {
            byte[] record = recordStore.getRecord(id);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(record));
            try {
                dataInputStream.readShort();
                dataInputStream.readByte();
                dataInputStream.readByte();
                FbDatastore.result[0] = dataInputStream.readInt();
                FbDatastore.result[1] = dataInputStream.readInt();
                dataInputStream.close();
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        } else {
            FbDatastore.result[0] = 0;
            FbDatastore.result[1] = -1;
        }
        recordStore.closeRecordStore();
        return result[0];
    }

    public final int[][] getFacebookStepsForLastWeek() throws RecordStoreException {
        int[][] dataForLastWeek = new int[2][7];
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        long millisToday = DateUtils.convertDateToMillis((short)date[0], (byte)date[1], (byte)date[2]);
        int dayOfWeek = DateUtils.convertMillisToDayOfWeek(millisToday);
        long oneDayInMillis = 86400000L;
        int i = 0;
        while (i != 7) {
            int steps = 0;
            int facebookIconLocal = -1;
            date = DateUtils.convertMillisToDate(millisToday - (long)i * 86400000L);
            this.getSteps(date[0], date[1], date[2]);
            if (result[0] != -1) {
                steps = result[0];
            }
            if (result[1] != -1) {
                facebookIconLocal = result[1];
            }
            dataForLastWeek[0][(7 - i + dayOfWeek) % 7] = steps;
            dataForLastWeek[1][(7 - i + dayOfWeek) % 7] = facebookIconLocal;
            ++i;
        }
        return dataForLastWeek;
    }

    public final int getFacebookDaysWithStepsLastWeek() throws RecordStoreException {
        int daysWithStepsLastWeek = 0;
        int[] date = DateUtils.convertMillisToDate(System.currentTimeMillis());
        long millisToday = DateUtils.convertDateToMillis((short)date[0], (byte)date[1], (byte)date[2]);
        long oneDayInMillis = 86400000L;
        int i = 1;
        while (i != 7) {
            date = DateUtils.convertMillisToDate(millisToday - (long)i * 86400000L);
            this.getSteps(date[0], date[1], date[2]);
            if (result[0] != 0) {
                ++daysWithStepsLastWeek;
            }
            ++i;
        }
        return daysWithStepsLastWeek;
    }
}

