/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TPColourMenu
implements TPTimerInterface {
    Image image;
    boolean state = false;
    int width;
    int height;
    int swatchSize;
    int x;
    int y;
    int fgY;
    int padding;
    int selectedColour;
    TPTimer timer = new TPTimer(this, 2000);

    public TPColourMenu() {
        this.setup();
    }

    void setup() {
        this.padding = TP.canvas.width / 48;
        this.x = this.padding * 2;
        this.swatchSize = TP.canvas.width / 20;
        int swatchAreaHeight = this.padding + this.swatchSize + this.padding;
        int swatchAreaWidth = (this.swatchSize + this.padding) * TPUtil.COLOURS.length;
        int triWidth = 15;
        int triHeight = triWidth / 2 + 1;
        int triX = 5;
        int triY = swatchAreaHeight;
        this.width = swatchAreaWidth + this.padding;
        this.height = swatchAreaHeight + triHeight;
        this.y = TP.canvas.height - this.height - 5;
        this.fgY = this.y + this.padding;
        Image tempImage = Image.createImage((int)this.width, (int)this.height);
        Graphics g = tempImage.getGraphics();
        g.setColor(0xFFFF00);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0x333333);
        g.fillRect(0, 0, this.width, swatchAreaHeight);
        for (int i = 0; i < triHeight; ++i) {
            g.drawLine(triX + i, i + triY, triX + triWidth - i, i + triY);
        }
        for (int j = 0; j < TPUtil.COLOURS.length; ++j) {
            int startX = this.padding + j * (this.swatchSize + this.padding);
            g.setColor(TPUtil.COLOURS[j]);
            g.fillRect(startX, this.padding, this.swatchSize, this.swatchSize);
        }
        int[] rgb = new int[tempImage.getWidth() * tempImage.getHeight()];
        tempImage.getRGB(rgb, 0, tempImage.getWidth(), 0, 0, tempImage.getWidth(), tempImage.getHeight());
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i] != -256) continue;
            rgb[i] = 0;
        }
        this.image = Image.createRGBImage((int[])rgb, (int)tempImage.getWidth(), (int)tempImage.getHeight(), (boolean)true);
    }

    void move() {
        this.selectedColour = this.selectedColour < TPUtil.COLOURS.length - 1 ? ++this.selectedColour : 0;
        TP.pix.setColourIndex(this.selectedColour);
        TP.canvas.repaint();
        this.timer.restartTimer();
    }

    boolean getState() {
        return this.state;
    }

    void setState(boolean state) {
        if (state) {
            this.selectedColour = TP.pix.currentColourIndex;
            this.timer.restartTimer();
        } else {
            this.timer.stopTimer();
        }
        this.state = state;
    }

    int getFgX() {
        return this.x + this.padding + TP.pix.currentColourIndex * (this.swatchSize + this.padding);
    }

    int getFgY() {
        return this.fgY;
    }

    public void timerEvent(TPTimer timer) {
        this.state = false;
        timer.stopTimer();
        TP.canvas.repaint();
    }
}

