/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class TPThumbCanvas
extends Canvas {
    int size;
    private int padderX;
    private int padderY;
    int index;
    private boolean moreImages = false;
    String[] openImages;
    TPGrid[] grids = new TPGrid[4];
    private final String returnLabel = TPLocale.getMessage("Return");
    private final String deleteLabel = TPLocale.getMessage("Delete");
    private final String okLabel = TPLocale.getMessage("OK");
    int selectedThumb = 0;
    private boolean redraw = false;
    private int mode;
    private boolean deleteWindowFlag = false;
    boolean deleteFlg = false;

    public TPThumbCanvas() {
        this.setFullScreenMode(true);
        this.calculateSizes();
    }

    void calculateSizes() {
        TP.pix.getClass();
        int pixWidth = 2 * 27 + 2;
        TP.pix.getClass();
        int pixHeight = 2 * 36 + 2;
        int sizeX = TP.canvas.width / pixWidth;
        int sizeY = TP.canvas.height / pixHeight;
        this.size = sizeX > sizeY ? sizeY : sizeX;
        this.padderX = (TP.canvas.width - pixWidth * this.size) / 3;
        this.padderY = (TP.canvas.height - pixHeight * this.size) / 3;
    }

    public void paint(Graphics g) {
        if (this.deleteWindowFlag) {
            this.showDelete(g);
        } else {
            g.setColor(0);
            if (!this.redraw) {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            int count = 0;
            TP.pix.getClass();
            int thumbWidth = this.size * 27 + this.padderX;
            TP.pix.getClass();
            int thumbHeight = this.size * 36 + this.padderY;
            if (!this.redraw) {
                int y = 0;
                while (true) {
                    TP.pix.getClass();
                    if (y >= 36) break;
                    int x = 0;
                    while (true) {
                        TP.pix.getClass();
                        if (x >= 27) break;
                        if (this.grids[0] != null) {
                            g.setColor(this.grids[0].getColour(count));
                            g.fillRect(this.padderX + x * this.size, this.padderY + y * this.size, this.size, this.size);
                        }
                        if (this.grids[1] != null) {
                            g.setColor(this.grids[1].getColour(count));
                            g.fillRect(this.padderX + thumbWidth + x * this.size, this.padderY + y * this.size, this.size, this.size);
                        }
                        if (this.grids[2] != null) {
                            g.setColor(this.grids[2].getColour(count));
                            g.fillRect(this.padderX + x * this.size, this.padderY + thumbHeight + y * this.size, this.size, this.size);
                        }
                        if (this.grids[3] != null) {
                            g.setColor(this.grids[3].getColour(count));
                            g.fillRect(this.padderX + thumbWidth + x * this.size, this.padderY + thumbHeight + y * this.size, this.size, this.size);
                        }
                        ++count;
                        ++x;
                    }
                    ++y;
                }
            }
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    int thisGrid = x + y * 2;
                    if (this.grids[thisGrid] == null) continue;
                    if (this.selectedThumb == thisGrid) {
                        g.setColor(0x66CCFF);
                        TP.pix.getClass();
                        TP.pix.getClass();
                        g.drawRect(this.padderX + thumbWidth * x - 3, this.padderY + thumbHeight * y - 3, this.size * 27 + 5, this.size * 36 + 5);
                        continue;
                    }
                    g.setColor(0x333333);
                    TP.pix.getClass();
                    TP.pix.getClass();
                    g.drawRect(this.padderX + thumbWidth * x - 1, this.padderY + thumbHeight * y - 1, this.size * 27 + 1, this.size * 36 + 1);
                }
            }
        }
        g.setColor(0x999999);
        g.setFont(TPUtil.FONT_MEDIUM);
        g.drawString(this.returnLabel, this.getWidth() - 8, this.getHeight() - 8, 40);
        if (TP.menu.onlineMenuIndex == 3) {
            if (this.deleteWindowFlag) {
                g.drawString(this.okLabel, 8, this.getHeight() - 8, 36);
            } else {
                g.drawString(this.deleteLabel, 8, this.getHeight() - 8, 36);
            }
        }
    }

    void reset() {
        this.index = 0;
        this.moreImages = false;
        this.selectedThumb = 0;
        this.openImages = null;
        this.deleteFlg = false;
        this.resetGrids();
    }

    void display(int mode) {
        this.redraw = false;
        this.mode = mode;
        TP.wait.stopCanvas();
        TP.setDisplay((Displayable)this);
    }

    void load(int[] pixels, int i, int width, int height, String location) {
        this.load(pixels, i, width, height, location, -1);
    }

    void load(int[] pixels, int i, int width, int height, int id) {
        this.load(pixels, i, width, height, null, id);
    }

    void load(int[] pixels, int i, int width, int height) {
        this.load(pixels, i, width, height, null, -1);
    }

    /*
     * Unable to fully structure code
     */
    void load(int[] pixels, int i, int width, int height, String location, int id) {
        TP.pix.getClass();
        if (width != 27) ** GOTO lbl-1000
        TP.pix.getClass();
        if (height == 36) {
            this.grids[i] = new TPGrid(pixels, id);
        } else lbl-1000:
        // 2 sources

        {
            TP.pix.getClass();
            TP.pix.getClass();
            smallPixels = TPUtil.resizeArray(pixels, width, height, 27, 36);
            this.grids[i] = new TPGrid(smallPixels, id);
        }
        if (location != null) {
            this.grids[i].location = location;
        }
    }

    void loadSelectedThumb() {
        TP.menu.savefilename = this.grids[this.selectedThumb].getFileName();
        TP.pix.load(this.grids[this.selectedThumb]);
        TP.setDisplay((Displayable)TP.canvas);
    }

    void setMoreImages(boolean moreImages) {
        this.moreImages = moreImages;
    }

    private void next(int selectedThumb) {
        if (this.moreImages) {
            this.selectedThumb = selectedThumb;
            this.index += 4;
            this.loadNew();
        }
    }

    private void previous(int selectedThumb) {
        if (this.index >= 4) {
            this.selectedThumb = selectedThumb;
            this.index -= 4;
            this.loadNew();
        }
    }

    private void loadNew() {
        if (this.mode == 2) {
            TP.wait.startCanvas();
            TP.setDisplay((Displayable)TP.wait);
            TP.connect.go(2);
        } else if (this.mode == 4) {
            TP.wait.startCanvas();
            TP.setDisplay((Displayable)TP.wait);
            TP.connect.go(4);
        }
    }

    void resetGrids() {
        for (int i = 0; i < this.grids.length; ++i) {
            if (this.grids[i] == null) continue;
            this.grids[i] = null;
        }
    }

    void changeThumbLoc(int keyCode) {
        boolean change = false;
        switch (keyCode) {
            case 1: {
                if (this.selectedThumb == 0) {
                    this.previous(2);
                    break;
                }
                if (this.selectedThumb == 1) {
                    this.previous(3);
                    break;
                }
                if (this.selectedThumb == 2) {
                    this.selectedThumb = 0;
                    change = true;
                    break;
                }
                if (this.selectedThumb != 3) break;
                this.selectedThumb = 1;
                change = true;
                break;
            }
            case 6: {
                if (this.selectedThumb == 0 && this.grids[2] != null) {
                    this.selectedThumb = 2;
                    change = true;
                    break;
                }
                if (this.selectedThumb == 1 && this.grids[3] != null) {
                    this.selectedThumb = 3;
                    change = true;
                    break;
                }
                if (this.selectedThumb == 2) {
                    this.next(0);
                    break;
                }
                if (this.selectedThumb != 3) break;
                this.next(1);
                break;
            }
            case 2: {
                if (this.selectedThumb == 0) {
                    this.previous(3);
                    break;
                }
                if (this.selectedThumb == 1) {
                    this.selectedThumb = 0;
                    change = true;
                    break;
                }
                if (this.selectedThumb == 2) {
                    this.selectedThumb = 1;
                    change = true;
                    break;
                }
                if (this.selectedThumb != 3) break;
                this.selectedThumb = 2;
                change = true;
                break;
            }
            case 5: {
                if (this.selectedThumb == 0 && this.grids[1] != null) {
                    this.selectedThumb = 1;
                    change = true;
                    break;
                }
                if (this.selectedThumb == 1 && this.grids[2] != null) {
                    this.selectedThumb = 2;
                    change = true;
                    break;
                }
                if (this.selectedThumb == 2 && this.grids[3] != null) {
                    this.selectedThumb = 3;
                    change = true;
                    break;
                }
                if (this.selectedThumb != 3) break;
                this.next(0);
            }
        }
        if (change) {
            this.redraw = false;
            TP.thumb.repaint();
        }
    }

    protected void keyReleased(int keyCode) {
        int key = TP.canvas.getGameKey(keyCode);
        if (!TPKey.isKeyPadKey(keyCode)) {
            if (TPKey.isJoystickKey(key)) {
                this.changeThumbLoc(key);
            } else if (key == 8) {
                if (!this.deleteWindowFlag) {
                    TP.wait.stopCanvas();
                    this.loadSelectedThumb();
                }
            } else if (keyCode == -7) {
                if (this.deleteWindowFlag) {
                    this.deleteWindowFlag = false;
                    this.redraw = false;
                    TP.thumb.repaint();
                } else {
                    TP.wait.stopCanvas();
                    TP.returnToPreviousScreen();
                }
            } else if (keyCode == -6 && TP.menu.onlineMenuIndex == 3) {
                if (!this.deleteWindowFlag) {
                    this.deleteWindowFlag = true;
                    TP.thumb.repaint();
                } else {
                    this.deleteFlg = true;
                    this.deleteWindowFlag = false;
                    TP.connect.go(8);
                }
            }
        }
    }

    void showDelete(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0x999999);
        g.setFont(TPUtil.FONT_SMALL);
        g.drawString(TPLocale.getMessage("DeleteQuestion"), TP.wait.stringX, TP.wait.stringY, 20);
    }
}

