/*
 * Decompiled with CFR 0.152.
 */
package com.sony.mutwo.lib;

import java.io.InputStream;

public class Id3Parser {
    public static final int ID3TAG_HEADER_SIZE = 10;
    protected static final byte[][] GEOB_SMFMF_HEADERS;

    static {
        byte[][] byArrayArray = new byte[3][];
        byte[] byArray = new byte[41];
        byArray[0] = 2;
        byArray[1] = 65;
        byArray[2] = 112;
        byArray[3] = 112;
        byArray[4] = 108;
        byArray[5] = 105;
        byArray[6] = 99;
        byArray[7] = 97;
        byArray[8] = 116;
        byArray[9] = 105;
        byArray[10] = 111;
        byArray[11] = 110;
        byArray[12] = 47;
        byArray[13] = 83;
        byArray[14] = 77;
        byArray[15] = 70;
        byArray[16] = 77;
        byArray[17] = 70;
        byArray[22] = 85;
        byArray[24] = 83;
        byArray[26] = 82;
        byArray[28] = 95;
        byArray[30] = 83;
        byArray[32] = 77;
        byArray[34] = 70;
        byArray[36] = 77;
        byArray[38] = 70;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[43];
        byArray2[0] = 1;
        byArray2[1] = 65;
        byArray2[2] = 112;
        byArray2[3] = 112;
        byArray2[4] = 108;
        byArray2[5] = 105;
        byArray2[6] = 99;
        byArray2[7] = 97;
        byArray2[8] = 116;
        byArray2[9] = 105;
        byArray2[10] = 111;
        byArray2[11] = 110;
        byArray2[12] = 47;
        byArray2[13] = 83;
        byArray2[14] = 77;
        byArray2[15] = 70;
        byArray2[16] = 77;
        byArray2[17] = 70;
        byArray2[21] = -2;
        byArray2[22] = -1;
        byArray2[24] = 85;
        byArray2[26] = 83;
        byArray2[28] = 82;
        byArray2[30] = 95;
        byArray2[32] = 83;
        byArray2[34] = 77;
        byArray2[36] = 70;
        byArray2[38] = 77;
        byArray2[40] = 70;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[30];
        byArray3[1] = 65;
        byArray3[2] = 112;
        byArray3[3] = 112;
        byArray3[4] = 108;
        byArray3[5] = 105;
        byArray3[6] = 99;
        byArray3[7] = 97;
        byArray3[8] = 116;
        byArray3[9] = 105;
        byArray3[10] = 111;
        byArray3[11] = 110;
        byArray3[12] = 47;
        byArray3[13] = 83;
        byArray3[14] = 77;
        byArray3[15] = 70;
        byArray3[16] = 77;
        byArray3[17] = 70;
        byArray3[20] = 85;
        byArray3[21] = 83;
        byArray3[22] = 82;
        byArray3[23] = 95;
        byArray3[24] = 83;
        byArray3[25] = 77;
        byArray3[26] = 70;
        byArray3[27] = 77;
        byArray3[28] = 70;
        byArrayArray[2] = byArray3;
        GEOB_SMFMF_HEADERS = byArrayArray;
    }

    protected static int getFrameHeaderSize(int ver) {
        return ver == 2 ? 6 : 10;
    }

    protected static int getFrameIdLength(int ver) {
        return ver == 2 ? 3 : 4;
    }

    protected static int getFrameSizeLength(int ver) {
        return ver == 2 ? 3 : 4;
    }

    protected static String getGeobFrameIdString(int ver) {
        return ver == 2 ? "GEO" : "GEOB";
    }

    public static byte[] extractSmfmfByteArray(InputStream is) {
        byte[] header = new byte[10];
        byte version = 0;
        int size = 0;
        try {
            if (is.read(header) != 10) {
                throw new Exception();
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < header.length) {
                char ch = (char)header[i];
                sb.append(ch);
                ++i;
            }
            if (header[0] != 73 || header[1] != 68 || header[2] != 51) {
                throw new Exception();
            }
            version = header[3];
            size = (header[6] & 0x7F) * 128 * 128 * 128 + (header[7] & 0x7F) * 128 * 128 + (header[8] & 0x7F) * 128 + (header[9] & 0x7F);
            if (version != 2 && version != 3 && version != 4) {
                throw new Exception();
            }
            int frameHeaderLength = Id3Parser.getFrameHeaderSize(version);
            int frameIdLength = Id3Parser.getFrameIdLength(version);
            int frameSizeLength = Id3Parser.getFrameSizeLength(version);
            int totalRead = 0;
            while (totalRead < size) {
                byte[] frameHeader = new byte[frameHeaderLength];
                if (is.read(frameHeader) != frameHeaderLength) {
                    throw new Exception();
                }
                totalRead += frameHeaderLength;
                int frameSize = 0;
                int i2 = 0;
                while (i2 < frameSizeLength) {
                    frameSize += frameSize * 255 + (frameHeader[frameIdLength + i2] & 0xFF);
                    ++i2;
                }
                if (frameSize != 0) {
                    String frameIdString = new String(frameHeader, 0, frameIdLength);
                    if (frameIdString.equals(Id3Parser.getGeobFrameIdString(version))) {
                        byte[] geobFrame = new byte[frameSize];
                        if (is.read(geobFrame) != geobFrame.length) {
                            throw new Exception();
                        }
                        int geobHeaderSize = 0;
                        boolean isSmfmf = false;
                        int i3 = 0;
                        while (i3 < GEOB_SMFMF_HEADERS.length) {
                            if (GEOB_SMFMF_HEADERS[i3].length <= geobFrame.length) {
                                isSmfmf = true;
                                int j = 0;
                                while (j < GEOB_SMFMF_HEADERS[i3].length) {
                                    if (GEOB_SMFMF_HEADERS[i3][j] != geobFrame[j]) {
                                        isSmfmf = false;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            if (isSmfmf) {
                                geobHeaderSize = GEOB_SMFMF_HEADERS[i3].length;
                                break;
                            }
                            ++i3;
                        }
                        if (!isSmfmf) continue;
                        byte[] smfmf = new byte[geobFrame.length - geobHeaderSize];
                        System.arraycopy(geobFrame, geobHeaderSize, smfmf, 0, smfmf.length);
                        return smfmf;
                    }
                    if (is.skip(frameSize) != (long)frameSize) {
                        throw new Exception();
                    }
                    totalRead += frameSize;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return null;
    }
}

