/*
 * Decompiled with CFR 0.152.
 */
package com.sony.mutwo.musicplayer;

import com.mbounce.avatar.cavas.MainCanvas;
import com.mbounce.avatar.io.ResourceLoader;
import com.mbounce.avatar.logic.GamePlay;
import com.sony.mutwo.musicplayer.MusicPlayerListener;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MusicPlayer
implements PlayerListener {
    private Player m_player = null;
    private MusicPlayerListener m_playerListener = null;
    public static InputStream m_inputStream = null;
    public static String s_smusicType = "audio/mpeg";
    public static boolean m_MommoryFull = false;
    public String playException = null;
    public static long _time;
    public static int state;

    static {
        state = 0;
    }

    public int getState() {
        if (this.m_player != null) {
            return this.m_player.getState();
        }
        return -1;
    }

    public synchronized void close() {
        if (this.m_player != null) {
            this.m_player.close();
            this.m_player = null;
        }
        if (m_inputStream != null) {
            try {
                m_inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            m_inputStream = null;
        }
    }

    public void LoadSound() {
        m_MommoryFull = false;
        this.close();
        try {
            FileConnection fc = (FileConnection)Connector.open((String)ResourceLoader.localPath);
            fc.exists();
            m_inputStream = fc.openInputStream();
            this.m_player = Manager.createPlayer((InputStream)m_inputStream, (String)s_smusicType);
            this.m_player.realize();
        }
        catch (Exception e) {
            this.playException = e.toString();
            MainCanvas.setErroCheck(this.playException);
            e.printStackTrace();
        }
        if (this.m_player == null) {
            m_MommoryFull = true;
        }
    }

    public void play(String path, long startPos) {
        GamePlay.flagTime = 0L;
        GamePlay.speicedPause = false;
        try {
            if (this.m_player == null) {
                throw new Exception();
            }
            this.m_player.addPlayerListener((PlayerListener)this);
            this.m_player.realize();
            if (startPos > 0L) {
                this.seek(startPos);
            }
            this.m_player.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (this.m_player != null) {
            try {
                this.m_player.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void seek(long seekPos) {
        try {
            if (this.m_player != null) {
                this.m_player.setMediaTime(seekPos * 1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int getVolume() {
        VolumeControl vc;
        int level = 0;
        if (this.m_player != null && (vc = (VolumeControl)this.m_player.getControl("VolumeControl")) != null) {
            level = vc.getLevel();
        }
        return level;
    }

    public synchronized void setVolume(int level) {
        VolumeControl vc;
        if (this.m_player != null && (vc = (VolumeControl)this.m_player.getControl("VolumeControl")) != null) {
            vc.setLevel(level);
        }
    }

    public synchronized long getDuration() {
        return this.m_player == null ? 0L : this.m_player.getDuration() / 1000L;
    }

    public synchronized long getCurrentPosition() {
        return this.m_player == null ? 0L : this.m_player.getMediaTime() / 1000L;
    }

    public void playerUpdate(Player p, String evt, Object evtData) {
        if (this.m_playerListener != null) {
            if (evt == "endOfMedia") {
                this.m_playerListener.onUpdatePlayerStatus(0);
            } else if (evt == "started") {
                this.m_playerListener.onUpdatePlayerStatus(1);
            } else if (evt == "stopped") {
                System.out.println(" VVVVVVVVVVVVVVV  over");
                this.m_playerListener.onUpdatePlayerStatus(2);
            }
        }
    }

    public boolean isPlaying() {
        boolean bPlaying = false;
        if (this.m_player != null) {
            state = this.m_player.getState();
            _time = this.m_player.getMediaTime() / 1000L;
            int state = this.m_player.getState();
            if (state == 400) {
                bPlaying = true;
            }
        }
        return bPlaying;
    }

    public void setPlayerListener(MusicPlayerListener listener) {
        this.m_playerListener = listener;
    }
}

