/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.wm.app;

import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.ams.NoSuchApplicationException;
import com.sonyericsson.homescreen.Homescreen;
import com.sonyericsson.homescreen.HomescreenMIDlet;
import com.sonyericsson.wm.app.Controller;
import com.sonyericsson.wm.log.Log;
import com.sonyericsson.wm.model.Model;
import com.sonyericsson.wm.model.WidgetModel;
import com.sonyericsson.wm.state.FocusedState;
import com.sonyericsson.wm.state.ManagementState;
import com.sonyericsson.wm.state.NavigationState;
import com.sonyericsson.wm.state.StandbyState;
import com.sonyericsson.wm.state.StateController;
import com.sonyericsson.wm.view.FocusedView;
import com.sonyericsson.wm.view.ManagementView;
import com.sonyericsson.wm.view.NavigationView;
import com.sonyericsson.wm.view.StandbyView;
import com.sonyericsson.wm.view.ViewManager;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public final class App
extends HomescreenMIDlet {
    private final Controller controller;
    private final Thread widgetStartupThread;

    public App() {
        try {
            String version = this.getAppProperty("MIDlet-Version");
            if (version == null) {
                version = "unknown";
            }
            Log.log("starting, " + version + " delivery");
            String log = this.getAppProperty("SEMC-WidgetManager-LogEnabled");
            Log.setEnabled("Y".equalsIgnoreCase(log));
            Homescreen homescreen = this.getHomescreen();
            final Model model = new Model();
            Display display = Display.getDisplay((MIDlet)this);
            final ViewManager manager = new ViewManager(display);
            StandbyView standbyView = new StandbyView(display, homescreen, manager, model);
            final StandbyState standbyState = new StandbyState(homescreen, model, standbyView);
            NavigationView navigationView = new NavigationView(display, homescreen, manager, model);
            NavigationState navigationState = new NavigationState(homescreen, model, navigationView);
            FocusedView focusedView = new FocusedView(display, homescreen, manager, model);
            FocusedState focusedState = new FocusedState(homescreen, model, focusedView);
            ManagementView managementView = new ManagementView(display, homescreen, manager, model);
            ManagementState managementState = new ManagementState(homescreen, model, managementView);
            StateController stateController = new StateController(model, focusedState, managementState, navigationState, standbyState);
            this.controller = new Controller(homescreen, model, manager, stateController);
            this.widgetStartupThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Log.log("Initial loading of widgets begin...");
                    try {
                        model.getWidgetModel().setWidgets(App.this.scanForWidgets());
                        model.restoreRunningState();
                        Object object = ((App)App.this).controller.exitingLock;
                        synchronized (object) {
                            if (!((App)App.this).controller.exiting) {
                                standbyState.updateArrowShown();
                                standbyState.showDateTimeInfo();
                            }
                        }
                        manager.setController(App.this.controller);
                        Log.log("Initial loading of widgets done...");
                    }
                    catch (InterruptedException e) {
                        Log.log("Initial loading of widgets interrupted");
                    }
                }
            };
            this.widgetStartupThread.start();
        }
        catch (Throwable e) {
            Log.log(String.valueOf(e.getClass().getName()) + " " + e.getMessage());
            throw new RuntimeException();
        }
    }

    private Vector scanForWidgets() {
        Vector widgets = new Vector(16);
        try {
            ApplicationManager applicationManager = ApplicationManager.getApplicationManager();
            Application[] apps = applicationManager.getApplications();
            int i = 0;
            while (i < apps.length) {
                Application app = apps[i];
                if (this.isWidget(app)) {
                    if (app.getStatus() != 2) {
                        try {
                            Log.log("Stopping " + app.getSuiteName());
                            app.stop();
                        }
                        catch (IllegalStateException illegalStateException) {
                        }
                        catch (NoSuchApplicationException noSuchApplicationException) {
                        }
                        catch (Error error) {
                            // empty catch block
                        }
                    }
                    WidgetModel.addWidgetToVector(widgets, app);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.log("WidgetLoader.load():" + e.getClass().getName());
        }
        return widgets;
    }

    private boolean isWidget(Application app) {
        return "idlescreen".equalsIgnoreCase(app.getProperty("MIDlet-Category-1"));
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (this.widgetStartupThread.isAlive()) {
            this.widgetStartupThread.interrupt();
        }
        this.controller.destroyApp(unconditional);
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
    }
}

