/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.wm.app;

import com.sonyericsson.homescreen.Homescreen;
import com.sonyericsson.homescreen.KeyListener;
import com.sonyericsson.homescreen.idleitem.IdleItemEventData;
import com.sonyericsson.homescreen.idleitem.IdleItemListener;
import com.sonyericsson.homescreen.idleitem.IdleItemManager;
import com.sonyericsson.homescreen.idleitem.IdleItemProxy;
import com.sonyericsson.wm.log.Log;
import com.sonyericsson.wm.model.IdleItemModel;
import com.sonyericsson.wm.model.Model;
import com.sonyericsson.wm.state.State;
import com.sonyericsson.wm.state.StateController;
import com.sonyericsson.wm.view.ViewManager;
import com.sonyericsson.wm.view.VisibilityListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.midlet.MIDletStateChangeException;

public final class Controller
implements KeyListener,
IdleItemListener,
VisibilityListener {
    private Homescreen homescreen;
    boolean exiting = false;
    Object exitingLock = new Object();
    private final ViewManager manager;
    private final Model model;
    private final StateController stateController;
    private final Timer timer = new Timer();

    public Controller(Homescreen homescreen, Model model, ViewManager manager, StateController stateController) {
        this.homescreen = homescreen;
        this.model = model;
        this.manager = manager;
        this.stateController = stateController;
        IdleItemManager idleItemManager = IdleItemManager.getInstance();
        idleItemManager.addIdleItemListener((IdleItemListener)this);
        homescreen.addKeyListener((KeyListener)this);
        homescreen.setTransparent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (!unconditional) {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    Controller.this.stateController.changeState(7);
                    Controller.this.manager.repaint();
                }
            }, 0L);
            throw new MIDletStateChangeException();
        }
        Object object = this.exitingLock;
        synchronized (object) {
            this.exiting = true;
            this.homescreen.unregister();
            this.model.stopAllWidgets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idleItemEvent(final IdleItemEventData data) {
        Object object = this.exitingLock;
        synchronized (object) {
            if (this.exiting) {
                return;
            }
            State currentState = this.stateController.getCurrentState();
            final IdleItemProxy proxy = data.getIdleItemProxy();
            final IdleItemModel idleItemModel = this.model.getIdleItemModel();
            switch (data.getEventType()) {
                case 0: {
                    Log.log("IdleItem ADDED (" + this.model.getProxyName(proxy) + ")");
                    currentState.idleItemAdded(proxy);
                    break;
                }
                case 1: {
                    Log.log("IdleItem REMOVED");
                    if (proxy == idleItemModel.getCurrent()) {
                        idleItemModel.setProxyInFocus(false);
                        currentState.handleCurrentItemRemoved();
                    }
                    idleItemModel.remove(proxy);
                    break;
                }
                case 2: {
                    Log.log("IdleItem RESIZE_REQUESTED (" + this.model.getProxyName(proxy) + ")");
                    break;
                }
                case 4: {
                    Log.log("IdleItem RED_KEY_PRESSED (" + this.model.getProxyName(proxy) + ")");
                    this.stateController.changeState(7);
                    break;
                }
                case 3: {
                    Log.log("IdleItem TRAVERSE_OUT_RECEIVED (" + this.model.getProxyName(proxy) + ")");
                    this.timer.schedule(new TimerTask(){

                        public void run() {
                            Controller.this.stateController.traverseOut(proxy, (Integer)data.getData());
                        }
                    }, 0L);
                    break;
                }
                case 5: {
                    Log.log("IdleItem TRAVERSE_REPLY (" + this.model.getProxyName(proxy) + ")");
                    final Integer v = (Integer)data.getData();
                    this.timer.schedule(new TimerTask(){

                        public void run() {
                            if (v == 0) {
                                Controller.this.stateController.traverseAborted();
                            } else if (v == 1) {
                                idleItemModel.setProxyInFocus(true);
                                Controller.this.stateController.changeStateToFocused();
                            }
                        }
                    }, 0L);
                    break;
                }
                case 6: {
                    Log.log("WIDGET INSTALLED");
                    this.timer.schedule(new TimerTask(){

                        public void run() {
                            Controller.this.model.getWidgetModel().widgetInstalled((String[])data.getData());
                        }
                    }, 0L);
                    break;
                }
                case 7: {
                    Log.log("WIDGET UNINSTALLED");
                    this.timer.schedule(new TimerTask(){

                        public void run() {
                            Controller.this.model.getWidgetModel().widgetDeleted((String[])data.getData());
                        }
                    }, 0L);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(final int key) {
        Object object = this.exitingLock;
        synchronized (object) {
            if (this.exiting) {
                return;
            }
            this.timer.schedule(new TimerTask(){

                public void run() {
                    if (key == 7) {
                        Controller.this.stateController.changeState(key);
                    } else {
                        Controller.this.stateController.keyPressed(key);
                    }
                }
            }, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visibilityChanged(boolean becameVisible) {
        Object object = this.exitingLock;
        synchronized (object) {
            if (this.exiting) {
                return;
            }
            if (becameVisible) {
                this.stateController.showNotify();
            } else {
                this.stateController.hideNotify();
            }
        }
    }
}

