/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.wm.model;

import com.sonyericsson.homescreen.idleitem.IdleItemProxy;
import com.sonyericsson.wm.log.Log;
import com.sonyericsson.wm.model.IdleItemModel;
import com.sonyericsson.wm.model.Model;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public final class DataStorage {
    private static final String FIELD_DELIMITER = ",";
    private static final String LINE_DELIMITER = ";";
    private static final String REC_STORE = "hsman_db";
    private static final int RECORD_ID = 1;
    private RecordStore rs;

    public static DataStorage getInstance() {
        return Holder.INSTANCE;
    }

    private DataStorage() {
    }

    synchronized void loadRunningWidgetsState(Vector runningWidgets) throws IOException {
        Log.log("load running state from storage");
        try {
            this.openRecordStore();
            int numberOfRecords = 0;
            numberOfRecords = this.rs.getNumRecords();
            if (numberOfRecords > 0) {
                byte[] dataBytes = this.rs.getRecord(1);
                String data = new String(dataBytes);
                this.parseDataAndUpdateModel(data, runningWidgets);
            }
        }
        catch (Exception e) {
            Log.log("Error when loading model!");
            throw new IOException(e.getClass().getName());
        }
    }

    public synchronized void saveRunningWidgetsState(Model model) throws IOException {
        Log.log("Saving running state");
        try {
            this.openRecordStore();
            int numberOfRecords = 0;
            numberOfRecords = this.rs.getNumRecords();
            byte[] dataBytes = this.createData(model).getBytes();
            if (numberOfRecords == 0) {
                this.rs.addRecord(dataBytes, 0, dataBytes.length);
            } else {
                this.rs.setRecord(1, dataBytes, 0, dataBytes.length);
            }
        }
        catch (Exception e) {
            Log.log("Error when saving model!");
            throw new IOException(e.getClass().getName());
        }
    }

    private String createData(Model model) {
        IdleItemModel itemModel = model.getIdleItemModel();
        StringBuffer data = new StringBuffer();
        int i = 0;
        while (i < itemModel.size()) {
            IdleItemProxy proxy = itemModel.get(i);
            String name = proxy.getMIDletIdentity().getName();
            Log.log("Saving " + name);
            data.append(name);
            data.append(FIELD_DELIMITER);
            ++i;
        }
        data.append(LINE_DELIMITER);
        IdleItemProxy current = itemModel.getCurrent();
        if (current != null) {
            data.append(current.getMIDletIdentity().getName());
        }
        return data.toString();
    }

    private void openRecordStore() throws Exception {
        this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
    }

    private void parseDataAndUpdateModel(String data, Vector runningWidgets) {
        int lineIndex = data.indexOf(LINE_DELIMITER);
        if (lineIndex > 0) {
            String running = data.substring(0, lineIndex);
            int lastIndex = 0;
            int index = running.indexOf(FIELD_DELIMITER);
            while (index > 0) {
                String name = running.substring(lastIndex, index);
                Log.log("loading " + name);
                runningWidgets.addElement(name);
                lastIndex = index + 1;
                index = running.indexOf(FIELD_DELIMITER, lastIndex);
            }
        }
    }

    /* synthetic */ DataStorage(DataStorage dataStorage) {
        this();
    }

    private static final class Holder {
        private static final DataStorage INSTANCE = new DataStorage(null);

        private Holder() {
        }
    }
}

