/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.wm.model;

import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.ams.NoSuchApplicationException;
import com.sonyericsson.wm.log.Log;
import com.sonyericsson.wm.model.Listeners;
import com.sonyericsson.wm.util.Helper;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class WidgetData {
    private Application application;
    private int cachedStatus;
    private Image greyscaleIcon;
    private Image icon;
    private String name;
    private String suitename;
    private String vendor;
    private int x;
    private int y;

    private static Application getApplication(String suitename, String vendor) {
        return ApplicationManager.getApplicationManager().getApplication(suitename, vendor);
    }

    WidgetData(Application app) {
        this.application = app;
        this.cachedStatus = this.application.getStatus();
        this.name = this.getMIDletName(app);
        this.suitename = this.application.getSuiteName();
        this.vendor = this.application.getVendor();
        this.icon = this.getIcon(app, this.name);
        this.greyscaleIcon = Helper.getInstance().imageGreyScaled(this.icon);
    }

    WidgetData(String suitename, String vendor) {
        this.setup(suitename, vendor);
    }

    public synchronized void decouple() {
        this.application = null;
    }

    public synchronized int getCachedStatus() {
        return this.cachedStatus;
    }

    public synchronized int getCurrentStatus() {
        this.setupApplication();
        if (this.application != null) {
            this.cachedStatus = this.application.getStatus();
        }
        return this.cachedStatus;
    }

    public synchronized Image getIcon() {
        if (this.isStarted()) {
            return this.icon;
        }
        return this.greyscaleIcon;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getSuitename() {
        return this.suitename;
    }

    public synchronized int getX() {
        return this.x;
    }

    public synchronized int getY() {
        return this.y;
    }

    public synchronized boolean isEqual(String suitename, String vendor) {
        String txt = "CMP: w(" + this.suitename + ", " + this.vendor + ") = (" + suitename + ", " + vendor + ")";
        Log.log(txt);
        return this.suitename.equals(suitename) && this.vendor.equals(vendor);
    }

    public synchronized boolean isStarted() {
        return this.cachedStatus == 0 || this.cachedStatus == 3;
    }

    public synchronized void setPos(int x, int y, boolean notifyListeners) {
        boolean updated = this.x != x || this.y != y;
        this.x = x;
        this.y = y;
        if (notifyListeners && updated) {
            Log.log("setPos: Model updated");
            Listeners.getInstance().notifyListeners();
        }
    }

    public synchronized void setup(String suitename, String vendor) {
        this.application = WidgetData.getApplication(suitename, vendor);
        this.cachedStatus = this.application.getStatus();
        this.name = this.getMIDletName(this.application);
        this.suitename = suitename;
        this.vendor = vendor;
        this.icon = this.getIcon(this.application, this.name);
        this.greyscaleIcon = Helper.getInstance().imageGreyScaled(this.icon);
    }

    public synchronized void start() throws IOException {
        this.setupApplication();
        if (this.application != null) {
            try {
                this.application.start();
            }
            catch (IllegalStateException e) {
                throw new IOException();
            }
            catch (NoSuchApplicationException e) {
                throw new IOException();
            }
            catch (Error e) {
                throw new IOException();
            }
        }
    }

    public synchronized void stop() throws IOException {
        this.setupApplication();
        if (this.application != null) {
            try {
                this.application.stop();
            }
            catch (IllegalStateException e) {
                throw new IOException();
            }
            catch (NoSuchApplicationException e) {
                throw new IOException();
            }
            catch (Error e) {
                throw new IOException();
            }
        }
    }

    public synchronized void toggle() {
        this.setupApplication();
        if (this.application != null) {
            int expectedStatus;
            try {
                if (this.cachedStatus != 2) {
                    Log.log("TOGGLE: stop");
                    this.application.stop();
                    expectedStatus = 2;
                } else {
                    Log.log("TOGGLE: start");
                    this.application.start();
                    expectedStatus = 3;
                }
            }
            catch (IllegalStateException e) {
                return;
            }
            catch (NoSuchApplicationException e) {
                return;
            }
            catch (Error e) {
                return;
            }
            int sleepTime = 50;
            int counter = 100;
            while (counter-- > 0 && this.cachedStatus != expectedStatus) {
                this.updateCachedStatus();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Listeners.getInstance().notifyListeners();
        }
    }

    public synchronized void updateCachedStatus() {
        if (this.application == null) {
            this.application = WidgetData.getApplication(this.suitename, this.vendor);
        }
        if (this.application != null) {
            this.cachedStatus = this.application.getStatus();
        }
    }

    private Image createDefaultIcon(String name) {
        Image icon = Image.createImage((int)42, (int)42);
        Graphics g = icon.getGraphics();
        Helper utility = Helper.getInstance();
        utility.setAlphaColor(g, 255, 0);
        g.fillRect(0, 0, 42, 42);
        g.setColor(4749055);
        g.fillRoundRect(0, 0, 42, 42, 5, 5);
        Font font = g.getFont();
        String text = name.substring(0, 3);
        int x = (42 - font.stringWidth(text)) / 2;
        int y = (42 - font.getHeight()) / 2;
        g.setColor(0);
        g.drawString(text, x, y, 20);
        return icon;
    }

    private Image getIcon(Application app, String name) {
        InputStream is = null;
        try {
            is = app.getResourceAsStream(app.getProperty("MIDlet-Icon"));
            Image icon = Image.createImage((InputStream)is);
            if (icon.getWidth() > 42 || icon.getHeight() > 42) {
                Helper imageUtility = Helper.getInstance();
                icon = imageUtility.scaleImage(icon, 42, 42);
            }
            Image image = icon;
            return image;
        }
        catch (Exception e) {
            Image image = this.createDefaultIcon(name);
            return image;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String getMIDletName(Application app) {
        String name = app.getProperty("MIDlet-1");
        if (name == null) {
            return null;
        }
        int end = name.indexOf(44);
        String result = end >= 0 ? name.substring(0, end) : name;
        return result.trim();
    }

    private void setupApplication() {
        if (this.application == null) {
            this.application = WidgetData.getApplication(this.suitename, this.vendor);
        }
    }
}

