/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.wm.util;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Helper {
    private static final int NON_RUNNING_TRANSPARENCY = 102;

    public static Helper getInstance() {
        return Holder.INSTANCE;
    }

    private Helper() {
    }

    public Image imageGreyScaled(Image image) {
        Image greyImage;
        int[] rawInput = new int[image.getHeight() * image.getWidth()];
        image.getRGB(rawInput, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int i = 0;
        while (i < rawInput.length) {
            int grey;
            int argb = rawInput[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            r = grey = (int)(0.212671 * (double)r + 0.71516 * (double)g + 0.072169 * (double)b);
            g = grey;
            b = grey;
            argb = a > 102 ? 0x66000000 : a << 24;
            argb += (r & 0xFF) << 16;
            argb += (g & 0xFF) << 8;
            rawInput[i] = argb += b & 0xFF;
            ++i;
        }
        try {
            greyImage = Image.createRGBImage((int[])rawInput, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
        }
        catch (Exception e) {
            greyImage = image;
        }
        return greyImage;
    }

    public Image scaleImage(Image image, int newWidth, int newHeight) {
        int[] rawInput = new int[image.getHeight() * image.getWidth()];
        image.getRGB(rawInput, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int yD = image.getHeight() / newHeight * image.getWidth() - image.getWidth();
        int yR = image.getHeight() % newHeight;
        int xD = image.getWidth() / newWidth;
        int xR = image.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int yE = 0;
        while (y > 0) {
            int x = newWidth;
            int xE = 0;
            while (x > 0) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += xD;
                if ((xE += xR) >= newWidth) {
                    xE -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += yD;
            if ((yE += yR) >= newHeight) {
                yE -= newHeight;
                inOffset += image.getWidth();
            }
            --y;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)false);
    }

    public void setAlpha(Graphics g, int a) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.setARGBColor(a << 24 | g.getColor());
    }

    public void setAlphaColor(Graphics g, int a, int rgb) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.setARGBColor(a << 24 | rgb);
    }

    public void setColor(Graphics g, int rgb) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.setARGBColor(dg.getAlphaComponent() << 24 | rgb);
    }

    /* synthetic */ Helper(Helper helper) {
        this();
    }

    private static final class Holder {
        private static final Helper INSTANCE = new Helper(null);

        private Holder() {
        }
    }
}

