/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx;

import com.sonyericsson.kx.LoginData;
import com.sonyericsson.kx.RecordStoreAccess;
import com.sonyericsson.kx.StatusData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;

public class LoginDataAccess {
    static RecordStoreAccess store = new RecordStoreAccess();

    public static boolean loginDataExists() {
        return store.isDBExits("LOGONINFO");
    }

    public static boolean readConfig(LoginData data) {
        if (data == null) {
            return false;
        }
        byte[] buf = store.readData("LOGONINFO");
        if (buf == null) {
            return false;
        }
        LoginData dataA = LoginDataAccess.getData(buf);
        if (dataA == null) {
            return false;
        }
        data.strLogin = dataA.strLogin;
        data.strPassword = dataA.strPassword;
        data.bStorePassword = dataA.bStorePassword;
        data.nAutoUpdateFrequency = dataA.nAutoUpdateFrequency;
        data.bNetPrompt = dataA.bNetPrompt;
        data.bAutoRun = dataA.bAutoRun;
        data.strMagic = dataA.strMagic;
        return true;
    }

    public static boolean writeConfig(LoginData login) {
        return LoginDataAccess.writeConfig(login.strLogin, login.strPassword, login.bStorePassword, login.nAutoUpdateFrequency, login.bNetPrompt, login.bAutoRun);
    }

    private static boolean writeConfig(String login, String pwd, boolean storePwd, int freq, boolean bPrompt, boolean autorun) {
        byte[] temp = LoginDataAccess.getData(login, pwd, storePwd, freq, bPrompt, autorun);
        boolean bRet = store.addData("LOGONINFO", temp);
        return bRet;
    }

    public static LoginData getData(byte[] buf) {
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        LoginData data = null;
        try {
            data = new LoginData();
            bais = new ByteArrayInputStream(buf);
            dis = new DataInputStream(bais);
            data.strLogin = ((DataInputStream)dis).readUTF();
            data.strPassword = ((DataInputStream)dis).readUTF();
            data.bStorePassword = ((DataInputStream)dis).readBoolean();
            data.nAutoUpdateFrequency = ((DataInputStream)dis).readInt();
            data.bNetPrompt = ((DataInputStream)dis).readBoolean();
            data.bAutoRun = ((DataInputStream)dis).readBoolean();
            data.strMagic = ((DataInputStream)dis).readUTF();
            dis.close();
            dis = null;
            bais.close();
            bais = null;
        }
        catch (Exception e1) {
            try {
                if (dis != null) {
                    dis.close();
                    dis = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bais != null) {
                    bais.close();
                    bais = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            data = null;
            return data;
        }
        if (data.strMagic != null && data.strMagic.compareTo("JW_MAGIC") == 0) {
            return data;
        }
        data = null;
        return data;
    }

    public static byte[] getData(String login, String pwd, boolean storePwd, int freq, boolean bPrompt, boolean autorun) {
        ByteArrayOutputStream baos = null;
        FilterOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            if (login == null) {
                ((DataOutputStream)dos).writeUTF("");
            } else {
                ((DataOutputStream)dos).writeUTF(login);
            }
            if (pwd == null) {
                ((DataOutputStream)dos).writeUTF("");
            } else {
                ((DataOutputStream)dos).writeUTF(pwd);
            }
            ((DataOutputStream)dos).writeBoolean(storePwd);
            ((DataOutputStream)dos).writeInt(freq);
            ((DataOutputStream)dos).writeBoolean(bPrompt);
            ((DataOutputStream)dos).writeBoolean(autorun);
            ((DataOutputStream)dos).writeUTF("JW_MAGIC");
            ((DataOutputStream)dos).flush();
            byte[] buf = baos.toByteArray();
            dos.close();
            dos = null;
            baos.close();
            baos = null;
            return buf;
        }
        catch (Exception e1) {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (baos != null) {
                    baos.close();
                }
                baos = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static byte[] getData(int[] data) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            try {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                if (data == null || data.length < 1) {
                    ((DataOutputStream)dos).writeInt(-1);
                } else {
                    ((DataOutputStream)dos).writeInt(data.length);
                    int i = 0;
                    while (i < data.length) {
                        ((DataOutputStream)dos).writeInt(data[i]);
                        ++i;
                    }
                }
                ((DataOutputStream)dos).flush();
                result = bos.toByteArray();
            }
            catch (Exception exception) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    dos = null;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    bos = null;
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
                bos = null;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static int[] getIntArray(byte[] data) {
        block27: {
            int[] nArray;
            if (data == null) {
                return null;
            }
            int[] result = null;
            ByteArrayInputStream bais = null;
            DataInputStream dis = null;
            try {
                bais = new ByteArrayInputStream(data);
                dis = new DataInputStream(bais);
                int len = dis.readInt();
                if (len == -1) {
                    return null;
                }
                result = new int[len];
                int i = 0;
                while (i < len) {
                    result[i] = dis.readInt();
                    ++i;
                }
                nArray = result;
            }
            catch (Exception exception) {
                break block27;
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                    bais = null;
                }
                catch (Exception exception) {}
                try {
                    if (dis != null) {
                        dis.close();
                    }
                    dis = null;
                }
                catch (Exception exception) {}
            }
            return nArray;
        }
        return null;
    }

    public static byte[] getData(String[] str) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            bos = new ByteArrayOutputStream();
            dos = new DataOutputStream(bos);
            if (str == null) {
                return null;
            }
            try {
                int len = str.length;
                ((DataOutputStream)dos).writeInt(len);
                int i = 0;
                while (i < len) {
                    if (str[i] == null) {
                        ((DataOutputStream)dos).writeUTF("");
                    } else {
                        ((DataOutputStream)dos).writeUTF(str[i]);
                    }
                    ++i;
                }
                ((DataOutputStream)dos).flush();
                result = bos.toByteArray();
            }
            catch (Exception exception) {}
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
                bos = null;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String[] getString(byte[] data) {
        if (data == null) {
            return null;
        }
        String[] result = null;
        ByteArrayInputStream bais = null;
        DataInputStream dis = null;
        try {
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            int len = dis.readInt();
            if (len > 0) {
                result = new String[len];
                int i = 0;
                while (i < len) {
                    result[i] = dis.readUTF();
                    ++i;
                }
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
                bais = null;
            }
            catch (Exception exception) {}
            try {
                if (dis != null) {
                    dis.close();
                }
                dis = null;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static byte[] getData(String str, byte[] imgdata) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            try {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                if (str == null) {
                    ((DataOutputStream)dos).writeUTF("");
                } else {
                    ((DataOutputStream)dos).writeUTF(str);
                }
                if (imgdata == null) {
                    ((DataOutputStream)dos).writeInt(-1);
                } else {
                    int size = imgdata.length;
                    ((DataOutputStream)dos).writeInt(size);
                    ((OutputStream)dos).write(imgdata);
                }
                ((DataOutputStream)dos).flush();
                result = bos.toByteArray();
            }
            catch (Exception exception) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    dos = null;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    bos = null;
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
                bos = null;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static StatusData getStatus(byte[] data) {
        if (data == null) {
            return null;
        }
        StatusData result = null;
        ByteArrayInputStream bais = null;
        DataInputStream dis = null;
        try {
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            result = new StatusData();
            result.name = dis.readUTF();
            result.note = dis.readUTF();
            result.time = dis.readUTF();
            int len = dis.readInt();
            if (len == -1) {
                result.iconData = null;
            } else {
                result.iconData = new byte[len];
                dis.read(result.iconData);
            }
            StatusData statusData = result;
            return statusData;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
                bais = null;
            }
            catch (Exception exception) {}
            try {
                if (dis != null) {
                    dis.close();
                }
                dis = null;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static byte[] getData(String name, String str, String ctime, byte[] imgdata) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        try {
            try {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                if (name == null) {
                    ((DataOutputStream)dos).writeUTF("");
                } else {
                    ((DataOutputStream)dos).writeUTF(name);
                }
                if (str == null) {
                    ((DataOutputStream)dos).writeUTF("");
                } else {
                    ((DataOutputStream)dos).writeUTF(str);
                }
                if (ctime == null) {
                    ((DataOutputStream)dos).writeUTF("");
                } else {
                    ((DataOutputStream)dos).writeUTF(ctime);
                }
                if (imgdata == null) {
                    ((DataOutputStream)dos).writeInt(-1);
                } else {
                    int size = imgdata.length;
                    ((DataOutputStream)dos).writeInt(size);
                    ((OutputStream)dos).write(imgdata);
                }
                ((DataOutputStream)dos).flush();
                result = bos.toByteArray();
            }
            catch (Exception exception) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    dos = null;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    bos = null;
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
                bos = null;
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

